/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.msutil.AminoAcid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class NominalMassAASet {
    private Integer[] nominalMassArr;
    private HashMap<Integer, Integer> nominalMassNumTable = new HashMap();
    private HashMap<Integer, Float> nominalMassProbTable = new HashMap();
    private HashMap<Integer, ArrayList<AminoAcid>> nominalMassAATable = new HashMap();

    public NominalMassAASet(ArrayList<AminoAcid> aaList) {
        for (AminoAcid aa : aaList) {
            float aaProb = aa.getProbability();
            int nominalMass = aa.getNominalMass();
            Integer nNum = this.nominalMassNumTable.get(nominalMass);
            if (nNum == null) {
                this.nominalMassNumTable.put(nominalMass, 1);
                this.nominalMassProbTable.put(nominalMass, Float.valueOf(aaProb));
                ArrayList<AminoAcid> newAAList = new ArrayList<AminoAcid>();
                newAAList.add(aa);
                this.nominalMassAATable.put(nominalMass, newAAList);
                continue;
            }
            this.nominalMassNumTable.put(nominalMass, nNum + 1);
            this.nominalMassProbTable.put(nominalMass, Float.valueOf(this.nominalMassProbTable.get(nominalMass).floatValue() + aaProb));
            ArrayList<AminoAcid> existingAAList = this.nominalMassAATable.get(nominalMass);
            existingAAList.add(aa);
        }
        this.nominalMassArr = this.nominalMassNumTable.keySet().toArray(new Integer[0]);
        Arrays.sort((Object[])this.nominalMassArr);
    }

    public Integer[] getDistinctNominalMasses() {
        return this.nominalMassArr;
    }

    public int getNumAAWithNominalMass(int nominalMass) {
        Integer num = this.nominalMassNumTable.get(nominalMass);
        if (num == null) {
            return 0;
        }
        return num;
    }

    public float getSumProbWithNominalMass(int nominalMass) {
        Float prob = this.nominalMassProbTable.get(nominalMass);
        if (prob == null) {
            return 0.0f;
        }
        return prob.floatValue();
    }

    public ArrayList<AminoAcid> getAAListWithNominalMass(int nominalMass) {
        return this.nominalMassAATable.get(nominalMass);
    }
}

