/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.msgf.IntMassFactory;
import edu.ucsd.msjava.msgf.MassListComparator;
import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Composition;
import edu.ucsd.msjava.msutil.Enzyme;
import edu.ucsd.msjava.msutil.Modification;
import edu.ucsd.msjava.msutil.Sequence;
import edu.ucsd.msjava.msutil.VolatileAminoAcid;
import edu.ucsd.msjava.params.ParamManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class Peptide
extends Sequence<AminoAcid>
implements Comparable<Peptide> {
    private static final long serialVersionUID = 1L;
    static final int MAX_LENGTH = 30;
    private boolean isModified;
    static final boolean FAIL_WHEN_PEPTIDE_IS_MODIFIED = false;
    private boolean isInvalid = false;

    public Peptide(String sequence, AminoAcidSet aaSet) {
        char c;
        this.isModified = false;
        int seqLen = sequence.length();
        int index = 0;
        float nTermModMass = 0.0f;
        while (index < seqLen && ((c = sequence.charAt(index)) == '-' || c == '+')) {
            int startIndex = index;
            while (++index < seqLen && (Character.isDigit(c = sequence.charAt(index)) || c == '.')) {
            }
            nTermModMass += Float.parseFloat(sequence.substring(startIndex, index));
        }
        boolean isNTerm = true;
        while (index < seqLen) {
            AminoAcid aa;
            char c2 = sequence.charAt(index);
            assert (Character.isLetter(c2)) : "Error in string at index " + index;
            float mod = 0.0f;
            if (index + 1 < seqLen) {
                char sign = sequence.charAt(index + 1);
                while (sign == '-' || sign == '+') {
                    int endModIdx;
                    assert (index + 2 < seqLen) : "Missing value after \"" + sign + "\"";
                    assert (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z') : "Error in string at index " + index + 2;
                    int startModIdx = index + 2;
                    for (endModIdx = startModIdx + 1; endModIdx < seqLen && (sequence.charAt(endModIdx) == '.' || sequence.charAt(endModIdx) >= '0' && sequence.charAt(endModIdx) <= '9'); ++endModIdx) {
                    }
                    float modMass = Float.parseFloat(sequence.substring(startModIdx, endModIdx));
                    if (sign == '-') {
                        modMass *= -1.0f;
                    }
                    mod += modMass;
                    index = endModIdx - 1;
                    if (endModIdx >= sequence.length()) break;
                    sign = sequence.charAt(endModIdx);
                }
                if (index + 4 < seqLen && sign == 'p' && sequence.charAt(index + 2) == 'h') {
                    assert (sequence.charAt(index + 3) == 'o');
                    assert (sequence.charAt(index + 4) == 's');
                    mod = 79.96633f;
                    index += 4;
                } else if (index + 4 < seqLen && sign >= 'a' && sign <= 'z' && Character.toUpperCase(sign) == c2 && sequence.charAt(index + 2) == '-') {
                    assert (sequence.charAt(index + 3) == '>');
                    char mutatedResidue = sequence.charAt(index + 4);
                    assert (mutatedResidue >= 'a' && mutatedResidue <= 'z');
                    c2 = Character.toUpperCase(mutatedResidue);
                    index += 4;
                }
            }
            if (isNTerm) {
                aa = aaSet.getAminoAcid(Modification.Location.N_Term, c2);
                isNTerm = false;
            } else {
                aa = aaSet.getAminoAcid(c2);
            }
            if (!Character.isUpperCase(c2) || aa == null) {
                this.isInvalid = true;
                return;
            }
            if (this.size() == 0) {
                mod += nTermModMass;
            }
            if (mod == 0.0f) {
                this.add(aa);
            } else {
                this.isModified = true;
                float mass = aa.getMass() + mod;
                AminoAcid modAA = VolatileAminoAcid.getVolatileAminoAcid(mass);
                this.add(modAA);
            }
            ++index;
        }
    }

    public Peptide(String sequence) {
        this(sequence, AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys());
    }

    public Peptide(ArrayList<AminoAcid> aaArray) {
        for (AminoAcid aa : aaArray) {
            assert (aa != null) : "Null amino acid";
            this.add(aa);
        }
    }

    public Peptide(List<AminoAcid> aaArray) {
        for (AminoAcid aa : aaArray) {
            assert (aa != null) : "Null amino acid";
            this.add(aa);
        }
    }

    public Peptide(AminoAcid[] aaArray) {
        for (AminoAcid aa : aaArray) {
            this.add(aa);
        }
    }

    public Peptide subPeptide(int fromIndex, int toIndex) {
        return (Peptide)super.subSequence(fromIndex, toIndex);
    }

    public Peptide setModified() {
        this.isModified = true;
        return this;
    }

    public Peptide setModified(boolean isModified) {
        this.isModified = isModified;
        return this;
    }

    public boolean[] getBooleanPeptide() {
        boolean[] boolPeptide = new boolean[this.getNominalMass() + 1];
        int mass = 0;
        for (AminoAcid aa : this) {
            boolPeptide[mass += aa.getNominalMass()] = true;
        }
        return boolPeptide;
    }

    public boolean isGappedPeptideTrue(ArrayList<Integer> gp) {
        boolean[] boolPeptide = this.getBooleanPeptide();
        boolean isTrue = true;
        for (int m : gp) {
            if (boolPeptide[m]) continue;
            isTrue = boolPeptide[m];
        }
        return isTrue;
    }

    public boolean isInvalid() {
        return this.isInvalid;
    }

    public boolean isCTermModified() {
        return this.get(this.size() - 1).isModified();
    }

    public boolean hasTrypticCTerm() {
        AminoAcid cTerm = this.get(this.size() - 1);
        return !this.isCTermModified() && (cTerm == AminoAcid.getStandardAminoAcid('K') || cTerm == AminoAcid.getStandardAminoAcid('R'));
    }

    public boolean hasCleavageSite(Enzyme enzyme) {
        AminoAcid target = enzyme.isCTerm() ? this.get(this.size() - 1) : this.get(0);
        return enzyme.isCleavable(target);
    }

    @Override
    public AminoAcid get(int i) {
        if (i <= -1) {
            return null;
        }
        if (i >= this.size()) {
            return null;
        }
        return (AminoAcid)super.get(i);
    }

    @Override
    public int compareTo(Peptide other) {
        int minSize = Math.min(this.size(), other.size());
        for (int i = 0; i < minSize; ++i) {
            int r = this.get(i).compareTo(other.get(i));
            if (r == 0) continue;
            return r;
        }
        int r = this.size() - other.size();
        if (r > 0) {
            return 1;
        }
        if (r < 0) {
            return -1;
        }
        return 0;
    }

    public boolean equalsIgnoreIL(Peptide pep) {
        if (this.size() != pep.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            Composition c2;
            Composition c1 = this.get(i).getComposition();
            if (c1.equals(c2 = pep.get(i).getComposition())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuffer output = new StringBuffer();
        for (AminoAcid aa : this) {
            output.append(aa.getResidueStr());
        }
        return output.toString();
    }

    public Sequence<Composition> toCumulativeCompositionSequence(boolean isPrefix, Composition offset) {
        Sequence<Composition> seq = new Sequence<Composition>();
        Composition c = offset;
        for (int i = 0; i < this.size(); ++i) {
            if (isPrefix) {
                c = c.getAddition(this.get(i).getComposition());
                seq.add(c);
                continue;
            }
            c = c.getAddition(this.get(this.size() - 1 - i).getComposition());
            seq.add(c);
        }
        return seq;
    }

    public Sequence<Composition> toCompositionSequence() {
        Sequence<Composition> seq = new Sequence<Composition>();
        for (AminoAcid aa : this) {
            seq.add(aa.getComposition());
        }
        return seq;
    }

    public Sequence<Composition> toReverseCompositionSequence() {
        Sequence<Composition> seq = new Sequence<Composition>();
        for (int i = this.size() - 1; i >= 0; --i) {
            seq.add(this.get(i).getComposition());
        }
        return seq;
    }

    public Sequence<IntMassFactory.IntMass> toPrefixIntMassSequence(IntMassFactory factory) {
        Sequence<IntMassFactory.IntMass> seq = new Sequence<IntMassFactory.IntMass>();
        for (int i = 0; i < this.size(); ++i) {
            seq.add(factory.getInstance(this.get(i).getMass()));
        }
        return seq;
    }

    public Sequence<IntMassFactory.IntMass> toCumulativeIntMassSequence(boolean isPrefix, IntMassFactory factory) {
        Sequence<IntMassFactory.IntMass> seq = new Sequence<IntMassFactory.IntMass>();
        float mass = 0.0f;
        for (int i = 0; i < this.size(); ++i) {
            if (isPrefix) {
                seq.add(factory.getInstance(mass += this.get(i).getMass()));
                continue;
            }
            seq.add(factory.getInstance(mass += this.get(this.size() - 1 - i).getMass()));
        }
        return seq;
    }

    public Sequence<IntMassFactory.IntMass> toSuffixIntMassSequence(IntMassFactory factory) {
        Sequence<IntMassFactory.IntMass> seq = new Sequence<IntMassFactory.IntMass>();
        for (int i = this.size() - 1; i >= 0; --i) {
            seq.add(factory.getInstance(this.get(i).getMass()));
        }
        return seq;
    }

    public float getParentMass() {
        return this.getMass() + 18.010565f;
    }

    public int getNumSymmetricPeaks(Tolerance tolerance) {
        Sequence<Composition> bIons = this.toCumulativeCompositionSequence(true, new Composition(0, 1, 0, 0, 0));
        Sequence<Composition> yIons = this.toCumulativeCompositionSequence(false, new Composition(0, 3, 0, 1, 0));
        MassListComparator<Composition> comparator = new MassListComparator<Composition>(bIons, yIons);
        return comparator.getMatchedList(tolerance).length;
    }

    public int getNumSymmetricPeaks() {
        int numSymmPeaks = 0;
        HashSet<Integer> bIons = new HashSet<Integer>();
        int bMass = 1;
        for (int i = 0; i < this.size(); ++i) {
            bIons.add(bMass += this.get(i).getNominalMass());
        }
        int yMass = 19;
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!bIons.contains(yMass += this.get(i).getNominalMass())) continue;
            ++numSymmPeaks;
        }
        return numSymmPeaks;
    }

    public int getNominalMass() {
        int sum = 0;
        for (AminoAcid aa : this) {
            sum += aa.getNominalMass();
        }
        return sum;
    }

    public int getIntMassIndex(IntMassFactory factory) {
        int sum = 0;
        for (AminoAcid aa : this) {
            sum += factory.getMassIndex(aa.getMass());
        }
        return sum;
    }

    public Composition getComposition() {
        Composition c = new Composition(0);
        for (AminoAcid aa : this) {
            c.add(aa.getComposition());
        }
        return c;
    }

    public float getProbability() {
        float prob = 1.0f;
        for (int i = 0; i < this.size(); ++i) {
            AminoAcid aa = this.get(i);
            prob *= aa.getProbability();
        }
        return prob;
    }

    public float getNumber() {
        float number = 1.0f;
        AminoAcid aaL = AminoAcid.getStandardAminoAcid('L');
        AminoAcid aaI = AminoAcid.getStandardAminoAcid('I');
        AminoAcid aaQ = AminoAcid.getStandardAminoAcid('Q');
        AminoAcid aaK = AminoAcid.getStandardAminoAcid('K');
        for (int i = 0; i < this.size(); ++i) {
            AminoAcid aa = this.get(i);
            if (aa != aaL && aa != aaI && aa != aaQ && aa != aaK) continue;
            number *= 2.0f;
        }
        return number;
    }

    public Peptide slice(int from, int to) {
        from = Math.max(0, from);
        to = Math.min(this.size(), to);
        ArrayList<AminoAcid> aaList = new ArrayList<AminoAcid>();
        for (int i = from; i < to; ++i) {
            aaList.add(this.get(i));
        }
        if (aaList.size() > 0) {
            return new Peptide(aaList);
        }
        return null;
    }

    public static Peptide getSequence(String seq) {
        ArrayList<AminoAcid> aaList = new ArrayList<AminoAcid>();
        int seqLen = seq.length();
        for (int i = 0; i < seqLen; ++i) {
            aaList.add(AminoAcid.getStandardAminoAcid(seq.charAt(i)));
        }
        return new Peptide(aaList);
    }

    public boolean isCorrect(ArrayList<Integer> masses) {
        int cumMass = 0;
        int massIndex = 0;
        int targetMass = masses.get(massIndex++);
        for (AminoAcid aa : this) {
            if ((cumMass += aa.getNominalMass()) < targetMass) continue;
            if (cumMass == targetMass) {
                if (massIndex < masses.size()) {
                    targetMass += masses.get(massIndex++).intValue();
                    continue;
                }
                return true;
            }
            return false;
        }
        return massIndex == masses.size();
    }

    public static boolean isCorrect(String sequence, ArrayList<Integer> masses, AminoAcidSet aaSet) {
        int cumMass = 0;
        int massIndex = 0;
        int targetMass = masses.get(massIndex++);
        for (int i = 0; i < sequence.length(); ++i) {
            if ((cumMass += aaSet.getAminoAcid(sequence.charAt(i)).getNominalMass()) < targetMass) continue;
            if (cumMass == targetMass) {
                if (massIndex < masses.size()) {
                    targetMass += masses.get(massIndex++).intValue();
                    continue;
                }
                return true;
            }
            return false;
        }
        return massIndex == masses.size();
    }

    public static boolean isCorrect(String sequence, ArrayList<Integer> masses) {
        return Peptide.isCorrect(sequence, masses, AminoAcidSet.getStandardAminoAcidSet());
    }

    public float[] getPRMMasses(boolean isPrefix, float offset) {
        if (this.isModified) {
            return null;
        }
        float[] masses = new float[this.size() - 1];
        float mass = offset;
        for (int i = 0; i < this.size() - 1; ++i) {
            mass = isPrefix ? (mass += this.get(i).getMass()) : (mass += this.get(this.size() - 1 - i).getMass());
            masses[i] = mass;
        }
        return masses;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public static float getMassFromString(String peptide) {
        float cumMass = 0.0f;
        int i = peptide.length();
        int j = 0;
        while (i > 0) {
            cumMass += AminoAcid.getStandardAminoAcid(peptide.charAt(j)).getMass();
            --i;
            ++j;
        }
        return cumMass;
    }

    public static void main(String[] a) {
        ParamManager paramManager = new ParamManager("MS-GF+ Peptide", "Release (v2023.01.12)", "12 January 2023", "n/a");
        Path modFilePath = Paths.get(System.getProperty("user.home") + "Research", "ToolDistribution", "mods.txt");
        AminoAcidSet aaSet = AminoAcidSet.getAminoAcidSetFromModFile(modFilePath.toString(), paramManager);
        Peptide p = new Peptide("+42.011+15.995MDNKTPVTLAK", aaSet);
        System.out.println(p);
        for (AminoAcid aa : p) {
            System.out.println(aa.getResidueStr() + " " + aa.getMass());
        }
        System.out.println(p.getMass());
    }
}

