/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.parser.BufferedLineReader;
import edu.ucsd.msjava.parser.LineReader;
import edu.ucsd.msjava.parser.SpectrumParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;

public class SpectraIterator
implements Iterator<Spectrum>,
Iterable<Spectrum> {
    private String[] filenames = null;
    private String nextSpecFilePath;
    private int nextFileIndex;
    private SpectrumParser parser;
    private boolean hasNext;
    protected Spectrum currentSpectrum;
    LineReader lineReader;
    private int specIndex;

    public SpectraIterator(String fileName, SpectrumParser parser) throws IOException {
        this.nextSpecFilePath = fileName;
        this.lineReader = new BufferedLineReader(fileName);
        this.parser = parser;
        this.specIndex = 0;
        this.parseFirstSpectrum();
    }

    public SpectraIterator(String[] filenames, SpectrumParser parser) throws FileNotFoundException {
        this.filenames = filenames;
        this.nextFileIndex = 0;
        this.parser = parser;
        this.specIndex = 0;
        if (!this.nextFile()) {
            throw new FileNotFoundException("No files found.");
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Spectrum next() {
        Spectrum curSpecCopy = this.currentSpectrum;
        this.currentSpectrum = this.parser.readSpectrum(this.lineReader);
        if (this.currentSpectrum == null) {
            if (this.filenames == null || !this.nextFile()) {
                this.hasNext = false;
            }
        } else {
            this.currentSpectrum.determineIsCentroided();
            this.currentSpectrum.setSpecIndex(++this.specIndex);
            this.currentSpectrum.setID("index=" + String.valueOf(this.specIndex - 1));
        }
        return curSpecCopy;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("SpectraIterator.remove() not implemented");
    }

    @Override
    public Iterator<Spectrum> iterator() {
        return this;
    }

    private String getNextSpectrumFilePath() {
        return this.nextSpecFilePath;
    }

    private boolean nextFile() {
        this.lineReader = null;
        this.nextSpecFilePath = null;
        while (this.nextFileIndex < this.filenames.length) {
            try {
                this.nextSpecFilePath = this.filenames[this.nextFileIndex++];
                this.lineReader = new BufferedLineReader(this.nextSpecFilePath);
                break;
            }
            catch (IOException iOException) {
            }
        }
        if (this.lineReader == null) {
            return false;
        }
        this.parseFirstSpectrum();
        return true;
    }

    private void parseFirstSpectrum() {
        this.currentSpectrum = this.parser.readSpectrum(this.lineReader);
        if (this.currentSpectrum == null) {
            throw new Error("Error while parsing the first  spectrum");
        }
        if (this.currentSpectrum != null) {
            this.hasNext = true;
            this.currentSpectrum.determineIsCentroided();
            this.currentSpectrum.setSpecIndex(++this.specIndex);
            this.currentSpectrum.setID("index=" + String.valueOf(this.specIndex - 1));
        } else {
            this.hasNext = false;
        }
    }
}

