/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.msgf.LinearCalibration;
import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.IonType;
import edu.ucsd.msjava.msutil.Peak;
import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.msutil.Reshape;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.msutil.WindowFilter;

public class SpectrumRecalibrator
implements Reshape {
    Tolerance tolerance;

    public SpectrumRecalibrator(Tolerance tolerance) {
        this.tolerance = tolerance;
    }

    public SpectrumRecalibrator() {
        this.tolerance = null;
    }

    @Override
    public Spectrum apply(Spectrum s) {
        return null;
    }

    public Spectrum recalibrateUsingRescaling(Spectrum s) {
        LinearCalibration calibrator = new LinearCalibration();
        WindowFilter filter = new WindowFilter(5, 50.0f);
        Spectrum filteredSpec = filter.apply(s);
        for (Peak p : filteredSpec) {
            float rescaledMass = p.getMz() * 0.999497f;
            calibrator.addData(rescaledMass, Math.round(rescaledMass));
        }
        Spectrum newSpec = s.getCloneWithoutPeakList();
        for (Peak p : s) {
            newSpec.add(p.getShiftedPeak(calibrator.predict(p.getMz())));
        }
        return newSpec;
    }

    public Spectrum apply(Spectrum s, Peptide annotation) {
        LinearCalibration calibrator = new LinearCalibration();
        float prmMass = 0.0f;
        float prmSum = annotation.getMass();
        for (AminoAcid aa : annotation) {
            float yMass;
            float bMass = IonType.B.getMz(prmMass += aa.getMass());
            Peak p = s.getPeakByMass(bMass, this.tolerance);
            if (p != null) {
                calibrator.addData(p.getMz(), bMass);
            }
            if ((p = s.getPeakByMass(yMass = IonType.Y.getMz(prmSum - prmMass), this.tolerance)) == null) continue;
            calibrator.addData(p.getMz(), yMass);
        }
        Spectrum newSpec = s.getCloneWithoutPeakList();
        for (Peak p : s) {
            newSpec.add(p.getShiftedPeak(calibrator.predict(p.getMz())));
        }
        return newSpec;
    }
}

