/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.msutil.Peak;
import edu.ucsd.msjava.msutil.Reshape;
import edu.ucsd.msjava.msutil.Spectrum;

public class WindowFilter
implements Reshape {
    private int top;
    private float window;

    public WindowFilter(int top, float window) {
        this.top = top;
        this.window = window;
    }

    public int getTop() {
        return this.top;
    }

    public float getWindow() {
        return this.window;
    }

    @Override
    public Spectrum apply(Spectrum s) {
        Spectrum retSpec = (Spectrum)s.clone();
        retSpec.clear();
        for (int peakIndex = 0; peakIndex < s.size(); ++peakIndex) {
            Peak nextPeak;
            Peak prevPeak;
            int rank = 1;
            Peak thisPeak = (Peak)s.get(peakIndex);
            float thisMass = thisPeak.getMass();
            float thisInten = thisPeak.getIntensity();
            for (int prevIndex = peakIndex - 1; prevIndex >= 0 && !(thisMass - (prevPeak = (Peak)s.get(prevIndex)).getMass() > this.window); --prevIndex) {
                if (!(prevPeak.getIntensity() > thisInten)) continue;
                ++rank;
            }
            for (int nextIndex = peakIndex + 1; nextIndex < s.size() && !((nextPeak = (Peak)s.get(nextIndex)).getMass() - thisMass > this.window); ++nextIndex) {
                if (!(nextPeak.getIntensity() > thisInten)) continue;
                ++rank;
            }
            if (rank > this.top) continue;
            retSpec.add(thisPeak);
        }
        return retSpec;
    }
}

