/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.mzid;

import edu.ucsd.msjava.msdbsearch.SearchParams;
import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Enzyme;
import edu.ucsd.msjava.msutil.Modification;
import edu.ucsd.msjava.mzid.Constants;
import edu.ucsd.msjava.mzid.Unimod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.ac.ebi.jmzidml.model.mzidml.AnalysisProtocolCollection;
import uk.ac.ebi.jmzidml.model.mzidml.CvParam;
import uk.ac.ebi.jmzidml.model.mzidml.Enzymes;
import uk.ac.ebi.jmzidml.model.mzidml.MassTable;
import uk.ac.ebi.jmzidml.model.mzidml.ModificationParams;
import uk.ac.ebi.jmzidml.model.mzidml.Param;
import uk.ac.ebi.jmzidml.model.mzidml.ParamList;
import uk.ac.ebi.jmzidml.model.mzidml.Residue;
import uk.ac.ebi.jmzidml.model.mzidml.SearchModification;
import uk.ac.ebi.jmzidml.model.mzidml.SpecificityRules;
import uk.ac.ebi.jmzidml.model.mzidml.SpectrumIdentificationProtocol;
import uk.ac.ebi.jmzidml.model.mzidml.Tolerance;
import uk.ac.ebi.jmzidml.model.mzidml.UserParam;

public class AnalysisProtocolCollectionGen {
    private final SearchParams params;
    private final AminoAcidSet aaSet;
    private AnalysisProtocolCollection analysisProtocolCollection;
    private SpectrumIdentificationProtocol spectrumIdentificationProtocol;
    private Map<Modification, SearchModification> modMap;
    private Map<String, List<Modification>> fixedModMap;

    public AnalysisProtocolCollectionGen(SearchParams params, AminoAcidSet aaSet) {
        this.params = params;
        this.aaSet = aaSet;
        this.analysisProtocolCollection = new AnalysisProtocolCollection();
        this.modMap = new HashMap<Modification, SearchModification>();
        this.fixedModMap = new HashMap<String, List<Modification>>();
        this.generateSpectrumIdentificationProtocol();
    }

    public AnalysisProtocolCollection getAnalysisProtocolCollection() {
        return this.analysisProtocolCollection;
    }

    public SpectrumIdentificationProtocol getSpectrumIdentificationProtocol() {
        return this.spectrumIdentificationProtocol;
    }

    public SearchModification getSearchModification(Modification mod) {
        return this.modMap.get(mod);
    }

    public List<Modification> getFixedModifications(char residue) {
        return this.fixedModMap.get(residue + "");
    }

    public List<Modification> getTerminalFixedModifications(char residue, Modification.Location location) {
        ArrayList<Modification> mods = new ArrayList<Modification>();
        if (location == Modification.Location.N_Term) {
            List<Modification> modList = this.fixedModMap.get("[" + residue);
            if (modList != null) {
                mods.addAll(modList);
            }
            if ((modList = this.fixedModMap.get("[*")) != null) {
                mods.addAll(modList);
            }
        } else if (location == Modification.Location.C_Term) {
            List<Modification> modList = this.fixedModMap.get(residue + "]");
            if (modList != null) {
                mods.addAll(modList);
            }
            if ((modList = this.fixedModMap.get("*]")) != null) {
                mods.addAll(modList);
            }
        }
        return mods;
    }

    private void generateSpectrumIdentificationProtocol() {
        this.spectrumIdentificationProtocol = new SpectrumIdentificationProtocol();
        this.analysisProtocolCollection.getSpectrumIdentificationProtocol().add(this.spectrumIdentificationProtocol);
        this.spectrumIdentificationProtocol.setId(Constants.siProtocolID);
        this.spectrumIdentificationProtocol.setAnalysisSoftware(Constants.msgfPlus);
        Param searchTypeParam = new Param();
        searchTypeParam.setParam(Constants.makeCvParam("MS:1001083", "ms-ms search"));
        this.spectrumIdentificationProtocol.setSearchType(searchTypeParam);
        Enzymes enzymes = new Enzymes();
        Enzyme enzyme = this.params.getEnzyme();
        ParamList additionalSearchParams = new ParamList();
        List<CvParam> cvParamList = additionalSearchParams.getCvParam();
        cvParamList.add(Constants.makeCvParam("MS:1001211", "parent mass type mono", Constants.psiCV));
        cvParamList.add(Constants.makeCvParam("MS:1001256", "fragment mass type mono", Constants.psiCV));
        List<UserParam> userParamList = additionalSearchParams.getUserParam();
        userParamList.add(Constants.makeUserParam("TargetDecoyApproach", String.valueOf(this.params.useTDA())));
        userParamList.add(Constants.makeUserParam("MinIsotopeError", String.valueOf(this.params.getMinIsotopeError())));
        userParamList.add(Constants.makeUserParam("MaxIsotopeError", String.valueOf(this.params.getMaxIsotopeError())));
        userParamList.add(Constants.makeUserParam("FragmentMethod", this.params.getActivationMethod().getName()));
        userParamList.add(Constants.makeUserParam("Instrument", this.params.getInstType().getName()));
        userParamList.add(Constants.makeUserParam("Protocol", this.params.getProtocol().getName()));
        int ntt = this.params.getNumTolerableTermini();
        if (enzyme == Enzyme.NoCleavage || enzyme == Enzyme.UnspecificCleavage) {
            ntt = 0;
        }
        userParamList.add(Constants.makeUserParam("NumTolerableTermini", String.valueOf(ntt)));
        userParamList.add(Constants.makeUserParam("NumMatchesPerSpec", String.valueOf(this.params.getNumMatchesPerSpec())));
        userParamList.add(Constants.makeUserParam("MaxNumModifications", String.valueOf(this.aaSet.getMaxNumberOfVariableModificationsPerPeptide())));
        userParamList.add(Constants.makeUserParam("MinPepLength", String.valueOf(this.params.getMinPeptideLength())));
        userParamList.add(Constants.makeUserParam("MaxPepLength", String.valueOf(this.params.getMaxPeptideLength())));
        userParamList.add(Constants.makeUserParam("MinCharge", String.valueOf(this.params.getMinCharge())));
        userParamList.add(Constants.makeUserParam("MaxCharge", String.valueOf(this.params.getMaxCharge())));
        userParamList.add(Constants.makeUserParam("ChargeCarrierMass", String.valueOf(this.params.getChargeCarrierMass())));
        this.spectrumIdentificationProtocol.setAdditionalSearchParams(additionalSearchParams);
        if (!this.aaSet.getModifications().isEmpty()) {
            ModificationParams modParams = this.getModificationParam();
            this.spectrumIdentificationProtocol.setModificationParams(modParams);
        }
        if (enzyme != null) {
            List<uk.ac.ebi.jmzidml.model.mzidml.Enzyme> enzymeList = enzymes.getEnzyme();
            uk.ac.ebi.jmzidml.model.mzidml.Enzyme mzIdEnzyme = new uk.ac.ebi.jmzidml.model.mzidml.Enzyme();
            mzIdEnzyme.setId(enzyme.getName());
            if (ntt == 2) {
                mzIdEnzyme.setSemiSpecific(false);
            } else {
                mzIdEnzyme.setSemiSpecific(true);
            }
            mzIdEnzyme.setMissedCleavages(this.params.getMaxMissedCleavages());
            ParamList enzCvParams = new ParamList();
            String enzAcc = enzyme.getPSICvAccession();
            String enzName = enzyme.getDescription();
            if (enzAcc != null) {
                enzCvParams.getCvParam().add(Constants.makeCvParam(enzAcc, enzName, Constants.psiCV));
            } else {
                enzCvParams.getUserParam().add(Constants.makeUserParam(enzName));
            }
            mzIdEnzyme.setEnzymeName(enzCvParams);
            enzymeList.add(mzIdEnzyme);
        }
        this.spectrumIdentificationProtocol.setEnzymes(enzymes);
        ArrayList<Character> defaultResidues = AminoAcidSet.getStandardAminoAcidSet().getResidueListWithoutMods();
        ArrayList<Character> usedResidues = this.aaSet.getResidueListWithoutMods();
        if (usedResidues.size() > defaultResidues.size()) {
            MassTable massTable = new MassTable();
            massTable.setId(Constants.massTableID);
            massTable.setName("Custom Residues");
            massTable.getMsLevel().add(1);
            massTable.getMsLevel().add(2);
            for (Character c : usedResidues) {
                if (defaultResidues.contains(c)) continue;
                AminoAcid aa = this.aaSet.getAminoAcid(c.charValue());
                Residue residue = new Residue();
                residue.setCode(aa.getResidueStr());
                residue.setMass(aa.getMass());
                massTable.getResidue().add(residue);
            }
            this.spectrumIdentificationProtocol.getMassTable().add(massTable);
        }
        Tolerance parTol = new Tolerance();
        List<CvParam> parCvList = parTol.getCvParam();
        CvParam parCvPlus = Constants.getCvParamWithMassUnits(!this.params.getRightPrecursorMassTolerance().isTolerancePPM());
        CvParam parCvMinus = Constants.getCvParamWithMassUnits(!this.params.getLeftPrecursorMassTolerance().isTolerancePPM());
        parCvPlus.setAccession("MS:1001412");
        parCvPlus.setName("search tolerance plus value");
        parCvMinus.setAccession("MS:1001413");
        parCvMinus.setName("search tolerance minus value");
        parCvPlus.setValue(String.valueOf(this.params.getRightPrecursorMassTolerance().getValue()));
        parCvMinus.setValue(String.valueOf(this.params.getLeftPrecursorMassTolerance().getValue()));
        parCvList.add(parCvPlus);
        parCvList.add(parCvMinus);
        this.spectrumIdentificationProtocol.setParentTolerance(parTol);
        ParamList thrParamList = new ParamList();
        thrParamList.getCvParam().add(Constants.makeCvParam("MS:1001494", "no threshold", Constants.psiCV));
        this.spectrumIdentificationProtocol.setThreshold(thrParamList);
    }

    public ModificationParams getModificationParam() {
        ModificationParams modParams = new ModificationParams();
        List<SearchModification> searchModList = modParams.getSearchModification();
        for (Modification.Instance mod : this.aaSet.getModifications()) {
            String modName = mod.getModification().getName();
            SearchModification searchMod = new SearchModification();
            searchMod.setFixedMod(mod.isFixedModification());
            searchMod.setMassDelta(mod.getModification().getMass());
            List<CvParam> modCvParamList = searchMod.getCvParam();
            CvParam cvParam = new CvParam();
            String unimodRecordID = Unimod.getUnimod().getRecordID(modName);
            if (unimodRecordID != null) {
                cvParam.setAccession(unimodRecordID);
                cvParam.setCv(Constants.unimodCV);
                cvParam.setName(modName);
            } else {
                cvParam.setAccession("MS:1001460");
                cvParam.setCv(Constants.psiCV);
                cvParam.setName("unknown modification");
                cvParam.setValue(modName);
            }
            modCvParamList.add(cvParam);
            List<String> residueList = searchMod.getResidues();
            if (mod.getResidue() == '*') {
                residueList.add(".");
            } else {
                residueList.add(String.valueOf(mod.getResidue()));
            }
            if (mod.getLocation() != Modification.Location.Anywhere) {
                SpecificityRules specificityRules = new SpecificityRules();
                List<CvParam> rules = specificityRules.getCvParam();
                if (mod.getLocation() == Modification.Location.N_Term) {
                    rules.add(Constants.makeCvParam("MS:1001189", "modification specificity N-term", Constants.psiCV));
                } else if (mod.getLocation() == Modification.Location.Protein_N_Term) {
                    rules.add(Constants.makeCvParam("MS:1002057", "modification specificity protein N-term", Constants.psiCV));
                } else if (mod.getLocation() == Modification.Location.C_Term) {
                    rules.add(Constants.makeCvParam("MS:1001190", "modification specificity C-term", Constants.psiCV));
                } else if (mod.getLocation() == Modification.Location.Protein_C_Term) {
                    rules.add(Constants.makeCvParam("MS:1002058", "modification specificity protein C-term", Constants.psiCV));
                }
                searchMod.getSpecificityRules().add(specificityRules);
            }
            searchModList.add(searchMod);
            this.modMap.put(mod.getModification(), searchMod);
            if (!mod.isFixedModification()) continue;
            String modKey = this.getModKey(mod.getResidue(), mod.getLocation());
            List<Modification> fixedMods = this.fixedModMap.get(modKey);
            if (fixedMods == null) {
                fixedMods = new ArrayList<Modification>();
                this.fixedModMap.put(modKey, fixedMods);
            }
            fixedMods.add(mod.getModification());
        }
        return modParams;
    }

    private String getModKey(char residue, Modification.Location location) {
        StringBuffer modKey = new StringBuffer();
        if (location == Modification.Location.N_Term) {
            modKey.append('[');
        }
        modKey.append(residue);
        if (location == Modification.Location.C_Term) {
            modKey.append(']');
        }
        return modKey.toString();
    }
}

