/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.mzid;

import edu.ucsd.msjava.msdbsearch.CompactFastaSequence;
import edu.ucsd.msjava.msdbsearch.CompactSuffixArray;
import edu.ucsd.msjava.msdbsearch.DatabaseMatch;
import edu.ucsd.msjava.msdbsearch.MSGFPlusMatch;
import edu.ucsd.msjava.msdbsearch.SearchParams;
import edu.ucsd.msjava.msutil.ActivationMethod;
import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Composition;
import edu.ucsd.msjava.msutil.CvParamInfo;
import edu.ucsd.msjava.msutil.Modification;
import edu.ucsd.msjava.msutil.ModifiedAminoAcid;
import edu.ucsd.msjava.msutil.Pair;
import edu.ucsd.msjava.msutil.SpecFileFormat;
import edu.ucsd.msjava.msutil.SpectraAccessor;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.mzid.AnalysisProtocolCollectionGen;
import edu.ucsd.msjava.mzid.Constants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import uk.ac.ebi.jmzidml.model.mzidml.AnalysisCollection;
import uk.ac.ebi.jmzidml.model.mzidml.AnalysisData;
import uk.ac.ebi.jmzidml.model.mzidml.AnalysisProtocolCollection;
import uk.ac.ebi.jmzidml.model.mzidml.AnalysisSoftware;
import uk.ac.ebi.jmzidml.model.mzidml.AnalysisSoftwareList;
import uk.ac.ebi.jmzidml.model.mzidml.Cv;
import uk.ac.ebi.jmzidml.model.mzidml.CvList;
import uk.ac.ebi.jmzidml.model.mzidml.CvParam;
import uk.ac.ebi.jmzidml.model.mzidml.DBSequence;
import uk.ac.ebi.jmzidml.model.mzidml.DataCollection;
import uk.ac.ebi.jmzidml.model.mzidml.FileFormat;
import uk.ac.ebi.jmzidml.model.mzidml.FragmentationTable;
import uk.ac.ebi.jmzidml.model.mzidml.InputSpectra;
import uk.ac.ebi.jmzidml.model.mzidml.Inputs;
import uk.ac.ebi.jmzidml.model.mzidml.Measure;
import uk.ac.ebi.jmzidml.model.mzidml.Modification;
import uk.ac.ebi.jmzidml.model.mzidml.Param;
import uk.ac.ebi.jmzidml.model.mzidml.Peptide;
import uk.ac.ebi.jmzidml.model.mzidml.PeptideEvidence;
import uk.ac.ebi.jmzidml.model.mzidml.PeptideEvidenceRef;
import uk.ac.ebi.jmzidml.model.mzidml.SearchDatabase;
import uk.ac.ebi.jmzidml.model.mzidml.SearchDatabaseRef;
import uk.ac.ebi.jmzidml.model.mzidml.SequenceCollection;
import uk.ac.ebi.jmzidml.model.mzidml.SpectraData;
import uk.ac.ebi.jmzidml.model.mzidml.SpectrumIDFormat;
import uk.ac.ebi.jmzidml.model.mzidml.SpectrumIdentification;
import uk.ac.ebi.jmzidml.model.mzidml.SpectrumIdentificationItem;
import uk.ac.ebi.jmzidml.model.mzidml.SpectrumIdentificationList;
import uk.ac.ebi.jmzidml.model.mzidml.SpectrumIdentificationProtocol;
import uk.ac.ebi.jmzidml.model.mzidml.SpectrumIdentificationResult;
import uk.ac.ebi.jmzidml.model.mzidml.UserParam;
import uk.ac.ebi.jmzidml.xml.io.MzIdentMLMarshaller;

public class MZIdentMLGen {
    private MzIdentMLMarshaller m;
    private final SearchParams params;
    private AminoAcidSet aaSet;
    private CompactSuffixArray sa;
    private SpectraAccessor specAcc;
    private final int ioIndex;
    private final String decoyProteinPrefix;
    private float eValueThreshold = Float.MAX_VALUE;
    private CvList cvList;
    private AnalysisSoftwareList analysisSoftwareList;
    private SequenceCollection sequenceCollection;
    private List<DBSequence> dbSequenceList;
    private List<Peptide> peptideList;
    private List<PeptideEvidence> peptideEvidenceList;
    private AnalysisCollection analysisCollection;
    private AnalysisProtocolCollection analysisProtocolCollection;
    private SpectrumIdentificationProtocol siProtocol;
    private DataCollection dataCollection;
    private SpectraData spectraData;
    private SpectrumIdentificationList siList;
    private SearchDatabase searchDatabase;
    private Map<Integer, DBSequence> dbSeqMap;
    private Map<Integer, Boolean> isDecoyMap;
    private Map<String, Peptide> pepMap;
    private Map<String, PeptideEvidence> pepEvMap;
    private Map<String, List<PeptideEvidenceRef>> evRefListMap;
    private AnalysisProtocolCollectionGen apcGen;
    public static final String encoding = "UTF-8";
    public static final Charset charset = StandardCharsets.UTF_8;

    public MZIdentMLGen(SearchParams params, AminoAcidSet aaSet, CompactSuffixArray sa, SpectraAccessor specAcc, int ioIndex) {
        this.m = new MzIdentMLMarshaller();
        this.params = params;
        this.aaSet = aaSet;
        this.sa = sa;
        this.specAcc = specAcc;
        this.ioIndex = ioIndex;
        this.decoyProteinPrefix = params.getDecoyProteinPrefix();
        this.dbSeqMap = new HashMap<Integer, DBSequence>();
        this.isDecoyMap = new HashMap<Integer, Boolean>();
        this.pepMap = new LinkedHashMap<String, Peptide>();
        this.pepEvMap = new LinkedHashMap<String, PeptideEvidence>();
        this.evRefListMap = new HashMap<String, List<PeptideEvidenceRef>>();
        this.init();
    }

    private void init() {
        this.generateCvList();
        this.generateAnalysisSoftwareList();
        this.generateAnalysisProtocolCollection();
        this.initSequenceCollection();
        this.initDataCollection();
        this.generateAnalysisCollection();
    }

    public void writeResults(File file) {
        this.writeResultsCleanerTempFile(file);
    }

    public void writeResultsOriginal(File file) {
        OutputStream os = null;
        try {
            os = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not find file \"" + file.getAbsolutePath() + "\" to write to. Writing to console...");
            os = System.out;
        }
        OutputStreamWriter out = new OutputStreamWriter(os, charset);
        this.writeResults(out);
    }

    private void writeResults(Writer out) {
        try {
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            out.write(this.m.createMzIdentMLStartTag("MS-GF+") + "\n");
            this.m.marshal(this.cvList, out);
            out.write("\n");
            this.m.marshal(this.analysisSoftwareList, out);
            out.write("\n");
            this.m.marshal(this.sequenceCollection, out);
            out.write("\n");
            this.m.marshal(this.analysisCollection, out);
            out.write("\n");
            this.m.marshal(this.analysisProtocolCollection, out);
            out.write("\n");
            this.m.marshal(this.dataCollection, out);
            out.flush();
            out.write("\n");
            out.write(this.m.createMzIdentMLClosingTag() + "\n");
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeResultsCleanerTempString(File file) {
        OutputStream os = null;
        try {
            os = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not find file \"" + file.getAbsolutePath() + "\" to write to. Writing to console...");
            os = System.out;
        }
        try {
            StringWriter out = new StringWriter();
            this.writeResults(out);
            OutputStreamWriter out2 = new OutputStreamWriter(os, charset);
            StringReader sin = new StringReader(out.toString());
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.transform(new StreamSource(sin), new StreamResult(out2));
            out2.flush();
            out2.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public void writeResultsCleanerTempFile(File file) {
        FileInputStream is = null;
        FileOutputStream os = null;
        String newFileName = file.getAbsolutePath();
        int decimal = newFileName.lastIndexOf(".");
        String ext = newFileName.substring(decimal + 1);
        newFileName = newFileName.substring(0, decimal) + "_dirty." + ext;
        File tempFile = new File(newFileName);
        this.writeResultsOriginal(tempFile);
        try {
            is = new FileInputStream(tempFile);
            os = new FileOutputStream(file);
            InputStreamReader tempIn = new InputStreamReader((InputStream)is, charset);
            OutputStreamWriter out2 = new OutputStreamWriter((OutputStream)os, charset);
            out2.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            out2.flush();
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new StreamSource(tempIn), new StreamResult(out2));
            out2.flush();
            out2.close();
            tempFile.deleteOnExit();
        }
        catch (IOException e) {
            System.out.println("Could not reprocess temp file \"" + tempFile + "\". Will not delete file (if file exists).");
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public MZIdentMLGen setEValueThreshold(float eValueThreshold) {
        this.eValueThreshold = eValueThreshold;
        return this;
    }

    public synchronized void addSpectrumIdentificationResults(List<MSGFPlusMatch> resultList) {
        for (MSGFPlusMatch mpMatch : resultList) {
            float scanStartTime;
            int scanNum;
            int specIndex = mpMatch.getSpecIndex();
            List<DatabaseMatch> matchList = mpMatch.getMatchList();
            if (matchList == null || matchList.size() == 0) continue;
            Spectrum spec = this.specAcc.getSpecMap().getSpectrumBySpecIndex(specIndex);
            String specID = spec.getID();
            float precursorMz = spec.getPrecursorPeak().getMz();
            SpectrumIdentificationResult sir = new SpectrumIdentificationResult();
            sir.setId(Constants.sirID + specIndex);
            sir.setSpectraData(this.spectraData);
            sir.setSpectrumID(specID);
            String title = spec.getTitle();
            if (title != null) {
                CvParam cvParam = Constants.makeCvParam("MS:1000796", "spectrum title");
                cvParam.setValue(title);
                sir.getCvParam().add(cvParam);
            }
            if ((scanNum = spec.getScanNum()) >= 0) {
                CvParam cvParam = Constants.makeCvParam("MS:1001115", "scan number(s)");
                cvParam.setValue(String.valueOf(scanNum));
                sir.getCvParam().add(cvParam);
            }
            if ((scanStartTime = spec.getRt()) >= 0.0f) {
                CvParam cvParam = Constants.makeCvParam("MS:1000016", "scan start time");
                cvParam.setValue(String.valueOf(scanStartTime));
                if (spec.getRtIsSeconds()) {
                    cvParam.setUnitCv(Constants.unitCV);
                    cvParam.setUnitAccession("UO:0000010");
                    cvParam.setUnitName("second");
                } else {
                    cvParam.setUnitCv(Constants.unitCV);
                    cvParam.setUnitAccession("UO:0000031");
                    cvParam.setUnitName("minute");
                }
                sir.getCvParam().add(cvParam);
            }
            if (spec.getAddlCvParams() != null) {
                for (CvParamInfo cvParamInfo : spec.getAddlCvParams()) {
                    CvParam cvParam = Constants.makeCvParam(cvParamInfo.getAccession(), cvParamInfo.getName());
                    cvParam.setValue(cvParamInfo.getValue());
                    if (cvParamInfo.getHasUnit().booleanValue()) {
                        cvParam.setUnitCv(Constants.unitCV);
                        cvParam.setUnitAccession(cvParamInfo.getUnitAccession());
                        cvParam.setUnitName(cvParamInfo.getUnitName());
                    }
                    sir.getCvParam().add(cvParam);
                }
            }
            int rank = 0;
            int resultCount = 0;
            double prevSpecEValue = Double.NaN;
            for (int i = matchList.size() - 1; i >= 0; --i) {
                ++resultCount;
                DatabaseMatch match = matchList.get(i);
                if (match.getDeNovoScore() < this.params.getMinDeNovoScore()) break;
                int length = match.getLength();
                int charge = match.getCharge();
                float peptideMass = match.getPeptideMass();
                float theoMz = (peptideMass + 18.010565f) / (float)charge + (float)Composition.ChargeCarrierMass();
                int score = match.getScore();
                double specEValue = match.getSpecEValue();
                int numPeptides = this.sa.getNumDistinctPeptides(this.params.getEnzyme() == null ? length - 2 : length - 1);
                double eValue = specEValue * (double)numPeptides;
                String specEValueStr = specEValue < 1.1754943508222875E-38 ? String.valueOf(specEValue) : String.valueOf((float)specEValue);
                if (prevSpecEValue != specEValue) {
                    ++rank;
                }
                prevSpecEValue = specEValue;
                String eValueStr = specEValue < 1.1754943508222875E-38 ? String.valueOf(eValue) : String.valueOf((float)eValue);
                SpectrumIdentificationItem sii = new SpectrumIdentificationItem();
                sii.setChargeState(charge);
                sii.setExperimentalMassToCharge(precursorMz);
                sii.setCalculatedMassToCharge(Double.valueOf(theoMz));
                Peptide pep = this.getPeptide(match);
                sii.setPeptide(pep);
                sii.setRank(rank);
                sii.setPassThreshold(eValue <= (double)this.eValueThreshold);
                sii.setId(Constants.siiID + specIndex + "_" + resultCount);
                sii.getPeptideEvidenceRef().addAll(this.getPeptideEvidenceList(match, pep));
                List<CvParam> cvList = sii.getCvParam();
                List<UserParam> userList = sii.getUserParam();
                CvParam rawScoreCV = Constants.makeCvParam("MS:1002049", "MS-GF:RawScore");
                rawScoreCV.setValue(String.valueOf(score));
                cvList.add(rawScoreCV);
                CvParam deNovoScoreCV = Constants.makeCvParam("MS:1002050", "MS-GF:DeNovoScore");
                deNovoScoreCV.setValue(String.valueOf(match.getDeNovoScore()));
                cvList.add(deNovoScoreCV);
                CvParam specEValueCV = Constants.makeCvParam("MS:1002052", "MS-GF:SpecEValue");
                specEValueCV.setValue(specEValueStr);
                cvList.add(specEValueCV);
                CvParam eValueCV = Constants.makeCvParam("MS:1002053", "MS-GF:EValue");
                eValueCV.setValue(eValueStr);
                cvList.add(eValueCV);
                if (match.getPSMQValue() != null) {
                    CvParam psmQValueCV = Constants.makeCvParam("MS:1002054", "MS-GF:QValue");
                    psmQValueCV.setValue(match.getPSMQValue().toString());
                    cvList.add(psmQValueCV);
                }
                if (match.getPepQValue() != null) {
                    CvParam pepQValueCV = Constants.makeCvParam("MS:1002055", "MS-GF:PepQValue");
                    pepQValueCV.setValue(match.getPepQValue().toString());
                    cvList.add(pepQValueCV);
                }
                UserParam isotopeErrorParam = Constants.makeUserParam("IsotopeError");
                float expMass = precursorMz * (float)charge;
                float theoMass = theoMz * (float)charge;
                int isotopeError = Math.round((expMass - theoMass) / 1.0033548f);
                isotopeErrorParam.setValue(String.valueOf(isotopeError));
                userList.add(isotopeErrorParam);
                ActivationMethod[] activationMethodArr = match.getActivationMethodArr();
                if (activationMethodArr != null) {
                    StringBuffer actMethodStrBuf = new StringBuffer();
                    actMethodStrBuf.append(activationMethodArr[0]);
                    for (int j = 1; j < activationMethodArr.length; ++j) {
                        actMethodStrBuf.append("/" + activationMethodArr[j]);
                    }
                    UserParam dissociationMethodParam = Constants.makeUserParam("AssumedDissociationMethod");
                    dissociationMethodParam.setValue(actMethodStrBuf.toString());
                    userList.add(dissociationMethodParam);
                }
                if (match.getAdditionalFeatureList() != null) {
                    for (Pair<String, String> feature : match.getAdditionalFeatureList()) {
                        String name = feature.getFirst();
                        String value = feature.getSecond();
                        UserParam addParam = Constants.makeUserParam(name);
                        addParam.setValue(value);
                        userList.add(addParam);
                    }
                }
                sir.getSpectrumIdentificationItem().add(sii);
            }
            if (sir.getSpectrumIdentificationItem().isEmpty()) continue;
            this.siList.getSpectrumIdentificationResult().add(sir);
        }
    }

    private Peptide getPeptide(DatabaseMatch match) {
        String pepStr = match.getPepSeq();
        Peptide mzidPeptide = this.pepMap.get(pepStr);
        if (mzidPeptide == null) {
            mzidPeptide = new Peptide();
            List<Modification> modList = mzidPeptide.getModification();
            edu.ucsd.msjava.msutil.Peptide peptide = this.aaSet.getPeptide(pepStr);
            StringBuffer unmodPepStr = new StringBuffer();
            StringBuffer modPepStr = new StringBuffer();
            int location = 1;
            for (AminoAcid aa : peptide) {
                List<edu.ucsd.msjava.msutil.Modification> fixedMods;
                Modification mod;
                Modification.Location loc = location == 1 ? Modification.Location.N_Term : (location == peptide.size() ? Modification.Location.C_Term : Modification.Location.Anywhere);
                char residue = aa.getUnmodResidue();
                unmodPepStr.append(residue);
                ArrayList<edu.ucsd.msjava.msutil.Modification> anyPosMods = new ArrayList<edu.ucsd.msjava.msutil.Modification>();
                boolean hasNTermMod = false;
                ArrayList<edu.ucsd.msjava.msutil.Modification> nTermMods = new ArrayList<edu.ucsd.msjava.msutil.Modification>();
                boolean hasCTermMod = false;
                ArrayList<edu.ucsd.msjava.msutil.Modification> cTermMods = new ArrayList<edu.ucsd.msjava.msutil.Modification>();
                boolean modified = false;
                if (loc == Modification.Location.N_Term || loc == Modification.Location.C_Term) {
                    List<edu.ucsd.msjava.msutil.Modification> fixedTermMods = this.apcGen.getTerminalFixedModifications(aa.getUnmodResidue(), loc);
                    for (edu.ucsd.msjava.msutil.Modification fixedMod : fixedTermMods) {
                        mod = new Modification();
                        if (loc == Modification.Location.N_Term) {
                            mod.setLocation(location - 1);
                        } else {
                            mod.setLocation(location + 1);
                        }
                        mod.setMonoisotopicMassDelta(fixedMod.getAccurateMass());
                        mod.getCvParam().addAll(this.apcGen.getSearchModification(fixedMod).getCvParam());
                        modList.add(mod);
                    }
                }
                if ((fixedMods = this.apcGen.getFixedModifications(aa.getUnmodResidue())) != null) {
                    for (edu.ucsd.msjava.msutil.Modification fixedMod : fixedMods) {
                        mod = new Modification();
                        mod.setLocation(location);
                        mod.setMonoisotopicMassDelta(fixedMod.getAccurateMass());
                        mod.getCvParam().addAll(this.apcGen.getSearchModification(fixedMod).getCvParam());
                        modList.add(mod);
                    }
                }
                if (aa.isModified()) {
                    Modification mod2 = new Modification();
                    ModifiedAminoAcid modAA = (ModifiedAminoAcid)aa;
                    if (location == 1 && modAA.isNTermVariableMod()) {
                        mod2.setLocation(location - 1);
                        nTermMods.add(modAA.getModification());
                        hasNTermMod = true;
                    } else if (location == peptide.size() && modAA.isCTermVariableMod()) {
                        mod2.setLocation(location + 1);
                        cTermMods.add(modAA.getModification());
                        hasCTermMod = true;
                    } else {
                        mod2.setLocation(location);
                        anyPosMods.add(modAA.getModification());
                        modified = true;
                    }
                    mod2.setMonoisotopicMassDelta(modAA.getModification().getAccurateMass());
                    mod2.getCvParam().addAll(this.apcGen.getSearchModification(modAA.getModification()).getCvParam());
                    modList.add(mod2);
                    while (modAA.getTargetAA().isModified()) {
                        Modification mod22 = new Modification();
                        modAA = (ModifiedAminoAcid)modAA.getTargetAA();
                        if (location == 1 && modAA.isNTermVariableMod()) {
                            mod22.setLocation(location - 1);
                            nTermMods.add(modAA.getModification());
                            hasNTermMod = true;
                        } else if (location == peptide.size() && modAA.isCTermVariableMod()) {
                            mod22.setLocation(location + 1);
                            cTermMods.add(modAA.getModification());
                            hasCTermMod = true;
                        } else {
                            mod22.setLocation(location);
                            anyPosMods.add(modAA.getModification());
                            modified = true;
                        }
                        mod22.setMonoisotopicMassDelta(modAA.getModification().getAccurateMass());
                        mod22.getCvParam().addAll(this.apcGen.getSearchModification(modAA.getModification()).getCvParam());
                        modList.add(mod22);
                    }
                }
                Modification.MassComparator massCompare = new Modification.MassComparator();
                if (hasNTermMod) {
                    modPepStr.append("[");
                    Collections.sort(nTermMods, massCompare);
                    for (edu.ucsd.msjava.msutil.Modification nTMass : nTermMods) {
                        modPepStr.append(nTMass.getModId());
                    }
                }
                modPepStr.append(residue);
                if (modified) {
                    Collections.sort(anyPosMods, massCompare);
                    for (edu.ucsd.msjava.msutil.Modification mMass : anyPosMods) {
                        modPepStr.append(mMass.getModId());
                    }
                }
                if (hasCTermMod) {
                    modPepStr.append("}");
                    Collections.sort(cTermMods, massCompare);
                    for (edu.ucsd.msjava.msutil.Modification cTMass : cTermMods) {
                        modPepStr.append(cTMass.getModId());
                    }
                }
                ++location;
            }
            mzidPeptide.setPeptideSequence(unmodPepStr.toString());
            this.pepMap.put(pepStr, mzidPeptide);
            mzidPeptide.setId(Constants.pepIDPrefix + modPepStr.toString());
            this.peptideList.add(mzidPeptide);
        }
        return mzidPeptide;
    }

    public List<PeptideEvidenceRef> getPeptideEvidenceList(DatabaseMatch match, Peptide peptide) {
        SortedSet<Integer> indices = match.getIndices();
        int length = match.getLength();
        int startKey = indices.first();
        String pepIDNum = peptide.getId().substring(Constants.pepIDPrefix.length());
        String annotationKey = (match.isNTermMetCleaved() ? "M" : "") + startKey + "_" + pepIDNum;
        List<PeptideEvidenceRef> evRefList = this.evRefListMap.get(annotationKey);
        if (evRefList == null) {
            evRefList = new ArrayList<PeptideEvidenceRef>();
            CompactFastaSequence seq = this.sa.getSequence();
            Iterator iterator = indices.iterator();
            while (iterator.hasNext()) {
                char post;
                int index = (Integer)iterator.next();
                boolean isNTermMetCleaved = false;
                if (this.sa.getSequence().getByteAt(index) == 0 && this.sa.getSequence().getCharAt(index + 1) == 'M') {
                    boolean bl = isNTermMetCleaved = match.isNTermMetCleaved() || peptide.getPeptideSequence().charAt(0) != 'M';
                    if (!isNTermMetCleaved) {
                        String matchSequence = this.sa.getSequence().getSubsequence(index + 2, index + 3 + peptide.getPeptideSequence().length());
                        isNTermMetCleaved = matchSequence.startsWith(peptide.getPeptideSequence());
                    }
                }
                PeptideEvidence pepEv = new PeptideEvidence();
                char pre = this.sa.getSequence().getCharAt(index);
                if (pre == '_') {
                    pre = isNTermMetCleaved ? (char)'M' : '-';
                }
                if ((post = isNTermMetCleaved ? this.sa.getSequence().getCharAt(index + length) : this.sa.getSequence().getCharAt(index + length - 1)) == '_') {
                    post = '-';
                }
                pepEv.setPre(String.valueOf(pre));
                pepEv.setPost(String.valueOf(post));
                int protStartIndex = (int)seq.getStartPosition(index);
                DBSequence dbSeq = this.getDBSequence(protStartIndex);
                pepEv.setDBSequence(dbSeq);
                pepEv.setPeptide(peptide);
                int start = index - protStartIndex + 1;
                if (isNTermMetCleaved) {
                    ++start;
                }
                int end = start + length - 2 - 1;
                pepEv.setStart(start);
                pepEv.setEnd(end);
                String pepEvKey = Constants.pepEvIDPrefix + (index + 1) + "_" + pepIDNum + "_" + start;
                pepEv.setId(pepEvKey);
                pepEv.setIsDecoy(this.isDecoyMap.get(protStartIndex));
                if (this.pepEvMap.get(pepEvKey) != null) {
                    pepEv = this.pepEvMap.get(pepEvKey);
                } else {
                    this.pepEvMap.put(pepEvKey, pepEv);
                    this.peptideEvidenceList.add(pepEv);
                }
                PeptideEvidenceRef pepEvRef = new PeptideEvidenceRef();
                pepEvRef.setPeptideEvidence(pepEv);
                evRefList.add(pepEvRef);
            }
            this.evRefListMap.put(annotationKey, evRefList);
        }
        return evRefList;
    }

    public DBSequence getDBSequence(int protStartIndex) {
        DBSequence dbSeq = this.dbSeqMap.get(protStartIndex);
        if (dbSeq == null) {
            dbSeq = new DBSequence();
            CompactFastaSequence seq = this.sa.getSequence();
            String annotation = seq.getAnnotation(protStartIndex);
            String proteinSeq = seq.getMatchingEntry(protStartIndex);
            String accession = annotation.split("\\s+")[0];
            dbSeq.setLength(proteinSeq.length());
            dbSeq.setSearchDatabase(this.searchDatabase);
            dbSeq.setAccession(accession);
            dbSeq.setId("DBSeq" + (protStartIndex + 1));
            boolean isDecoy = accession.startsWith(this.decoyProteinPrefix);
            if (!isDecoy) {
                CvParam protDescCV = Constants.makeCvParam("MS:1001088", "protein description");
                protDescCV.setValue(annotation);
                dbSeq.getCvParam().add(protDescCV);
            }
            this.dbSequenceList.add(dbSeq);
            this.dbSeqMap.put(protStartIndex, dbSeq);
            this.isDecoyMap.put(protStartIndex, isDecoy);
        }
        return dbSeq;
    }

    private void generateCvList() {
        this.cvList = new CvList();
        List<Cv> localCvList = this.cvList.getCv();
        localCvList.add(Constants.psiCV);
        localCvList.add(Constants.unimodCV);
        localCvList.add(Constants.unitCV);
    }

    private void generateAnalysisSoftwareList() {
        this.analysisSoftwareList = new AnalysisSoftwareList();
        List<AnalysisSoftware> analysisSoftwares = this.analysisSoftwareList.getAnalysisSoftware();
        analysisSoftwares.add(Constants.msgfPlus);
    }

    private void initSequenceCollection() {
        this.sequenceCollection = new SequenceCollection();
        this.dbSequenceList = this.sequenceCollection.getDBSequence();
        this.peptideList = this.sequenceCollection.getPeptide();
        this.peptideEvidenceList = this.sequenceCollection.getPeptideEvidence();
    }

    private void generateAnalysisCollection() {
        this.analysisCollection = new AnalysisCollection();
        List<SpectrumIdentification> specIdentList = this.analysisCollection.getSpectrumIdentification();
        SpectrumIdentification specIdent = new SpectrumIdentification();
        specIdent.setId(Constants.specIdentID);
        specIdent.setSpectrumIdentificationList(this.siList);
        specIdent.setSpectrumIdentificationProtocol(this.siProtocol);
        List<InputSpectra> inputSpecList = specIdent.getInputSpectra();
        InputSpectra inputSpec = new InputSpectra();
        inputSpec.setSpectraData(this.spectraData);
        inputSpecList.add(inputSpec);
        List<SearchDatabaseRef> searchDBRefList = specIdent.getSearchDatabaseRef();
        SearchDatabaseRef searchDBRef = new SearchDatabaseRef();
        searchDBRef.setSearchDatabase(this.searchDatabase);
        searchDBRefList.add(searchDBRef);
        specIdentList.add(specIdent);
    }

    private void generateAnalysisProtocolCollection() {
        this.apcGen = new AnalysisProtocolCollectionGen(this.params, this.aaSet);
        this.analysisProtocolCollection = this.apcGen.getAnalysisProtocolCollection();
        this.siProtocol = this.apcGen.getSpectrumIdentificationProtocol();
    }

    private void initDataCollection() {
        this.dataCollection = new DataCollection();
        Inputs inputs = new Inputs();
        this.searchDatabase = new SearchDatabase();
        this.searchDatabase.setId(Constants.searchDBID);
        this.searchDatabase.setNumDatabaseSequences(Long.valueOf(this.sa.getSequence().getNumProteins()));
        this.searchDatabase.setLocation(this.params.getDatabaseFile().getAbsolutePath());
        UserParam param = new UserParam();
        param.setName(this.params.getDatabaseFile().getName());
        Param tempParam = new Param();
        tempParam.setParam(param);
        this.searchDatabase.setDatabaseName(tempParam);
        FileFormat ffDB = new FileFormat();
        ffDB.setCvParam(Constants.makeCvParam("MS:1001348", "FASTA format"));
        this.searchDatabase.setFileFormat(ffDB);
        if (this.params.useTDA()) {
            this.searchDatabase.getCvParam().add(Constants.makeCvParam("MS:1001197", "DB composition target+decoy"));
            CvParam decoyAccCV = Constants.makeCvParam("MS:1001283", "decoy DB accession regexp");
            decoyAccCV.setValue("^" + this.decoyProteinPrefix);
            this.searchDatabase.getCvParam().add(decoyAccCV);
            this.searchDatabase.getCvParam().add(Constants.makeCvParam("MS:1001195", "decoy DB type reverse"));
        }
        inputs.getSearchDatabase().add(this.searchDatabase);
        this.spectraData = new SpectraData();
        this.spectraData.setId(Constants.spectraDataID);
        File specFile = this.params.getDBSearchIOList().get(this.ioIndex).getSpecFile();
        this.spectraData.setLocation(specFile.getAbsolutePath());
        this.spectraData.setName(specFile.getName());
        SpecFileFormat specFileFormat = this.params.getDBSearchIOList().get(this.ioIndex).getSpecFileFormat();
        FileFormat ffSpec = new FileFormat();
        ffSpec.setCvParam(Constants.makeCvParam(specFileFormat.getPSIAccession(), specFileFormat.getPSIName()));
        this.spectraData.setFileFormat(ffSpec);
        SpectrumIDFormat sidFormat = new SpectrumIDFormat();
        sidFormat.setCvParam(this.specAcc.getSpectrumIDFormatCvParam());
        this.spectraData.setSpectrumIDFormat(sidFormat);
        inputs.getSpectraData().add(this.spectraData);
        this.dataCollection.setInputs(inputs);
        AnalysisData analysisData = new AnalysisData();
        this.dataCollection.setAnalysisData(analysisData);
        this.siList = new SpectrumIdentificationList();
        this.siList.setId(Constants.siListID);
        FragmentationTable fragTable = new FragmentationTable();
        List<Measure> measureList = fragTable.getMeasure();
        Measure mzMeasure = new Measure();
        mzMeasure.setId(Constants.measureMzID);
        List<CvParam> cvParamList = mzMeasure.getCvParam();
        cvParamList.add(Constants.makeCvParam("MS:1001225", "product ion m/z", Constants.psiCV, "MS:1000040", "m/z", Constants.psiCV));
        measureList.add(mzMeasure);
        this.siList.setFragmentationTable(fragTable);
        analysisData.getSpectrumIdentificationList().add(this.siList);
    }
}

