/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.params;

import edu.ucsd.msjava.params.NumberParameter;
import edu.ucsd.msjava.params.ParamManager;

public class DoubleParameter
extends NumberParameter<Double> {
    public DoubleParameter(ParamManager.ParamNameEnum paramInfo) {
        super(paramInfo.getKey(), paramInfo.getName(), paramInfo.getDescription());
        this.setAdditionalDescription(paramInfo.getAdditionalDescription());
    }

    public DoubleParameter(String key, String name, String description) {
        super(key, name, description);
        this.minValue = Double.NEGATIVE_INFINITY;
        this.maxValue = Double.POSITIVE_INFINITY;
    }

    @Override
    public String parse(String value) {
        try {
            this.value = Double.valueOf(this.trimTrailingChars(value, "!"));
            if (this.minValue == null) {
                this.minValue = Double.NEGATIVE_INFINITY;
            }
            if (this.maxValue == null) {
                this.maxValue = Double.POSITIVE_INFINITY;
            }
            String range = this.getValidRange();
            if ((Double)this.value < (Double)this.minValue || (Double)this.value > (Double)this.maxValue || !this.isMinInclusive && ((Double)this.value).equals(this.minValue) || !this.isMaxInclusive && ((Double)this.value).equals(this.maxValue)) {
                return "must be in the range " + range;
            }
        }
        catch (NumberFormatException e) {
            return "must be a double";
        }
        return null;
    }
}

