/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.params;

import edu.ucsd.msjava.params.IntParameter;
import edu.ucsd.msjava.params.ParamManager;
import java.util.ArrayList;

public class EnumParameter
extends IntParameter {
    private int defaultValue = Integer.MIN_VALUE;
    private ArrayList<String> descriptions = new ArrayList();

    public EnumParameter(String key) {
        super(key, null, null);
        super.minValue(0);
    }

    public EnumParameter(ParamManager.ParamNameEnum paramInfo) {
        super(paramInfo);
        super.minValue(0);
    }

    public EnumParameter setMinIndex(int minIndex) {
        super.minValue(minIndex);
        return this;
    }

    public EnumParameter registerEntry(String description) {
        this.descriptions.add(description);
        return this;
    }

    public EnumParameter setDefault() {
        this.defaultValue = this.getMinValue() + this.descriptions.size() - 1;
        super.defaultValue(this.defaultValue);
        return this;
    }

    protected int getCurIndex() {
        return this.getMinValue() + this.descriptions.size();
    }

    protected int getMinValue() {
        if (this.minValue == null) {
            return 0;
        }
        return (Integer)this.minValue;
    }

    @Override
    public String getName() {
        if (super.getName() != null) {
            return super.getName();
        }
        StringBuffer buf = new StringBuffer();
        for (int i = ((Integer)this.minValue).intValue(); i < this.getMinValue() + this.descriptions.size(); ++i) {
            if (i > this.getMinValue()) {
                buf.append("/");
            }
            buf.append(i);
        }
        return buf.toString();
    }

    @Override
    public String getDescription() {
        StringBuffer buf = new StringBuffer();
        if (super.getDescription() != null) {
            buf.append(super.getDescription() + ", ");
            buf.append("Default: " + this.defaultValue);
            return buf.toString();
        }
        for (int i = ((Integer)this.minValue).intValue(); i < this.getMinValue() + this.descriptions.size(); ++i) {
            if (i > this.getMinValue()) {
                buf.append(", ");
            }
            buf.append(i + ": " + this.descriptions.get(i - this.getMinValue()));
            if (i != this.defaultValue) continue;
            buf.append(" (Default)");
        }
        return buf.toString();
    }

    @Override
    public String parse(String value) {
        super.maxValue(this.getMinValue() + this.descriptions.size());
        return super.parse(value);
    }
}

