/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.params;

import edu.ucsd.msjava.msutil.FileFormat;
import edu.ucsd.msjava.params.Parameter;
import java.io.File;
import java.util.ArrayList;

public class FileListParameter
extends Parameter {
    private ArrayList<FileFormat> fileFormats = new ArrayList();
    private File[] files;
    private FileFormat[] fileFormatArr;

    public FileListParameter(String key, String name, String description) {
        super(key, name, description);
    }

    public FileListParameter setAsOptional() {
        super.setOptional();
        return this;
    }

    public FileListParameter addFileFormat(FileFormat fileFormat) {
        this.fileFormats.add(fileFormat);
        return this;
    }

    @Override
    public String parse(String value) {
        File[] dirFiles;
        File path = new File(value);
        if (!path.isDirectory()) {
            if (!path.exists()) {
                return "File does not exist";
            }
            dirFiles = new File[]{path};
        } else {
            dirFiles = path.listFiles();
        }
        ArrayList<File> fileList = new ArrayList<File>();
        ArrayList<FileFormat> fileFormatList = new ArrayList<FileFormat>();
        for (File f : dirFiles) {
            if (this.fileFormats.isEmpty()) {
                fileList.add(f);
                continue;
            }
            FileFormat matchedFormat = null;
            String fileName = f.getName();
            block1: for (FileFormat format : this.fileFormats) {
                if (!format.isCaseSensitive()) {
                    fileName = fileName.toLowerCase();
                }
                for (String suffix : format.getSuffixes()) {
                    if (!format.isCaseSensitive()) {
                        suffix = suffix.toLowerCase();
                    }
                    if (!fileName.endsWith(suffix)) continue;
                    matchedFormat = format;
                    continue block1;
                }
            }
            if (matchedFormat == null) continue;
            fileList.add(f);
            fileFormatList.add(matchedFormat);
        }
        if (fileList.size() == 0) {
            return "no file exists with the given extensions";
        }
        this.files = fileList.toArray(new File[0]);
        this.fileFormatArr = fileFormatList.toArray(new FileFormat[0]);
        return null;
    }

    public File[] getFiles() {
        return this.files;
    }

    public FileFormat[] getFileFormats() {
        return this.fileFormatArr;
    }

    @Override
    public String getValueAsString() {
        if (this.files == null) {
            return null;
        }
        StringBuffer output = new StringBuffer();
        if (this.files.length == 0) {
            return output.toString();
        }
        output.append(this.files[0].getPath());
        for (int i = 1; i < this.files.length; ++i) {
            output.append("," + this.files[i].getPath());
        }
        return output.toString();
    }
}

