/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.params;

import edu.ucsd.msjava.params.NumberParameter;

public class FloatParameter
extends NumberParameter<Float> {
    public FloatParameter(String key, String name, String description) {
        super(key, name, description);
        this.minValue = Float.valueOf(Float.NEGATIVE_INFINITY);
        this.maxValue = Float.valueOf(Float.POSITIVE_INFINITY);
    }

    @Override
    public String parse(String value) {
        try {
            this.value = Float.valueOf(this.trimTrailingChars(value, "!"));
            if (this.minValue == null) {
                this.minValue = Float.valueOf(Float.NEGATIVE_INFINITY);
            }
            if (this.maxValue == null) {
                this.maxValue = Float.valueOf(Float.POSITIVE_INFINITY);
            }
            String range = this.getValidRange();
            if (((Float)this.value).floatValue() < ((Float)this.minValue).floatValue() || ((Float)this.value).floatValue() > ((Float)this.maxValue).floatValue() || !this.isMinInclusive && ((Float)this.value).equals(this.minValue) || !this.isMaxInclusive && ((Float)this.value).equals(this.maxValue)) {
                return "must be in the range " + range;
            }
        }
        catch (NumberFormatException e) {
            return "must be a float";
        }
        return null;
    }
}

