/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.params;

import edu.ucsd.msjava.params.ParamManager;
import edu.ucsd.msjava.params.RangeParameter;

public class IntRangeParameter
extends RangeParameter<Integer> {
    public IntRangeParameter(ParamManager.ParamNameEnum paramInfo) {
        super(paramInfo.getKey(), paramInfo.getName(), paramInfo.getDescription());
        this.setAdditionalDescription(paramInfo.getAdditionalDescription());
    }

    public IntRangeParameter(String key, String name, String description) {
        super(key, name, description);
        this.minValue = Integer.MIN_VALUE;
        this.maxValue = Integer.MAX_VALUE;
        this.isMinInclusive = true;
        this.isMaxInclusive = false;
    }

    @Override
    public String parse(String value) {
        int maxNumber;
        String[] token = value.split(",");
        try {
            if (token.length != 2) {
                return "illegar syntax";
            }
            this.min = Integer.valueOf(Integer.parseInt(token[0]));
            this.max = Integer.valueOf(Integer.parseInt(token[1]));
        }
        catch (NumberFormatException e) {
            return "not a valid integer or integer range";
        }
        int minNumber = this.isMinInclusive ? (Integer)this.min : (Integer)this.min + 1;
        int n = maxNumber = this.isMaxInclusive ? (Integer)this.max : (Integer)this.max - 1;
        if (minNumber > maxNumber) {
            return "not a valid range";
        }
        return null;
    }
}

