/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.params;

import edu.ucsd.msjava.params.Parameter;
import org.apache.commons.lang3.StringUtils;

public abstract class NumberParameter<T extends Number>
extends Parameter {
    protected T value;
    protected T minValue;
    protected T maxValue;
    protected boolean isMinInclusive = true;
    protected boolean isMaxInclusive = false;

    public NumberParameter(String key, String name, String description) {
        super(key, name, description);
    }

    public NumberParameter<T> defaultValue(T defaultValue) {
        this.value = defaultValue;
        super.setOptional();
        return this;
    }

    public NumberParameter<T> minValue(T minValue) {
        this.minValue = minValue;
        return this;
    }

    public NumberParameter<T> maxValue(T maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    public NumberParameter<T> setMinExclusive() {
        this.isMinInclusive = false;
        return this;
    }

    public NumberParameter<T> setMaxInclusive() {
        this.isMaxInclusive = true;
        return this;
    }

    protected String getValidRange() {
        return (this.isMinInclusive ? "[" : "(") + this.minValue + "," + this.maxValue + (this.isMaxInclusive ? "]" : ")");
    }

    @Override
    public abstract String parse(String var1);

    @Override
    public String getValueAsString() {
        return String.valueOf(this.value);
    }

    public String trimTrailingChars(String value, String stripChars) {
        return StringUtils.stripEnd(value, stripChars);
    }

    public T getValue() {
        return this.value;
    }
}

