/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.params;

public abstract class Parameter {
    private String key;
    private String name;
    private String description;
    private boolean isOptional = false;
    private boolean isValueAssigned = false;
    private String additionalDescription = null;
    private boolean hidden = false;

    protected Parameter(String key, String name, String description) {
        this.key = key;
        this.name = name;
        this.description = description;
    }

    protected void setOptional() {
        this.isOptional = true;
    }

    public void setHidden() {
        this.hidden = true;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAdditionalDescription() {
        return this.additionalDescription;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setAdditionalDescription(String additionalDescription) {
        this.additionalDescription = additionalDescription;
    }

    public String toString() {
        String usage = "-" + this.getKey() + " " + this.getName();
        if (this.isOptional()) {
            usage = "[" + usage + "]";
        }
        usage = usage + " (" + this.getDescription() + ")";
        return usage;
    }

    public void setValueAssigned() {
        this.isValueAssigned = true;
    }

    public boolean isValueAssigned() {
        return this.isValueAssigned;
    }

    public boolean isValid() {
        if (this.isOptional) {
            return true;
        }
        return this.isValueAssigned();
    }

    public abstract String parse(String var1);

    public abstract String getValueAsString();
}

