/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.params;

import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.params.ParamManager;
import edu.ucsd.msjava.params.Parameter;

public class ToleranceParameter
extends Parameter {
    private Tolerance leftTolerance;
    private Tolerance rightTolerance;
    private boolean allowAsymmetricValues = true;

    public ToleranceParameter(ParamManager.ParamNameEnum paramInfo) {
        super(paramInfo.getKey(), paramInfo.getName(), paramInfo.getDescription());
        this.setAdditionalDescription(paramInfo.getAdditionalDescription());
    }

    public ToleranceParameter defaultValue(String value) {
        super.setOptional();
        String error = this.parse(value);
        if (error != null) {
            System.err.println("(ToleranceParameter) Error while setting default value: " + error);
            System.exit(-1);
        }
        return this;
    }

    public ToleranceParameter doNotAllowAsymmetricValues() {
        this.allowAsymmetricValues = false;
        return this;
    }

    @Override
    public String parse(String value) {
        String[] token = value.split(",");
        if (token.length == 1) {
            this.leftTolerance = this.rightTolerance = Tolerance.parseToleranceStr(token[0]);
        } else if (token.length == 2) {
            if (this.allowAsymmetricValues) {
                this.leftTolerance = Tolerance.parseToleranceStr(token[0]);
                this.rightTolerance = Tolerance.parseToleranceStr(token[1]);
            } else {
                return "asymmetric values are not allowed";
            }
        }
        if (this.leftTolerance == null || this.rightTolerance == null) {
            return "invalid tolerance value";
        }
        if (this.leftTolerance.isTolerancePPM() != this.rightTolerance.isTolerancePPM()) {
            return "left and right tolerance units must be the same";
        }
        if (this.leftTolerance.getValue() < 0.0f || this.rightTolerance.getValue() < 0.0f) {
            return "parent mass tolerance must not be negative";
        }
        return null;
    }

    @Override
    public String getValueAsString() {
        if (this.leftTolerance == null || this.rightTolerance == null) {
            return null;
        }
        return this.leftTolerance.toString() + "," + this.rightTolerance.toString();
    }

    public Tolerance getLeftTolerance() {
        return this.leftTolerance;
    }

    public Tolerance getRightTolerance() {
        return this.rightTolerance;
    }
}

