/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.parser;

import edu.ucsd.msjava.parser.LineReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import net.pempek.unicode.UnicodeBOMInputStream;
import org.apache.commons.lang3.tuple.Pair;

public class BufferedRandomAccessLineReader
implements LineReader {
    private static final int DEFAULT_BUFFER_SIZE = 65536;
    private long pointer;
    private byte[] buffer;
    int bufPointer;
    private int bufLength = -1;
    long bufStartingPos;
    private final byte CR = (byte)13;
    private final byte NL = (byte)10;
    private final FileChannel in;
    private long fileSize;
    int startIndex;
    int bufSize;
    int bomLength;

    public BufferedRandomAccessLineReader(String fileName) {
        this(fileName, 65536);
    }

    public BufferedRandomAccessLineReader(String fileName, int bufSize) {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        this.in = fin.getChannel();
        try {
            this.fileSize = this.in.size();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.bufSize = bufSize;
        this.pointer = 0L;
        this.fillBuffer();
    }

    private static boolean bytesMatchBOM(byte[] buf, UnicodeBOMInputStream.BOM bomType) {
        byte[] bomBytes = bomType.getBytes();
        int matchCount = 0;
        if (buf.length < bomBytes.length) {
            return false;
        }
        for (int i = 0; i < bomBytes.length && buf[i] == bomBytes[i]; ++i) {
            ++matchCount;
        }
        return matchCount == bomBytes.length;
    }

    public static String stripBOM(String str) {
        Pair<String, Integer> result = BufferedRandomAccessLineReader.stripBOMAndGetLength(str);
        return result.getKey();
    }

    public static Pair<String, Integer> stripBOMAndGetLength(String str) {
        byte[] buf = str.getBytes();
        int copyOffset = 0;
        if (buf.length >= 4) {
            if (BufferedRandomAccessLineReader.bytesMatchBOM(buf, UnicodeBOMInputStream.BOM.UTF_32_LE)) {
                copyOffset = 4;
            } else if (BufferedRandomAccessLineReader.bytesMatchBOM(buf, UnicodeBOMInputStream.BOM.UTF_32_BE)) {
                copyOffset = 4;
            }
        }
        if (copyOffset == 0 && buf.length >= 3 && BufferedRandomAccessLineReader.bytesMatchBOM(buf, UnicodeBOMInputStream.BOM.UTF_8)) {
            copyOffset = 3;
        }
        if (copyOffset == 0 && buf.length >= 2) {
            if (BufferedRandomAccessLineReader.bytesMatchBOM(buf, UnicodeBOMInputStream.BOM.UTF_16_LE)) {
                copyOffset = 2;
            } else if (BufferedRandomAccessLineReader.bytesMatchBOM(buf, UnicodeBOMInputStream.BOM.UTF_16_BE)) {
                copyOffset = 2;
            }
        }
        if (copyOffset > 0) {
            str = new String(Arrays.copyOfRange(buf, copyOffset, buf.length));
        }
        return Pair.of(str, copyOffset);
    }

    private int fillBuffer() {
        int bytesRead;
        ByteBuffer tempBuffer;
        block2: {
            tempBuffer = null;
            bytesRead = -1;
            try {
                tempBuffer = ByteBuffer.allocate(this.bufSize);
                bytesRead = this.in.read(tempBuffer);
            }
            catch (IOException e1) {
                if (Thread.currentThread().isInterrupted()) break block2;
                e1.printStackTrace();
            }
        }
        this.buffer = tempBuffer.array();
        this.bufLength = bytesRead;
        this.startIndex = 0;
        this.bufPointer = 0;
        this.bufStartingPos = this.pointer;
        return bytesRead;
    }

    @Override
    public String readLine() {
        if (this.pointer >= this.fileSize) {
            return null;
        }
        Boolean startOfFile = this.pointer == 0L;
        String str = this.readLineFromBuffer();
        if (startOfFile.booleanValue()) {
            Pair<String, Integer> result = BufferedRandomAccessLineReader.stripBOMAndGetLength(str);
            this.bomLength = result.getValue();
            if (this.bomLength > 0) {
                str = result.getKey();
            }
        }
        if (this.bufPointer == this.bufLength && this.bufLength == this.bufSize) {
            this.fillBuffer();
            str = str + this.readLine();
        } else if (this.pointer < this.fileSize) {
            ++this.bufPointer;
            ++this.pointer;
            this.startIndex = this.bufPointer;
        }
        return str;
    }

    private String readLineFromBuffer() {
        if (this.pointer >= this.fileSize) {
            return null;
        }
        while (this.pointer < this.fileSize && this.bufPointer < this.bufLength && this.buffer[this.bufPointer] != 10) {
            ++this.bufPointer;
            ++this.pointer;
        }
        try {
            String str = this.bufPointer > 0 && this.buffer[this.bufPointer - 1] == 13 ? new String(this.buffer, this.startIndex, this.bufPointer - this.startIndex - 1) : new String(this.buffer, this.startIndex, this.bufPointer - this.startIndex);
            return str;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("bufPointer " + this.bufPointer + " is larger than the buffer array, length " + this.buffer.length);
            throw e;
        }
    }

    public int getBOMLength() {
        return this.bomLength;
    }

    public long getPosition() {
        return this.pointer;
    }

    public void seek(long position) {
        this.pointer = position;
        if (position >= this.bufStartingPos && position < this.bufStartingPos + (long)this.bufSize) {
            this.startIndex = this.bufPointer = (int)(position - this.bufStartingPos);
        } else {
            block4: {
                try {
                    this.in.position(this.pointer);
                }
                catch (IOException e) {
                    if (Thread.currentThread().isInterrupted()) break block4;
                    e.printStackTrace();
                }
            }
            this.fillBuffer();
        }
    }

    public void reset() {
        this.pointer = 0L;
        this.startIndex = 0;
    }

    public int size() {
        return this.buffer.length;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public static void main(String[] argv) throws Exception {
        String s;
        long time = System.currentTimeMillis();
        String fileName = "/home/sangtaekim/Research/Data/ABRF/2011/UniProt.Yeast.NFISnr.contamsS48.fasta";
        BufferedRandomAccessLineReader in = new BufferedRandomAccessLineReader(fileName, 65536);
        int lineNum = 0;
        long pos = 0L;
        while ((s = in.readLine()) != null) {
            if (++lineNum != 48232) continue;
            pos = in.getPosition();
            System.out.println(lineNum + " " + s + " " + pos);
        }
        in.seek(pos);
        System.out.println(in.readLine());
        System.out.println("Time: " + (System.currentTimeMillis() - time));
    }
}

