/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.parser;

import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Annotation;
import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.parser.PSM;
import java.util.ArrayList;

public class InsPecTPSM
extends PSM {
    private String insPecTString;
    private long specFilePos;
    private AminoAcid precedingAA;
    private AminoAcid succeedingAA;
    private ArrayList<Integer> scanNumList;

    public AminoAcid getPrecedingAA() {
        return this.precedingAA;
    }

    public AminoAcid getSucceedingAA() {
        return this.succeedingAA;
    }

    public Annotation getAnnotation() {
        return new Annotation(this.precedingAA, super.getPeptide(), this.succeedingAA);
    }

    public String getInsPecTString() {
        return this.insPecTString;
    }

    public long getSpecFilePos() {
        return this.specFilePos;
    }

    public ArrayList<Integer> getScanNumList() {
        return this.scanNumList;
    }

    public void setPrecedingAA(AminoAcid precedingAA) {
        this.precedingAA = precedingAA;
    }

    public void setSucceedingAA(AminoAcid succeedingAA) {
        this.succeedingAA = succeedingAA;
    }

    public void setSpecFilePos(long specFilePos) {
        this.specFilePos = specFilePos;
    }

    public void setInsPecTString(String insPecTString) {
        this.insPecTString = insPecTString;
    }

    public void setScanNumList(ArrayList<Integer> scanNumList) {
        this.scanNumList = scanNumList;
    }

    public AminoAcidSet getAASet(AminoAcidSet baseAASet) {
        Peptide peptide = this.getPeptide();
        if (peptide != null && peptide.isModified()) {
            ArrayList<AminoAcid> modAAList = new ArrayList<AminoAcid>();
            for (AminoAcid aa : peptide) {
                if (!aa.isModified()) continue;
                modAAList.add(aa);
            }
            return AminoAcidSet.getAminoAcidSetFromModAAList(baseAASet, modAAList);
        }
        return baseAASet;
    }
}

