/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.parser;

import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.parser.BufferedLineReader;
import edu.ucsd.msjava.parser.PSM;
import edu.ucsd.msjava.parser.PSMList;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Hashtable;

public class MascotParser {
    private MascotParser() {
    }

    public static PSMList<PSM> parseFromDat(String fileName, boolean isDecoy) {
        BufferedLineReader in = null;
        try {
            in = new BufferedLineReader(fileName);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        int mode = 0;
        String specFileName = null;
        int numQueries = 0;
        PSMList<PSM> psmList = new PSMList<PSM>();
        class SimplePSMList
        extends PSMList<PSM> {
            private static final long serialVersionUID = 1L;

            SimplePSMList() {
            }
        }
        SimplePSMList[] psmArr = null;
        class SimpleMod {
            String name;
            float mass;
            String residue;

            public SimpleMod(String name, float mass, String residue) {
                this.name = name;
                this.mass = mass;
                this.residue = residue;
            }
        }
        SimpleMod[] mods = null;
        Hashtable<Integer, String> queryTitleMap = new Hashtable<Integer, String>();
        Hashtable<Integer, Integer> queryChargeMap = new Hashtable<Integer, Integer>();
        try {
            String s;
            while ((s = in.readLine()) != null) {
                Peptide pep;
                float modMass;
                int modIndex;
                char v;
                String[] token;
                if (s.startsWith("Content-Type:")) {
                    if (s.equalsIgnoreCase("Content-Type: application/x-Mascot; name=\"parameters\"")) {
                        mode = 0;
                        while ((s = in.readLine()) != null) {
                            if (s.startsWith("FILE=")) {
                                String[] token2 = s.split("[/\\\\]");
                                if (specFileName != null) continue;
                                specFileName = token2[token2.length - 1];
                                continue;
                            }
                            if (s.startsWith("CLE=") || s.startsWith("MODS=")) continue;
                            if (s.startsWith("IT_MODS")) {
                                int numMods = s.split(",").length;
                                mods = new SimpleMod[numMods];
                                continue;
                            }
                            if (!s.equalsIgnoreCase("--gc0p4Jq0M2Yt08jU534c0p")) continue;
                            break;
                        }
                    } else if (s.equalsIgnoreCase("Content-Type: application/x-Mascot; name=\"masses\"")) {
                        mode = 5;
                    } else if (s.equalsIgnoreCase("Content-Type: application/x-Mascot; name=\"header\"")) {
                        mode = 1;
                        while (!(s = in.readLine()).startsWith("queries")) {
                        }
                        numQueries = Integer.parseInt(s.substring(s.indexOf(61) + 1));
                    } else if (s.equalsIgnoreCase("Content-Type: application/x-Mascot; name=\"peptides\"")) {
                        if (!isDecoy) {
                            mode = 2;
                            psmArr = new SimplePSMList[numQueries];
                        } else {
                            mode = -1;
                        }
                    } else if (s.equalsIgnoreCase("Content-Type: application/x-Mascot; name=\"decoy_peptides\"")) {
                        if (isDecoy) {
                            mode = 2;
                            psmArr = new SimplePSMList[numQueries];
                        } else {
                            mode = -1;
                        }
                    } else if (s.startsWith("Content-Type: application/x-Mascot; name=\"query")) {
                        mode = 3;
                        int queryNum = Integer.parseInt(s.substring(s.lastIndexOf("query") + 5, s.lastIndexOf(34)));
                        while ((s = in.readLine()) != null && !s.startsWith("title=")) {
                        }
                        String titleStr = s.substring(s.lastIndexOf(61) + 1);
                        String title = URLDecoder.decode(titleStr, "UTF-8");
                        queryTitleMap.put(queryNum, title);
                        while ((s = in.readLine()) != null && !s.startsWith("charge=")) {
                        }
                        int charge = s.endsWith("Mr") || s.contains(",") ? 0 : (s.contains("=+") ? Integer.parseInt(s.substring(s.lastIndexOf(43) + 1)) : Integer.parseInt(s.substring(s.indexOf(61) + 1, s.lastIndexOf(43))));
                        queryChargeMap.put(queryNum, charge);
                    } else {
                        mode = -1;
                    }
                }
                if (mode == -1) continue;
                if (mode == 5) {
                    String keyword = "delta";
                    if (s.length() <= 0 || !s.startsWith(keyword)) continue;
                    int modIndex2 = Integer.parseInt(s.substring(keyword.length(), s.indexOf(61))) - 1;
                    String ptmStr = s.substring(s.indexOf(61) + 1);
                    String[] token3 = ptmStr.split(",");
                    float mass = Float.parseFloat(token3[0]);
                    String[] token2 = token3[1].split("\\s+");
                    String ptmName = token2[0];
                    StringBuffer residueStrBuf = new StringBuffer();
                    for (int i = 1; i < token2.length; ++i) {
                        residueStrBuf.append(token2[i]);
                    }
                    String residueStr = residueStrBuf.toString();
                    String ptmResidues = residueStr.substring(residueStr.indexOf(40) + 1, residueStr.lastIndexOf(41));
                    mods[modIndex2] = new SimpleMod(ptmName, mass, ptmResidues);
                    continue;
                }
                if (mode != 2 || s.length() <= 0 || (token = s.split("[=,;]")).length <= 3 || !s.matches("q\\d+_p\\d+=.*")) continue;
                int queryNum = Integer.parseInt(token[0].substring(token[0].indexOf(113) + 1, token[0].indexOf(95)));
                String peptide = token[5];
                String modVector = token[7];
                float score = Float.parseFloat(token[8]);
                String protein = token[12];
                while ((s = in.readLine()) != null && !s.matches("q\\d+_p\\d+_terms=.*")) {
                }
                if (s == null) continue;
                String[] token2 = s.split("[=,]");
                char nTermResidue = token2[1].charAt(0);
                char cTermResidue = token2[2].charAt(0);
                StringBuffer pepStr = new StringBuffer();
                if (modVector.charAt(0) != '0') {
                    v = modVector.charAt(0);
                    modIndex = v - 48 - 1;
                    modMass = mods[modIndex].mass;
                    if (modMass > 0.0f) {
                        pepStr.append("+");
                    }
                    pepStr.append(modMass);
                }
                for (int i = 1; i < modVector.length() - 1; ++i) {
                    char v2 = modVector.charAt(i);
                    pepStr.append(peptide.charAt(i - 1));
                    if (v2 == '0') continue;
                    int modIndex3 = v2 - 48 - 1;
                    float modMass2 = mods[modIndex3].mass;
                    if (modMass2 > 0.0f) {
                        pepStr.append("+");
                    }
                    pepStr.append(modMass2);
                }
                if (modVector.charAt(modVector.length() - 1) != '0') {
                    v = modVector.charAt(modVector.length() - 1);
                    modIndex = v - 48 - 1;
                    modMass = mods[modIndex].mass;
                    if (modMass > 0.0f) {
                        pepStr.append("+");
                    }
                    pepStr.append(modMass);
                }
                if ((pep = new Peptide(pepStr.toString())).isInvalid()) continue;
                PSM psm = new PSM().peptide(pep).precedingResidue(nTermResidue).succeedingResidue(cTermResidue);
                psm.rawScore(score);
                psm.ptm(modVector);
                if (isDecoy) {
                    protein = "XXX_" + protein;
                }
                psm.protein(protein);
                if (psmArr[queryNum - 1] == null) {
                    psmArr[queryNum - 1] = new SimplePSMList();
                }
                psmArr[queryNum - 1].add(psm);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (int queryNum = 1; queryNum <= numQueries; ++queryNum) {
            String title = (String)queryTitleMap.get(queryNum);
            Integer charge = (Integer)queryChargeMap.get(queryNum);
            if (title == null || charge == null || psmArr[queryNum - 1] == null) continue;
            for (PSM psm : psmArr[queryNum - 1]) {
                psm.title(title);
                psm.charge(charge);
                psmList.add(psm);
            }
        }
        return psmList;
    }

    public static HashMap<Integer, Integer> getQueryNumChargeMap(String fileName) {
        String s;
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        BufferedLineReader in = null;
        try {
            in = new BufferedLineReader(fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        boolean isSummary = false;
        while ((s = in.readLine()) != null) {
            if (!isSummary) {
                if (!s.startsWith("--gc0p4Jq0M2Yt08jU534c0p")) continue;
                isSummary = true;
                continue;
            }
            if (!s.startsWith("qexp")) continue;
            int qNum = Integer.parseInt(s.substring(4, s.lastIndexOf(61)));
            int charge = Integer.parseInt(s.substring(s.lastIndexOf(44) + 1, s.lastIndexOf(43)));
            map.put(qNum, charge);
        }
        try {
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return map;
    }
}

