/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.parser;

import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.parser.MzXMLSpectraMap;
import java.util.Iterator;

public class MzXMLSpectraIterator
implements Iterator<Spectrum> {
    private MzXMLSpectraMap map;
    private boolean hasNext;
    private int scanNum;
    private Spectrum currentSpectrum;

    public MzXMLSpectraIterator(String fileName) {
        this(fileName, 2, Integer.MAX_VALUE);
    }

    public MzXMLSpectraIterator(String fileName, int minMSLevel, int maxMSLevel) {
        this.map = new MzXMLSpectraMap(fileName).msLevel(minMSLevel, maxMSLevel);
        this.scanNum = 0;
        this.currentSpectrum = this.parseNextSpectrum();
        this.hasNext = this.currentSpectrum != null;
    }

    @Override
    public Spectrum next() {
        Spectrum curSpecCopy = this.currentSpectrum;
        this.currentSpectrum = this.parseNextSpectrum();
        if (this.currentSpectrum == null) {
            this.hasNext = false;
        }
        return curSpecCopy;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    private Spectrum parseNextSpectrum() {
        Spectrum spec = null;
        while (++this.scanNum <= this.map.getMaxScanNumber() && (spec = this.map.getSpectrumBySpecIndex(this.scanNum)) == null) {
        }
        return spec;
    }

    @Override
    public void remove() {
        assert (false);
    }
}

