/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.parser;

import edu.ucsd.msjava.msutil.ActivationMethod;
import edu.ucsd.msjava.msutil.Composition;
import edu.ucsd.msjava.msutil.Peak;
import edu.ucsd.msjava.msutil.ScanType;
import edu.ucsd.msjava.msutil.SpectraIterator;
import edu.ucsd.msjava.msutil.SpectraMap;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.msutil.SpectrumMetaInfo;
import edu.ucsd.msjava.parser.BufferedLineReader;
import edu.ucsd.msjava.parser.BufferedRandomAccessLineReader;
import edu.ucsd.msjava.parser.LineReader;
import edu.ucsd.msjava.parser.SpectrumParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;

public class PNNLSpectrumParser
implements SpectrumParser {
    public static final String SCAN_TYPE_FILE_EXTENSION = "_ScanType.txt";

    @Override
    public long getScanMissingWarningCount() {
        return 0L;
    }

    @Override
    public Spectrum readSpectrum(LineReader lineReader) {
        String buf;
        ArrayList spec = null;
        float prevMass = 0.0f;
        boolean isSorted = true;
        while ((buf = lineReader.readLine()) != null) {
            String[] token2;
            if (buf.length() == 0) {
                if (spec == null) continue;
                if (!isSorted) {
                    Collections.sort(spec);
                }
                return spec;
            }
            if (buf.startsWith("==")) {
                if (spec != null) {
                    System.out.println("There must be at least one empty line between spectra: " + buf);
                    System.exit(-1);
                }
                int lastDotIndex = buf.lastIndexOf(46);
                int secondLastDotIndex = buf.lastIndexOf(46, lastDotIndex - 1);
                int thirdLastDotIndex = buf.lastIndexOf(46, secondLastDotIndex - 1);
                int fourthLastDotIndex = buf.lastIndexOf(46, thirdLastDotIndex - 1);
                int scanNum = Integer.parseInt(buf.substring(fourthLastDotIndex + 1, thirdLastDotIndex));
                String annotation = buf;
                buf = lineReader.readLine();
                if (buf == null || buf.trim().length() == 0) {
                    System.out.println("Error while parsing _Dta.txt file: " + annotation);
                    System.out.println("No spectrum!");
                    System.exit(-1);
                }
                spec = new Spectrum();
                String[] token = buf.split("\\s+");
                float mPlusH = Float.parseFloat(token[0]);
                int charge = Integer.parseInt(token[1].substring(token[1].indexOf(61) + 1));
                float precursorMz = (mPlusH - (float)Composition.ChargeCarrierMass()) / (float)charge + (float)Composition.ChargeCarrierMass();
                ((Spectrum)spec).setPrecursor(new Peak(precursorMz, 0.0f, charge));
                ((Spectrum)spec).setScanNum(scanNum);
                continue;
            }
            if (!Character.isDigit(buf.charAt(0))) continue;
            if (spec == null) {
                System.out.println("Error while parsing _Dta.txt file.");
                System.out.println("Header line is missing: " + buf);
                System.exit(-1);
            }
            if ((token2 = buf.split("\\s+")).length != 2) continue;
            float mass = Float.parseFloat(token2[0]);
            if (isSorted && mass < prevMass) {
                isSorted = false;
            }
            float intensity = Float.parseFloat(token2[1]);
            spec.add(new Peak(mass, intensity, 1));
            prevMass = mass;
        }
        return spec;
    }

    @Override
    public Map<Integer, SpectrumMetaInfo> getSpecMetaInfoMap(BufferedRandomAccessLineReader lineReader) {
        String buf;
        Hashtable<Integer, SpectrumMetaInfo> specIndexMap = new Hashtable<Integer, SpectrumMetaInfo>();
        long offset = 0L;
        int specIndex = 0;
        while ((buf = lineReader.readLine()) != null) {
            if (buf.startsWith("==")) {
                ++specIndex;
                int lastDotIndex = buf.lastIndexOf(46);
                int secondLastDotIndex = buf.lastIndexOf(46, lastDotIndex - 1);
                int thirdLastDotIndex = buf.lastIndexOf(46, secondLastDotIndex - 1);
                int fourthLastDotIndex = buf.lastIndexOf(46, thirdLastDotIndex - 1);
                String annotation = buf;
                buf = lineReader.readLine();
                if (buf == null || buf.trim().length() == 0) {
                    System.out.println("Error while parsing _Dta.txt file: " + annotation);
                    System.out.println("No spectrum!");
                    System.exit(-1);
                }
                String[] token = buf.split("\\s+");
                float mPlusH = Float.parseFloat(token[0]);
                int charge = Integer.parseInt(token[1].substring(token[1].indexOf(61) + 1));
                float precursorMz = (mPlusH - (float)Composition.ChargeCarrierMass()) / (float)charge + (float)Composition.ChargeCarrierMass();
                SpectrumMetaInfo metaInfo = new SpectrumMetaInfo();
                metaInfo.setID("index=" + (specIndex - 1));
                metaInfo.setPrecursorMz(precursorMz);
                metaInfo.setPosition(offset);
                specIndexMap.put(specIndex, metaInfo);
            }
            offset = lineReader.getPosition();
        }
        return specIndexMap;
    }

    static HashMap<Integer, ScanType> getScanTypeMap(String fileName) {
        File specFile = new File(fileName);
        String scanTypeFileName = specFile.getAbsoluteFile().getParentFile().getPath() + File.separator + specFile.getName().substring(0, specFile.getName().lastIndexOf(95)) + SCAN_TYPE_FILE_EXTENSION;
        File scanTypeFile = new File(scanTypeFileName);
        if (!scanTypeFile.exists()) {
            return null;
        }
        HashMap<Integer, ScanType> scanNumScanTypeMap = new HashMap<Integer, ScanType>();
        BufferedLineReader in = null;
        try {
            in = new BufferedLineReader(scanTypeFile.getPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String s = in.readLine();
        boolean hasScanTimes = false;
        String[] hTokens = s.split("\t");
        if (hTokens.length > 3 && hTokens[3].toLowerCase().contains("time")) {
            hasScanTimes = true;
        }
        while ((s = in.readLine()) != null) {
            String[] token = s.split("\t");
            if (token.length < 3) continue;
            int scanNum = Integer.parseInt(token[0]);
            String scanType = token[1].toLowerCase();
            ActivationMethod method = null;
            if (scanType.contains("etcid")) {
                method = ActivationMethod.ETD;
            } else if (scanType.contains("ethcd")) {
                method = ActivationMethod.ETD;
            } else if (scanType.contains("cid")) {
                method = ActivationMethod.CID;
            } else if (scanType.contains("etd")) {
                method = ActivationMethod.ETD;
            } else if (scanType.contains("hcd")) {
                method = ActivationMethod.HCD;
            } else if (scanType.contains("pqd")) {
                method = ActivationMethod.PQD;
            }
            boolean isHighPrecision = false;
            if (scanType.contains("hms")) {
                isHighPrecision = true;
            }
            int msLevel = Integer.parseInt(token[2]);
            float scanTime = -1.0f;
            if (hasScanTimes && token.length > 3) {
                scanTime = Float.parseFloat(token[3]);
            }
            if (method == null) continue;
            scanNumScanTypeMap.put(scanNum, new ScanType(method, isHighPrecision, msLevel, scanTime));
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return scanNumScanTypeMap;
    }

    public static void main(String[] argv) throws Exception {
        long time = System.currentTimeMillis();
        String fileName = System.getProperty("user.home") + "/Research/ToolDistribution/PNNLTest/QC_Shew_08_04_pt5_b_22Jan09_Owl_09-01-04_dta.txt";
        SpectraIterator itr = new SpectraIterator(fileName, (SpectrumParser)new PNNLSpectrumParser());
        int numSpecs = 0;
        HashSet<Integer> scanNumSet = new HashSet<Integer>();
        while (itr.hasNext()) {
            Spectrum spec = itr.next();
            ++numSpecs;
            if (scanNumSet.contains(spec.getScanNum())) {
                System.out.println(spec.getScanNum());
                continue;
            }
            scanNumSet.add(spec.getScanNum());
        }
        System.out.println("NumSpecs: " + numSpecs);
        System.out.println("Time: " + (System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        SpectraMap map = new SpectraMap(fileName, new PNNLSpectrumParser());
        numSpecs = 0;
        for (int specIndex : map.getSpecIndexList()) {
            Spectrum spec = map.getSpectrumBySpecIndex(specIndex);
            ++numSpecs;
        }
        System.out.println("NumSpecs: " + numSpecs);
        System.out.println("Time: " + (System.currentTimeMillis() - time));
    }
}

