/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.parser;

import edu.ucsd.msjava.msutil.SpectraMap;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.msutil.SpectrumAccessorBySpecIndex;
import edu.ucsd.msjava.parser.MS2SpectrumParser;
import edu.ucsd.msjava.parser.MgfSpectrumParser;
import edu.ucsd.msjava.parser.MzXMLSpectraMap;
import edu.ucsd.msjava.parser.PSM;
import edu.ucsd.msjava.parser.PklSpectrumParser;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;

public class PSMList<T extends PSM>
extends ArrayList<T> {
    private static final long serialVersionUID = 1L;

    public PSMList() {
    }

    public PSMList(Collection<T> c) {
        super(c);
    }

    public PSMList<T> getDistinctiveSpectralSet() {
        Hashtable<Integer, PSM> table = new Hashtable<Integer, PSM>();
        for (PSM psm : this) {
            PSM bestPSM = (PSM)table.get(psm.getScanNum());
            if (bestPSM != null && !(psm.getProbScore() < bestPSM.getProbScore())) continue;
            table.put(psm.getScanNum(), psm);
        }
        PSMList distinctSpecList = new PSMList(table.values());
        Collections.sort(distinctSpecList, new PSM.PSMSpecNumComparator());
        return distinctSpecList;
    }

    public PSMList<T> getDistinctivePeptideSet() {
        Hashtable<String, PSM> table = new Hashtable<String, PSM>();
        for (PSM psm : this) {
            PSM bestPSM = (PSM)table.get(psm.getPeptideStr());
            if (bestPSM != null && !(psm.getProbScore() < bestPSM.getProbScore())) continue;
            table.put(psm.getPeptideStr(), psm);
        }
        PSMList distinctPepList = new PSMList(table.values());
        Collections.sort(distinctPepList, new PSM.PSMSpecNumComparator());
        return distinctPepList;
    }

    public static <T extends PSM> PSMList<T> selectUsingFDR(PSMList<T> targetPSMList, PSMList<T> decoyPSMList, float fdrThreshold) {
        PSMList<T> selected = new PSMList<T>();
        Collections.sort(targetPSMList, new PSM.PSMProbScoreComparator());
        Collections.sort(decoyPSMList, new PSM.PSMProbScoreComparator());
        int indexTarget = -1;
        int indexDecoy = 0;
        float fdr = 0.0f;
        for (PSM targetPSM : targetPSMList) {
            ++indexTarget;
            if (indexDecoy >= decoyPSMList.size()) {
                if (!(fdr <= fdrThreshold)) continue;
                selected.add(targetPSM);
                continue;
            }
            if (targetPSM.getProbScore() < ((PSM)decoyPSMList.get(indexDecoy)).getProbScore()) {
                selected.add(targetPSM);
                continue;
            }
            while (indexDecoy < decoyPSMList.size() && targetPSM.getProbScore() >= ((PSM)decoyPSMList.get(indexDecoy)).getProbScore()) {
                ++indexDecoy;
            }
            fdr = (float)indexDecoy / (float)(indexTarget + 1);
            if (!(fdr <= fdrThreshold)) break;
            selected.add(targetPSM);
        }
        return selected;
    }

    public boolean outputMgf(File specDir, File outputFile, String scoreName, float threshold, boolean isGreaterBetter) {
        PrintStream out = null;
        try {
            out = new PrintStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        int numSpecs = 0;
        Hashtable<String, SpectrumAccessorBySpecIndex> fileList = new Hashtable<String, SpectrumAccessorBySpecIndex>();
        for (PSM psm : this) {
            Spectrum spec;
            if (psm.getProtein().contains("DECOY")) continue;
            Float score = Float.valueOf(psm.getScore(scoreName));
            if (score == null) {
                System.err.println(scoreName + " is not supported.");
                return false;
            }
            if (isGreaterBetter && score.floatValue() < threshold || !isGreaterBetter && score.floatValue() > threshold) continue;
            SpectrumAccessorBySpecIndex specAccessor = null;
            String fileName = psm.getSpecFileName();
            specAccessor = (SpectrumAccessorBySpecIndex)fileList.get(fileName);
            if (specAccessor == null) {
                File specFile = new File(specDir.getPath() + File.separator + psm.getSpecFileName());
                if (!specFile.exists()) {
                    System.err.println(psm.getSpecFileName() + " doesn't exist in " + specDir.getPath());
                    return false;
                }
                String ext = fileName.substring(fileName.lastIndexOf(46));
                if (ext.equalsIgnoreCase(".mzxml") || ext.equalsIgnoreCase(".xml")) {
                    specAccessor = new MzXMLSpectraMap(specFile.getPath());
                } else if (ext.equalsIgnoreCase(".mgf")) {
                    specAccessor = new SpectraMap(specFile.getPath(), new MgfSpectrumParser());
                } else if (ext.equalsIgnoreCase(".pkl")) {
                    specAccessor = new SpectraMap(specFile.getPath(), new PklSpectrumParser());
                } else if (ext.equalsIgnoreCase(".ms2")) {
                    specAccessor = new SpectraMap(specFile.getPath(), new MS2SpectrumParser());
                } else {
                    System.err.println("Unrecognizable format: " + psm.getSpecFileName());
                    return false;
                }
                fileList.put(fileName, specAccessor);
            }
            if ((spec = specAccessor.getSpectrumBySpecIndex(psm.getScanNum())) == null) {
                System.err.println("Spectrum doesn't exist: " + psm.getSpecFileName() + ":" + psm.getScanNum());
                return false;
            }
            spec.setTitle(psm.getSpecFileName() + ":" + psm.getScanNum() + " " + scoreName + "=" + score);
            spec.setAnnotation(psm.getPeptide());
            spec.outputMgf(out);
            ++numSpecs;
        }
        out.close();
        System.out.println(numSpecs + " spectra are stored.");
        return true;
    }

    public static <T extends PSM> PSM getBestPSM(PSMList<T> targetPSMList) {
        if (targetPSMList.isEmpty()) {
            return null;
        }
        Collections.sort(targetPSMList, new PSM.PSMProbScoreComparator());
        return (PSM)targetPSMList.get(0);
    }

    public static <T extends PSM> PSM getWorstPSM(PSMList<T> targetPSMList) {
        if (targetPSMList.isEmpty()) {
            return null;
        }
        Collections.sort(targetPSMList, new PSM.PSMProbScoreComparator());
        return (PSM)targetPSMList.get(targetPSMList.size() - 1);
    }
}

