/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.parser;

import edu.ucsd.msjava.msutil.Peak;
import edu.ucsd.msjava.msutil.SpectraIterator;
import edu.ucsd.msjava.msutil.SpectraMap;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.msutil.SpectrumMetaInfo;
import edu.ucsd.msjava.parser.BufferedRandomAccessLineReader;
import edu.ucsd.msjava.parser.LineReader;
import edu.ucsd.msjava.parser.SpectrumParser;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;

public class PklSpectrumParser
implements SpectrumParser {
    @Override
    public long getScanMissingWarningCount() {
        return 0L;
    }

    @Override
    public Spectrum readSpectrum(LineReader lineReader) {
        String buf;
        Spectrum spec = null;
        boolean sorted = true;
        float prevMass = 0.0f;
        while ((buf = lineReader.readLine()) != null) {
            String[] token = buf.split("\\s+");
            if (token.length == 3) {
                float precursorMz = Float.parseFloat(token[0]);
                float precursorIntensity = Float.parseFloat(token[1]);
                int charge = Integer.parseInt(token[2]);
                spec = new Spectrum(precursorMz, charge, precursorIntensity);
                continue;
            }
            if (token.length == 2) {
                assert (spec != null);
                float mass = Float.parseFloat(token[0]);
                if (sorted && mass < prevMass) {
                    sorted = false;
                } else {
                    prevMass = mass;
                }
                float intensity = Float.parseFloat(token[1]);
                spec.add(new Peak(mass, intensity, 1));
                continue;
            }
            if (spec == null) continue;
            if (!sorted) {
                Collections.sort(spec);
            }
            return spec;
        }
        return spec;
    }

    @Override
    public Map<Integer, SpectrumMetaInfo> getSpecMetaInfoMap(BufferedRandomAccessLineReader lineReader) {
        String buf;
        Hashtable<Integer, SpectrumMetaInfo> specIndexMap = new Hashtable<Integer, SpectrumMetaInfo>();
        long offset = 0L;
        int specIndex = 0;
        while ((buf = lineReader.readLine()) != null) {
            String[] token = buf.split("\\s+");
            if (token.length == 3) {
                float precursorMz = Float.parseFloat(token[0]);
                SpectrumMetaInfo metaInfo = new SpectrumMetaInfo();
                metaInfo.setID("index=" + (++specIndex - 1));
                metaInfo.setPrecursorMz(precursorMz);
                metaInfo.setPosition(offset);
                specIndexMap.put(specIndex, metaInfo);
            }
            offset = lineReader.getPosition();
        }
        return specIndexMap;
    }

    public static void test() throws Exception {
        String fileName = System.getProperty("user.home") + "/Research/ToolDistribution/RefTest/SpecFormatTest/TestSpectra.pkl";
        SpectraIterator iterator = new SpectraIterator(fileName, (SpectrumParser)new PklSpectrumParser());
        int numSpecs = 0;
        while (iterator.hasNext()) {
            Spectrum spec = iterator.next();
            ++numSpecs;
            System.out.println(spec.getPrecursorPeak().getMz() + " " + spec.getCharge() + " " + spec.getSpecIndex() + " " + spec.getScanNum());
        }
        System.out.println("NumSpectra: " + numSpecs);
        numSpecs = 0;
        SpectraMap map = new SpectraMap(fileName, new PklSpectrumParser());
        for (int specIndex : map.getSpecIndexList()) {
            Spectrum spec = map.getSpectrumBySpecIndex(specIndex);
            ++numSpecs;
            System.out.println(spec.getPrecursorPeak().getMz() + " " + spec.getCharge() + " " + spec.getSpecIndex() + " " + spec.getScanNum());
        }
        System.out.println("NumSpectra: " + numSpecs);
    }

    public static void main(String[] argv) throws Exception {
        PklSpectrumParser.test();
    }
}

