/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.parser;

import edu.ucsd.msjava.msutil.Pair;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.msutil.SpectrumAccessorBySpecIndex;
import edu.ucsd.msjava.parser.MzXMLSpectraIterator;
import edu.ucsd.msjava.parser.MzXMLSpectraMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class SortedSpectraIterator
implements Iterator<Spectrum> {
    private SpectrumAccessorBySpecIndex map;
    private boolean hasNext;
    private Spectrum currentSpectrum;
    private ArrayList<Integer> specIndexList;
    private int index;
    private final int numSpecs;

    public SortedSpectraIterator(Iterator<Spectrum> itr, SpectrumAccessorBySpecIndex map) {
        int numSpecs = 0;
        ArrayList<Pair<Integer, Float>> scanNumPMPairList = new ArrayList<Pair<Integer, Float>>();
        while (itr.hasNext()) {
            Spectrum spec = itr.next();
            scanNumPMPairList.add(new Pair<Integer, Float>(spec.getSpecIndex(), Float.valueOf(spec.getPrecursorMass())));
            ++numSpecs;
        }
        this.numSpecs = numSpecs;
        Collections.sort(scanNumPMPairList, new Pair.PairComparator(true));
        this.specIndexList = new ArrayList();
        for (Pair pair : scanNumPMPairList) {
            this.specIndexList.add((Integer)pair.getFirst());
        }
        this.map = map;
        this.index = -1;
        this.currentSpectrum = this.parseNextSpectrum();
        this.hasNext = this.currentSpectrum != null;
    }

    @Override
    public Spectrum next() {
        Spectrum curSpecCopy = this.currentSpectrum;
        this.currentSpectrum = this.parseNextSpectrum();
        if (this.currentSpectrum == null) {
            this.hasNext = false;
        }
        return curSpecCopy;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    public int size() {
        return this.numSpecs;
    }

    private Spectrum parseNextSpectrum() {
        ++this.index;
        if (this.index >= this.specIndexList.size()) {
            return null;
        }
        int specIndex = this.specIndexList.get(this.index);
        return this.map.getSpectrumBySpecIndex(specIndex);
    }

    @Override
    public void remove() {
        assert (false);
    }

    public static void main(String[] argv) {
        long time = System.currentTimeMillis();
        String fileName = "/home/sangtaekim/Research/Data/HeckWhole/Spectra/090121_NM_Trypsin_20.mzXML";
        MzXMLSpectraIterator itr = new MzXMLSpectraIterator(fileName);
        MzXMLSpectraMap map = new MzXMLSpectraMap(fileName);
        SortedSpectraIterator sortedItr = new SortedSpectraIterator(itr, map);
        int numSpecs = 0;
        while (sortedItr.hasNext()) {
            Spectrum spec = sortedItr.next();
            System.out.println(spec.getPrecursorMass());
            ++numSpecs;
        }
        System.out.println("NumSpecs: " + numSpecs);
        System.out.println("Time: " + (System.currentTimeMillis() - time));
    }
}

