/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.scripts;

import edu.ucsd.msjava.msgf.Histogram;
import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;

public class GetDBInfo {
    private static final int MAX_PEPTIDE_LENGTH = 50;

    public static void main(String[] argv) throws Exception {
        File dbFile;
        if (argv.length != 1 || !argv[0].endsWith(".fasta") && !argv[0].endsWith(".fa")) {
            System.err.println("usage: java CalcFastaDBSize *.fasta");
            System.exit(-1);
        }
        if (!(dbFile = new File(argv[0])).exists()) {
            System.err.println(argv[0] + " doen't exist!");
            System.exit(-1);
        }
        GetDBInfo.getDBInfo(dbFile);
    }

    public static void getDBInfo(File dbFile) throws Exception {
        int i;
        String s;
        BufferedReader in = new BufferedReader(new FileReader(dbFile));
        int length = 0;
        int numProteins = 0;
        int[] numTrypticPeptides = new int[51];
        Histogram<Integer> hist = new Histogram<Integer>();
        int pepLen = 0;
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
        while ((s = in.readLine()) != null) {
            if (s.startsWith(">")) {
                ++numProteins;
                pepLen = 0;
                continue;
            }
            length += s.length();
            for (i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                AminoAcid aa = aaSet.getAminoAcid(c);
                if (aa != null) {
                    hist.add(aaSet.getIndex(aa));
                }
                if (c == 'K' || c == 'R') {
                    if (pepLen >= 4 && pepLen < numTrypticPeptides.length - 1) {
                        int n = ++pepLen;
                        numTrypticPeptides[n] = numTrypticPeptides[n] + 1;
                    }
                    pepLen = 0;
                    continue;
                }
                if (aa == null) {
                    pepLen = 0;
                    continue;
                }
                ++pepLen;
            }
        }
        System.out.println("#Proteins: " + numProteins);
        System.out.println("#Amino acids: " + length);
        System.out.println("#Tryptic Peptides (with no miscleavage)");
        System.out.println("Length\tNumber");
        for (i = 5; i < numTrypticPeptides.length; ++i) {
            System.out.println(i + "\t" + numTrypticPeptides[i]);
        }
        System.out.println("Amino acid composition:");
        ArrayList keyList = new ArrayList(hist.keySet());
        Collections.sort(keyList);
        for (Integer key : keyList) {
            System.out.println(aaSet.getAminoAcid(key).getResidueStr() + "\t" + (float)hist.get(key).intValue() / (float)hist.totalCount());
        }
    }
}

