/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.sequences;

import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.sequences.MassSequence;
import edu.ucsd.msjava.sequences.ProteinFastaSequence;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class ProteinFastaSequences
implements MassSequence {
    private ArrayList<String> files;
    private ArrayList<Long> positions;
    private ArrayList<ProteinFastaSequence> sequences;
    private ProteinFastaSequence current;
    private int currentIndex;
    private String aaSpec;
    private int id;
    private static final String metafileName = "sequences.pinfo";

    public ProteinFastaSequences(String directory, boolean randomAccess) {
        this(directory, "A:C:D:E:F:G:H:IL:KQ:M:N:P:R:S:T:V:W:Y", AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCysWithTerm(), randomAccess);
    }

    public ProteinFastaSequences(String directory, String aaSpec, AminoAcidSet aaSet, boolean randomAccess) {
        File dir = new File(directory);
        this.aaSpec = aaSpec;
        if (randomAccess) {
            this.sequences = new ArrayList();
        }
        if (new File(dir, metafileName).exists()) {
            try {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(new File(dir, metafileName).getPath()));
                this.files = (ArrayList)in.readObject();
                this.positions = (ArrayList)in.readObject();
                in.close();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (randomAccess) {
                for (String fileName : this.files) {
                    this.sequences.add(new ProteinFastaSequence(fileName, aaSpec));
                }
            }
        } else {
            this.files = new ArrayList();
            this.positions = new ArrayList();
            long cumPos = 0L;
            for (String file : dir.list()) {
                if (!file.endsWith(".fasta")) continue;
                ProteinFastaSequence seq = new ProteinFastaSequence(new File(dir, file).getPath(), aaSpec, aaSet);
                System.out.println("Loaded " + file);
                this.files.add(new File(dir, file).getPath());
                this.positions.add(cumPos += seq.getSize());
                if (!randomAccess) continue;
                this.sequences.add(seq);
            }
            try {
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(new File(dir, metafileName).getPath()));
                out.writeObject(this.files);
                out.writeObject(this.positions);
                out.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.currentIndex = -1;
        this.current = this.getSequence(0);
        this.id = this.current.getId();
    }

    private ProteinFastaSequence getSequence(int index) {
        if (this.sequences == null) {
            if (index != this.currentIndex) {
                this.current = new ProteinFastaSequence(this.files.get(index), this.aaSpec);
                this.currentIndex = index;
            }
            return this.current;
        }
        return this.sequences.get(index);
    }

    public Iterator<ProteinFastaSequence> getSequenceIterator() {
        return new PFSIterator();
    }

    private long translate(long position) {
        int matchIndex = Collections.binarySearch(this.positions, position);
        long offset = 0L;
        int sequenceIndex = 0;
        sequenceIndex = matchIndex < 0 ? -matchIndex - 1 - 1 : matchIndex - 1;
        if (sequenceIndex >= 0) {
            offset = this.positions.get(sequenceIndex);
        }
        return (long)(++sequenceIndex) << 32 | (long)((int)(position - offset));
    }

    @Override
    public int getAlphabetSize() {
        return this.current.getAlphabetSize();
    }

    @Override
    public String getAnnotation(long position) {
        long pair = this.translate(position);
        return this.getSequence((int)(pair >>> 32)).getAnnotation((int)pair);
    }

    @Override
    public byte getByteAt(long position) {
        long pair = this.translate(position);
        return this.getSequence((int)(pair >>> 32)).getByteAt((int)pair);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getMatchingEntry(long position) {
        long pair = this.translate(position);
        return this.getSequence((int)(pair >>> 32)).getMatchingEntry((int)pair);
    }

    @Override
    public String getMatchingEntry(String name) {
        for (ProteinFastaSequence sequence : this.sequences) {
            String match = sequence.getMatchingEntry(name);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    @Override
    public long getSize() {
        return this.positions.get(this.positions.size() - 1);
    }

    @Override
    public char toChar(byte b) {
        return this.current.toChar(b);
    }

    @Override
    public String toString(byte[] sequence) {
        return this.current.toString(sequence);
    }

    @Override
    public char getCharAt(long position) {
        long pair = this.translate(position);
        return this.getSequence((int)(pair >>> 32)).getCharAt((int)pair);
    }

    @Override
    public int getIntegerMass(long index) {
        long pair = this.translate(index);
        return this.getSequence((int)(pair >>> 32)).getIntegerMass((int)pair);
    }

    @Override
    public int getIntegerMass(long start, long end) {
        long pair1 = this.translate(start);
        long pair2 = this.translate(end);
        int seqIndex = (int)(pair1 >>> 32);
        return this.getSequence(seqIndex).getIntegerMass((int)pair1, (int)pair2);
    }

    @Override
    public byte[] getBytes(int start, int end) {
        long pair1 = this.translate(start);
        long pair2 = this.translate(end);
        int seqIndex = (int)(pair1 >>> 32);
        return this.getSequence(seqIndex).getBytes((int)pair1, (int)pair2);
    }

    @Override
    public boolean isInAlphabet(char c) {
        return this.current.isInAlphabet(c);
    }

    @Override
    public boolean isTerminator(long position) {
        long pair = this.translate(position);
        return this.getSequence((int)(pair >>> 32)).isTerminator((int)pair);
    }

    @Override
    public boolean isValid(long position) {
        long pair = this.translate(position);
        return this.getSequence((int)(pair >>> 32)).isValid((int)pair);
    }

    @Override
    public byte toByte(char c) {
        return this.current.toByte(c);
    }

    @Override
    public Collection<Character> getAlphabet() {
        return this.current.getAlphabet();
    }

    @Override
    public Set<Byte> getAlphabetAsBytes() {
        return this.current.getAlphabetAsBytes();
    }

    @Override
    public boolean hasMass(long position) {
        long pair = this.translate(position);
        return this.getSequence((int)(pair >>> 32)).hasMass((int)pair);
    }

    @Override
    public String getSubsequence(long start, long end) {
        long pair1 = this.translate(start);
        long pair2 = this.translate(end);
        int seqIndex = (int)(pair1 >>> 32);
        return this.getSequence(seqIndex).getSubsequence((int)pair1, (int)pair2);
    }

    @Override
    public long getStartPosition(long position) {
        long pair = this.translate(position);
        long subStart = this.getSequence((int)(pair >>> 32)).getStartPosition((int)pair);
        return position - ((long)((int)pair) - subStart);
    }

    public static void main(String[] args) {
        String userHome = System.getProperty("user.home");
        String directory = userHome + "/Data/Databases/Hsapiens/translated";
        ProteinFastaSequences pfs = new ProteinFastaSequences(directory, false);
        System.out.println("Total number of bases: " + pfs.getSize());
        for (long start = 0L; start < pfs.getSize(); ++start) {
            if (start % 1000000L == 0L && pfs.isTerminator(start)) {
                System.out.println(pfs.getAnnotation(start));
            }
            pfs.getByteAt(start);
        }
    }

    private class PFSIterator
    implements Iterator<ProteinFastaSequence> {
        private int currentIndex;

        private PFSIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < ProteinFastaSequences.this.files.size();
        }

        @Override
        public ProteinFastaSequence next() {
            return new ProteinFastaSequence((String)ProteinFastaSequences.this.files.get(this.currentIndex++));
        }

        @Override
        public void remove() {
            System.err.println("Remove operation of Iterator<ProteinFastaSequence> not supported");
            System.exit(-9);
        }
    }
}

