/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.suffixarray;

public abstract class ByteSequence
implements Comparable<ByteSequence> {
    public static final int MAX_COMPARISON_LENGTH = 127;
    private final int PRINT_LIMIT = 80;

    public abstract byte getByteAt(int var1);

    public abstract int getSize();

    @Override
    public int compareTo(ByteSequence other) {
        return this.compareTo(other, 0);
    }

    public byte[] getSequence() {
        byte[] sequence = new byte[this.getSize()];
        int limit = this.getSize();
        for (int i = 0; i < limit; ++i) {
            sequence[i] = this.getByteAt(i);
        }
        return sequence;
    }

    public int compareTo(ByteSequence other, int start) {
        int offset;
        int limit = Math.min(this.getSize(), other.getSize());
        if (limit > 127) {
            limit = 127;
        }
        for (offset = start; offset < limit; ++offset) {
            byte otherByte;
            byte thisByte = this.getByteAt(offset);
            if (thisByte > (otherByte = other.getByteAt(offset))) {
                return offset + 1;
            }
            if (otherByte <= thisByte) continue;
            return -offset - 1;
        }
        if (this.getSize() > other.getSize()) {
            return offset + 1;
        }
        if (other.getSize() > this.getSize()) {
            return -offset - 1;
        }
        return 0;
    }

    public byte getLCP(ByteSequence other, int start) {
        int offset;
        int limit = Math.min(this.getSize(), other.getSize());
        if (limit > 127) {
            limit = 127;
        }
        for (offset = start; offset < limit; ++offset) {
            byte otherByte;
            byte thisByte = this.getByteAt(offset);
            if (thisByte <= (otherByte = other.getByteAt(offset)) && otherByte <= thisByte) continue;
            return (byte)offset;
        }
        return (byte)offset;
    }

    public int getLCPInt(ByteSequence other, int start) {
        int offset;
        int limit = Math.min(this.getSize(), other.getSize());
        for (offset = start; offset < limit; ++offset) {
            byte otherByte;
            byte thisByte = this.getByteAt(offset);
            if (thisByte <= (otherByte = other.getByteAt(offset)) && otherByte <= thisByte) continue;
            return offset;
        }
        return offset;
    }

    public byte getLCP(ByteSequence other) {
        return this.getLCP(other, 0);
    }

    public int getLCPInt(ByteSequence other) {
        return this.getLCPInt(other, 0);
    }

    public String toString() {
        String retVal = "";
        int limit = Math.min(this.getSize(), 80);
        for (int i = 0; i < limit; ++i) {
            retVal = retVal + this.getByteAt(i) + " ";
        }
        return retVal;
    }
}

