/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.suffixarray;

import edu.ucsd.msjava.sequences.FastaSequence;
import edu.ucsd.msjava.suffixarray.ByteSequence;

public class SuffixArraySequence
extends FastaSequence {
    public SuffixArraySequence(String filepath) {
        super(filepath, null);
    }

    public SuffixArraySequence(String filepath, String alphabet) {
        super(filepath, alphabet, ".seq");
    }

    public SuffixArraySequence(String filepath, String alphabet, String seqExtension) {
        super(filepath, alphabet, seqExtension);
    }

    public String toString(ByteSequence sequence) {
        StringBuffer retVal = new StringBuffer(sequence.getSize());
        int i = sequence.getSize();
        int index = 0;
        while (i > 0) {
            retVal.append(this.getCharAt(index));
            --i;
            ++index;
        }
        return retVal.toString();
    }

    public boolean contains(ByteSequence pattern, long start) {
        return this.getLCP(pattern, start) == pattern.getSize();
    }

    public int getLCP(ByteSequence pattern, long start) {
        long limit = Math.min(this.getSize() - start, (long)pattern.getSize());
        int index = 0;
        while ((long)index < limit && pattern.getByteAt(index) == this.getByteAt((long)index + start)) {
            ++index;
        }
        return index;
    }

    public ByteSequence toBytes(String sequence) {
        byte[] retSeq = new byte[sequence.length()];
        for (int i = 0; i < retSeq.length; ++i) {
            retSeq[i] = this.isInAlphabet(sequence.charAt(i)) ? this.toByte(sequence.charAt(i)) : (byte)-1;
        }
        class EncodedSequence
        extends ByteSequence {
            private byte[] sequence;

            public EncodedSequence(byte[] sequence) {
                this.sequence = sequence;
            }

            @Override
            public byte getByteAt(int position) {
                return this.sequence[position];
            }

            @Override
            public int getSize() {
                return this.sequence.length;
            }
        }
        return new EncodedSequence(retSeq);
    }

    public boolean isEncodable(String s) {
        for (int index = 0; index < s.length(); ++index) {
            if (this.isInAlphabet(s.charAt(index))) continue;
            return false;
        }
        return true;
    }
}

