/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.cpdetector.util.collections;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public interface ITreeNode {
    public static final ITreeNode ROOT = new DefaultTreeNode();

    public Object getUserObject();

    public Object setUserObject(Object var1);

    public void mark();

    public void unmark();

    public boolean isMarked();

    public int getChildCount();

    public int getSubtreeCount();

    public Iterator getChilds();

    public ITreeNode getParent();

    public void setParent(ITreeNode var1);

    public boolean addChildNode(ITreeNode var1);

    public boolean addChildNodes(ITreeNode[] var1);

    public ITreeNode addChild(Object var1);

    public ITreeNode[] addChildren(Object[] var1);

    public boolean removeChild(ITreeNode var1);

    public ITreeNode remove(Object var1);

    public List removeAllChildren();

    public List getAllChildren();

    public boolean contains(Object var1);

    public boolean containsNode(ITreeNode var1);

    public boolean isLeaf();

    public boolean isRoot();

    public void getPathFromRoot(List var1);

    public void getUserObjectPathFromRoot(List var1);

    public boolean equals(Object var1);

    public ITreeNode newInstance();

    public static class DefaultTreeNode
    implements ITreeNode,
    Comparable {
        protected boolean marked = false;
        protected Object m_userObject = "root";
        ITreeNode m_parent = null;
        protected SortedSet m_children = new TreeSet();

        public boolean equals(Object obj) {
            boolean ret = false;
            if (obj instanceof DefaultTreeNode) {
                DefaultTreeNode other = (DefaultTreeNode)obj;
                Object myUser = this.getUserObject();
                Object himUser = other.getUserObject();
                ret = myUser == null ? himUser == null : myUser.equals(himUser);
            }
            return ret;
        }

        public DefaultTreeNode() {
        }

        public DefaultTreeNode(Object userObject) {
            this();
            this.m_userObject = userObject;
        }

        public DefaultTreeNode(Object userObject, ITreeNode child) {
            this(userObject);
            this.addChildNode(child);
        }

        public DefaultTreeNode(Object userObject, ITreeNode[] children) {
            this(userObject);
            for (int i = 0; i < children.length; ++i) {
                this.addChildNode(children[i]);
            }
        }

        public final ITreeNode addChild(Object userObject) {
            ITreeNode ret = this.newInstance();
            ret.setUserObject(userObject);
            if (this.addChildNode(ret)) {
                return ret;
            }
            return ret.getParent();
        }

        public boolean addChildNode(ITreeNode node) {
            if (node == null) {
                return false;
            }
            node.setParent(this);
            this.m_children.add(node);
            return true;
        }

        public final boolean contains(Object userObject) {
            if (this.m_userObject != null && this.m_userObject.equals(userObject)) {
                return true;
            }
            if (!this.isLeaf()) {
                Iterator it = this.m_children.iterator();
                while (it.hasNext()) {
                    if (!((ITreeNode)it.next()).contains(userObject)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }

        public final boolean containsNode(ITreeNode node) {
            if (this.equals(node)) {
                return true;
            }
            if (!this.isLeaf()) {
                Iterator it = this.m_children.iterator();
                while (it.hasNext()) {
                    if (!((ITreeNode)it.next()).contains(node)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }

        public final int getChildCount() {
            return this.m_children.size();
        }

        public final Iterator getChilds() {
            return this.m_children.iterator();
        }

        public final ITreeNode getParent() {
            return this.m_parent == null ? ROOT : this.m_parent;
        }

        public final int getSubtreeCount() {
            int ret = this.m_children.size();
            if (ret > 0) {
                Iterator it = this.m_children.iterator();
                while (it.hasNext()) {
                    ret += ((ITreeNode)it.next()).getSubtreeCount();
                }
            }
            if (this.m_parent == ROOT) {
                ++ret;
            }
            return ret;
        }

        public final Object getUserObject() {
            return this.m_userObject;
        }

        public final void mark() {
            this.marked = true;
        }

        public final boolean isMarked() {
            return this.marked;
        }

        public final ITreeNode remove(Object userObject) {
            ITreeNode ret = null;
            if (this.m_userObject != null && this.m_userObject.equals(userObject)) {
                this.m_parent.removeChild(this);
                this.m_parent = null;
                ret = this;
            } else if (!this.isLeaf()) {
                Iterator it = this.m_children.iterator();
                while (it.hasNext() && (ret = (ITreeNode)it.next()) == null) {
                }
            } else {
                return null;
            }
            return ret;
        }

        public final List removeAllChildren() {
            SortedSet ret = this.m_children;
            Iterator it = ret.iterator();
            while (it.hasNext()) {
                ((ITreeNode)it.next()).setParent(null);
            }
            this.m_children = new TreeSet();
            return new LinkedList(ret);
        }

        public boolean removeChild(ITreeNode node) {
            return this.m_children.remove(node);
        }

        public final Object setUserObject(Object store) {
            Object ret = this.m_userObject;
            this.m_userObject = store;
            return ret;
        }

        public final void unmark() {
            this.marked = false;
        }

        public final void setParent(ITreeNode parent) {
            if (this.m_parent != null) {
                this.m_parent.removeChild(this);
            }
            this.m_parent = parent;
        }

        public final boolean isLeaf() {
            return this.m_children.size() == 0;
        }

        public final boolean isRoot() {
            return this.m_parent == null;
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            this.toStringInternal(ret, 1);
            return ret.toString();
        }

        protected void toStringInternal(StringBuffer buf, int depth) {
            if (this.isLeaf()) {
                buf.append("-> ");
            }
            buf.append('(').append(String.valueOf(this.m_userObject)).append(')');
            StringBuffer spaceCollect = new StringBuffer();
            for (int i = depth; i > 0; --i) {
                spaceCollect.append("  ");
            }
            String indent = spaceCollect.toString();
            Iterator it = this.getChilds();
            while (it.hasNext()) {
                buf.append("\n").append(indent);
                ((DefaultTreeNode)it.next()).toStringInternal(buf, depth + 1);
            }
        }

        public final boolean addChildNodes(ITreeNode[] nodes) {
            boolean ret = true;
            for (int i = 0; i < nodes.length; ++i) {
                ret &= this.addChildNode(nodes[i]);
            }
            return ret;
        }

        public final ITreeNode[] addChildren(Object[] userObjects) {
            LinkedList<ITreeNode> treeNodes = new LinkedList<ITreeNode>();
            ITreeNode newNode = null;
            for (int i = 0; i < userObjects.length; ++i) {
                newNode = this.addChild(userObjects[i]);
                if (newNode == null) continue;
                treeNodes.add(newNode);
            }
            return treeNodes.toArray(new ITreeNode[treeNodes.size()]);
        }

        public final List getAllChildren() {
            return new LinkedList(this.m_children);
        }

        public ITreeNode newInstance() {
            return new DefaultTreeNode();
        }

        public void getPathFromRoot(List l) {
            if (this.isRoot()) {
                l.add(this);
            } else {
                this.getParent().getPathFromRoot(l);
                l.add(this);
            }
        }

        public void getUserObjectPathFromRoot(List l) {
            LinkedList collect = new LinkedList();
            this.getPathFromRoot(collect);
            Iterator it = collect.iterator();
            while (it.hasNext()) {
                l.add(((ITreeNode)it.next()).getUserObject());
            }
        }

        public int compareTo(Object o) throws ClassCastException {
            ITreeNode other = (ITreeNode)o;
            return ((Comparable)this.m_userObject).compareTo(other.getUserObject());
        }
    }
}

