/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.jrap.stax;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public final class Base64 {
    public static final boolean ENCODE = true;
    public static final boolean DECODE = false;
    public static final boolean COMPRESS = true;
    public static final boolean DONT_COMPRESS = false;
    private static final int MAX_LINE_LENGTH = 76;
    private static final byte EQUALS_SIGN = 61;
    private static final byte NEW_LINE = 10;
    private static final byte[] ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, -9, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9};
    private static final byte BAD_ENCODING = -9;
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;

    private Base64() {
    }

    public static void main(String[] args) {
        try {
            byte[] bytes1 = new byte[]{2, 2, 3, 0, 9};
            byte[] bytes2 = new byte[]{99, 2, 2, 3, 0, 9};
            System.out.println("Bytes 2,2,3,0,9 as Base64: " + Base64.encodeBytes(bytes1));
            System.out.println("Bytes 2,2,3,0,9 w/ offset: " + Base64.encodeBytes(bytes2, 1, bytes2.length - 1));
            byte[] dbytes = Base64.decode(Base64.encodeBytes(bytes1));
            System.out.print(Base64.encodeBytes(bytes1) + " decoded: ");
            for (int i = 0; i < dbytes.length; ++i) {
                System.out.print(dbytes[i] + (i < dbytes.length - 1 ? "," : "\n"));
            }
            FileInputStream fis = null;
            InputStream b64is = null;
            byte[] bytes = new byte[]{};
            int b = -1;
            bytes = Base64.readFile("test.gif.b64", false);
            ImageIcon iicon = new ImageIcon(bytes);
            JLabel jlabel = new JLabel("Read from test.gif.b64", iicon, 0);
            JFrame jframe = new JFrame();
            jframe.getContentPane().add(jlabel);
            jframe.pack();
            jframe.setVisible(true);
            FileOutputStream fos = new FileOutputStream("test.gif_out");
            fos.write(bytes);
            fos.close();
            fis = new FileInputStream("test.gif_out");
            b64is = new InputStream(fis, true);
            byte[] ebytes = new byte[]{};
            b = -1;
            while ((b = b64is.read()) >= 0) {
                byte[] temp = new byte[ebytes.length + 1];
                System.arraycopy(ebytes, 0, temp, 0, ebytes.length);
                temp[ebytes.length] = (byte)b;
                ebytes = temp;
            }
            b64is.close();
            String s = new String(ebytes);
            JTextArea jta = new JTextArea(s);
            JScrollPane jsp = new JScrollPane(jta);
            jframe = new JFrame();
            jframe.setTitle("Read from test.gif_out");
            jframe.getContentPane().add(jsp);
            jframe.pack();
            jframe.setVisible(true);
            fos = new FileOutputStream("test.gif.b64_out");
            fos.write(ebytes);
            fis = new FileInputStream("test.gif.b64_out");
            b64is = new InputStream(fis, false);
            byte[] edbytes = new byte[]{};
            b = -1;
            while ((b = b64is.read()) >= 0) {
                byte[] temp = new byte[edbytes.length + 1];
                System.arraycopy(edbytes, 0, temp, 0, edbytes.length);
                temp[edbytes.length] = (byte)b;
                edbytes = temp;
            }
            b64is.close();
            iicon = new ImageIcon(edbytes);
            jlabel = new JLabel("Read from test.gif.b64_out", iicon, 0);
            jframe = new JFrame();
            jframe.getContentPane().add(jlabel);
            jframe.pack();
            jframe.setVisible(true);
            fis = new FileInputStream("test.gif_out");
            byte[] rbytes = new byte[]{};
            int b2 = -1;
            while ((b2 = fis.read()) >= 0) {
                byte[] temp = new byte[rbytes.length + 1];
                System.arraycopy(rbytes, 0, temp, 0, rbytes.length);
                temp[rbytes.length] = (byte)b2;
                rbytes = temp;
            }
            fis.close();
            FileOutputStream fos2 = null;
            OutputStream b64os = null;
            Base64.writeFile(rbytes, "test.gif.b64", true);
            fis = new FileInputStream("test.gif.b64_out2");
            byte[] rebytes = new byte[]{};
            b2 = -1;
            while ((b2 = fis.read()) >= 0) {
                byte[] temp = new byte[rebytes.length + 1];
                System.arraycopy(rebytes, 0, temp, 0, rebytes.length);
                temp[rebytes.length] = (byte)b2;
                rebytes = temp;
            }
            fis.close();
            String s2 = new String(rebytes);
            JTextArea jta2 = new JTextArea(s2);
            JScrollPane jsp2 = new JScrollPane(jta2);
            JFrame jframe2 = new JFrame();
            jframe2.setTitle("Read from test.gif.b64_out2");
            jframe2.getContentPane().add(jsp2);
            jframe2.pack();
            jframe2.setVisible(true);
            fos2 = new FileOutputStream("test.gif_out2");
            b64os = new OutputStream(fos2, false);
            b64os.write(rebytes);
            b64os.close();
            ImageIcon iicon2 = new ImageIcon("test.gif_out2");
            JLabel jlabel2 = new JLabel("Read from test.gif_out2", iicon2, 0);
            jframe2 = new JFrame();
            jframe2.getContentPane().add(jlabel2);
            jframe2.pack();
            jframe2.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final byte[] encode3to4(byte[] threeBytes) {
        return Base64.encode3to4(threeBytes, 3);
    }

    private static final byte[] encode3to4(byte[] threeBytes, int numSigBytes) {
        byte[] dest = new byte[4];
        Base64.encode3to4(threeBytes, 0, numSigBytes, dest, 0);
        return dest;
    }

    private static final byte[] encode3to4(byte[] source, int srcOffset, int numSigBytes, byte[] destination, int destOffset) {
        int inBuff = (numSigBytes > 0 ? source[srcOffset] << 24 >>> 8 : 0) | (numSigBytes > 1 ? source[srcOffset + 1] << 24 >>> 16 : 0) | (numSigBytes > 2 ? source[srcOffset + 2] << 24 >>> 24 : 0);
        switch (numSigBytes) {
            case 3: {
                destination[destOffset] = ALPHABET[inBuff >>> 18];
                destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = ALPHABET[inBuff >>> 6 & 0x3F];
                destination[destOffset + 3] = ALPHABET[inBuff & 0x3F];
                return destination;
            }
            case 2: {
                destination[destOffset] = ALPHABET[inBuff >>> 18];
                destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = ALPHABET[inBuff >>> 6 & 0x3F];
                destination[destOffset + 3] = 61;
                return destination;
            }
            case 1: {
                destination[destOffset] = ALPHABET[inBuff >>> 18];
                destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = 61;
                destination[destOffset + 3] = 61;
                return destination;
            }
        }
        return destination;
    }

    public static String encodeObject(Serializable serializableObject) {
        return Base64.encodeObject(serializableObject, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encodeObject(Serializable serializableObject, boolean breakLines) {
        ByteArrayOutputStream baos = null;
        java.io.OutputStream b64os = null;
        ObjectOutputStream oos = null;
        try {
            baos = new ByteArrayOutputStream();
            b64os = new OutputStream(baos, true, breakLines);
            oos = new ObjectOutputStream(b64os);
            oos.writeObject(serializableObject);
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            try {
                oos.close();
            }
            catch (Exception exception) {}
            try {
                b64os.close();
            }
            catch (Exception exception) {}
            try {
                baos.close();
            }
            catch (Exception exception) {}
        }
        return new String(baos.toByteArray());
    }

    public static String encodeBytes(byte[] source) {
        return Base64.encodeBytes(source, true);
    }

    public static String encodeBytes(byte[] source, boolean breakLines) {
        return Base64.encodeBytes(source, 0, source.length, breakLines);
    }

    public static String encodeBytes(byte[] source, int off, int len) {
        return Base64.encodeBytes(source, off, len, true);
    }

    public static String encodeBytes(byte[] source, int off, int len, boolean breakLines) {
        int len43 = len * 4 / 3;
        byte[] outBuff = new byte[len43 + (len % 3 > 0 ? 4 : 0) + (breakLines ? len43 / 76 : 0)];
        int d = 0;
        int e = 0;
        int len2 = len - 2;
        int lineLength = 0;
        while (d < len2) {
            Base64.encode3to4(source, d + off, 3, outBuff, e);
            if (breakLines && (lineLength += 4) == 76) {
                outBuff[e + 4] = 10;
                ++e;
                lineLength = 0;
            }
            d += 3;
            e += 4;
        }
        if (d < len) {
            Base64.encode3to4(source, d + off, len - d, outBuff, e);
            e += 4;
        }
        return new String(outBuff, 0, e);
    }

    public static String encodeString(String s) {
        return Base64.encodeString(s, true);
    }

    public static String encodeString(String s, boolean breakLines) {
        return Base64.encodeBytes(s.getBytes(), breakLines);
    }

    public static byte[] readFile(String file, boolean encode) {
        return Base64.readFile(new File(file), encode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(File file, boolean encode) {
        byte[] data = new byte[100];
        byte[] returnValue = null;
        int nextIndex = 0;
        int b = -1;
        FilterInputStream bis = null;
        try {
            bis = new InputStream(new BufferedInputStream(new FileInputStream(file)), encode);
            while ((b = ((InputStream)bis).read()) >= 0) {
                if (nextIndex >= data.length) {
                    byte[] temp = new byte[data.length << 1];
                    System.arraycopy(data, 0, temp, 0, data.length);
                    data = temp;
                }
                data[nextIndex++] = (byte)b;
            }
            returnValue = new byte[nextIndex];
            System.arraycopy(data, 0, returnValue, 0, nextIndex);
        }
        catch (IOException e) {
            returnValue = null;
        }
        finally {
            try {
                bis.close();
            }
            catch (Exception exception) {}
        }
        return returnValue;
    }

    public static boolean writeFile(byte[] data, String file, boolean encode) {
        return Base64.writeFile(data, 0, data.length, new File(file), encode);
    }

    public static boolean writeFile(byte[] data, File file, boolean encode) {
        return Base64.writeFile(data, 0, data.length, file, encode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFile(byte[] data, int offset, int length, File file, boolean encode) {
        OutputStream bos = null;
        boolean success = false;
        try {
            bos = new OutputStream(new BufferedOutputStream(new FileOutputStream(file)), encode);
            bos.write(data, offset, length);
            success = true;
        }
        catch (IOException e) {
            success = false;
        }
        finally {
            try {
                bos.close();
            }
            catch (Exception exception) {}
        }
        return success;
    }

    public static String encodeFromFile(String rawfile) {
        byte[] ebytes = Base64.readFile(rawfile, true);
        return ebytes == null ? null : new String(ebytes);
    }

    public static byte[] decodeFromFile(String encfile) {
        return Base64.readFile(encfile, false);
    }

    public static boolean encodeToFile(byte[] rawdata, String file) {
        return Base64.writeFile(rawdata, file, true);
    }

    public static boolean decodeToFile(byte[] encdata, String file) {
        return Base64.writeFile(encdata, file, false);
    }

    private static byte[] decode4to3(byte[] fourBytes) {
        byte[] outBuff1 = new byte[3];
        int count = Base64.decode4to3(fourBytes, 0, outBuff1, 0);
        byte[] outBuff2 = new byte[count];
        for (int i = 0; i < count; ++i) {
            outBuff2[i] = outBuff1[i];
        }
        return outBuff2;
    }

    private static int decode4to3(byte[] source, int srcOffset, byte[] destination, int destOffset) {
        if (source[srcOffset + 2] == 61) {
            int outBuff = (DECODABET[source[srcOffset]] & 0xFF) << 18 | (DECODABET[source[srcOffset + 1]] & 0xFF) << 12;
            destination[destOffset] = (byte)(outBuff >>> 16);
            return 1;
        }
        if (source[srcOffset + 3] == 61) {
            int outBuff = (DECODABET[source[srcOffset]] & 0xFF) << 18 | (DECODABET[source[srcOffset + 1]] & 0xFF) << 12 | (DECODABET[source[srcOffset + 2]] & 0xFF) << 6;
            destination[destOffset] = (byte)(outBuff >>> 16);
            destination[destOffset + 1] = (byte)(outBuff >>> 8);
            return 2;
        }
        try {
            int outBuff = (DECODABET[source[srcOffset]] & 0xFF) << 18 | (DECODABET[source[srcOffset + 1]] & 0xFF) << 12 | (DECODABET[source[srcOffset + 2]] & 0xFF) << 6 | DECODABET[source[srcOffset + 3]] & 0xFF;
            destination[destOffset] = (byte)(outBuff >> 16);
            destination[destOffset + 1] = (byte)(outBuff >> 8);
            destination[destOffset + 2] = (byte)outBuff;
            return 3;
        }
        catch (Exception e) {
            System.out.println("" + source[srcOffset] + ": " + DECODABET[source[srcOffset]]);
            System.out.println("" + source[srcOffset + 1] + ": " + DECODABET[source[srcOffset + 1]]);
            System.out.println("" + source[srcOffset + 2] + ": " + DECODABET[source[srcOffset + 2]]);
            System.out.println("" + source[srcOffset + 3] + ": " + DECODABET[source[srcOffset + 3]]);
            return -1;
        }
    }

    public static byte[] decode(String s) {
        byte[] bytes = s.getBytes();
        return Base64.decode(bytes, 0, bytes.length);
    }

    public static String decodeToString(String s) {
        return new String(Base64.decode(s));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object decodeToObject(String encodedObject) {
        byte[] objBytes = Base64.decode(encodedObject);
        ByteArrayInputStream bais = null;
        ObjectInputStream ois = null;
        try {
            bais = new ByteArrayInputStream(objBytes);
            ois = new ObjectInputStream(bais);
            Object object = ois.readObject();
            return object;
        }
        catch (IOException e) {
            e.printStackTrace();
            Object var5_9 = null;
            return var5_9;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            Object var5_10 = null;
            return var5_10;
        }
        finally {
            try {
                bais.close();
            }
            catch (Exception exception) {}
            try {
                ois.close();
            }
            catch (Exception exception) {}
        }
    }

    public static byte[] decode(byte[] source, int off, int len) {
        int len34 = len * 3 / 4;
        byte[] outBuff = new byte[len34];
        int outBuffPosn = 0;
        byte[] b4 = new byte[4];
        int b4Posn = 0;
        int i = 0;
        byte sbiCrop = 0;
        byte sbiDecode = 0;
        for (i = off; i < off + len; ++i) {
            sbiCrop = (byte)(source[i] & 0x7F);
            sbiDecode = DECODABET[sbiCrop];
            if (sbiDecode >= -5) {
                if (sbiDecode < -1) continue;
                b4[b4Posn++] = sbiCrop;
                if (b4Posn <= 3) continue;
                outBuffPosn += Base64.decode4to3(b4, 0, outBuff, outBuffPosn);
                b4Posn = 0;
                if (sbiCrop != 61) continue;
                break;
            }
            System.err.println("Bad Base64 input character at " + i + ": " + source[i] + "(decimal)");
            return null;
        }
        byte[] out = new byte[outBuffPosn];
        System.arraycopy(outBuff, 0, out, 0, outBuffPosn);
        return out;
    }

    public static int decode(byte[] source, int off, int len, byte[] outBuff) {
        int outBuffPosn = 0;
        byte[] b4 = new byte[4];
        int b4Posn = 0;
        int i = 0;
        byte sbiCrop = 0;
        byte sbiDecode = 0;
        for (i = off; i < off + len; ++i) {
            sbiCrop = (byte)(source[i] & 0x7F);
            sbiDecode = DECODABET[sbiCrop];
            if (sbiDecode >= -5) {
                if (sbiDecode < -1) continue;
                b4[b4Posn++] = sbiCrop;
                if (b4Posn <= 3) continue;
                outBuffPosn += Base64.decode4to3(b4, 0, outBuff, outBuffPosn);
                b4Posn = 0;
                if (sbiCrop != 61) continue;
                break;
            }
            System.err.println("Bad Base64 input character at " + i + ": " + source[i] + "(decimal)");
            return -1;
        }
        return outBuffPosn;
    }

    public static class OutputStream
    extends FilterOutputStream {
        private boolean encode;
        private int position;
        private byte[] buffer;
        private int bufferLength;
        private int lineLength;
        private boolean breakLines;

        public OutputStream(java.io.OutputStream out) {
            this(out, true);
        }

        public OutputStream(java.io.OutputStream out, boolean encode) {
            this(out, encode, true);
        }

        public OutputStream(java.io.OutputStream out, boolean encode, boolean breakLines) {
            super(out);
            this.breakLines = breakLines;
            this.encode = encode;
            this.bufferLength = encode ? 3 : 4;
            this.buffer = new byte[this.bufferLength];
            this.position = 0;
            this.lineLength = 0;
        }

        @Override
        public void write(int theByte) throws IOException {
            if (this.encode) {
                this.buffer[this.position++] = (byte)theByte;
                if (this.position >= this.bufferLength) {
                    this.out.write(Base64.encode3to4(this.buffer, this.bufferLength));
                    this.lineLength += 4;
                    if (this.breakLines && this.lineLength >= 76) {
                        this.out.write(10);
                        this.lineLength = 0;
                    }
                    this.position = 0;
                }
            } else if (DECODABET[theByte & 0x7F] > -5) {
                this.buffer[this.position++] = (byte)theByte;
                if (this.position >= this.bufferLength) {
                    this.out.write(Base64.decode4to3(this.buffer));
                    this.position = 0;
                }
            } else if (DECODABET[theByte & 0x7F] != -5) {
                throw new IOException("Invalid character in Base64 data.");
            }
        }

        @Override
        public void write(byte[] theBytes, int off, int len) throws IOException {
            for (int i = 0; i < len; ++i) {
                this.write(theBytes[off + i]);
            }
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            if (this.position > 0) {
                if (this.encode) {
                    this.out.write(Base64.encode3to4(this.buffer, this.position));
                    this.position = 0;
                } else {
                    throw new IOException("Base64 input not properly padded.");
                }
            }
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.out.close();
            this.buffer = null;
            this.out = null;
        }
    }

    public static class InputStream
    extends FilterInputStream {
        private boolean encode;
        private int position;
        private byte[] buffer;
        private int bufferLength;
        private int numSigBytes;
        private int lineLength;
        private boolean breakLines;

        public InputStream(java.io.InputStream in) {
            this(in, false);
        }

        public InputStream(java.io.InputStream in, boolean encode) {
            this(in, encode, true);
        }

        public InputStream(java.io.InputStream in, boolean encode, boolean breakLines) {
            super(in);
            this.breakLines = breakLines;
            this.encode = encode;
            this.bufferLength = encode ? 4 : 3;
            this.buffer = new byte[this.bufferLength];
            this.position = -1;
            this.lineLength = 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int read() throws IOException {
            if (this.position < 0) {
                if (this.encode) {
                    byte[] b3 = new byte[3];
                    int numBinaryBytes = 0;
                    for (int i = 0; i < 3; ++i) {
                        try {
                            int b = this.in.read();
                            if (b < 0) continue;
                            b3[i] = (byte)b;
                            ++numBinaryBytes;
                            continue;
                        }
                        catch (IOException e) {
                            if (i != 0) continue;
                            throw e;
                        }
                    }
                    if (numBinaryBytes <= 0) return -1;
                    Base64.encode3to4(b3, 0, numBinaryBytes, this.buffer, 0);
                    this.position = 0;
                    this.numSigBytes = 4;
                } else {
                    byte[] b4 = new byte[4];
                    int i = 0;
                    for (i = 0; i < 4; ++i) {
                        int b = 0;
                        while ((b = this.in.read()) >= 0 && DECODABET[b & 0x7F] <= -5) {
                        }
                        if (b < 0) break;
                        b4[i] = (byte)b;
                    }
                    if (i == 4) {
                        this.numSigBytes = Base64.decode4to3(b4, 0, this.buffer, 0);
                        this.position = 0;
                    } else {
                        if (i != 0) throw new IOException("Improperly padded Base64 input.");
                        return -1;
                    }
                }
            }
            if (this.position < 0) throw new IOException("Error in Base64 code reading stream.");
            if (this.position >= this.numSigBytes) {
                return -1;
            }
            if (this.encode && this.breakLines && this.lineLength >= 76) {
                this.lineLength = 0;
                return 10;
            }
            ++this.lineLength;
            byte b = this.buffer[this.position++];
            if (this.position < this.bufferLength) return b & 0xFF;
            this.position = -1;
            return b & 0xFF;
        }

        @Override
        public int read(byte[] dest, int off, int len) throws IOException {
            int i;
            for (i = 0; i < len; ++i) {
                int b = this.read();
                if (b < 0) {
                    if (i != 0) break;
                    return -1;
                }
                dest[off + i] = (byte)b;
            }
            return i;
        }
    }
}

