/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.jrap.stax;

import java.io.FileInputStream;
import java.util.ArrayList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.systemsbiology.jrap.stax.MSOperator;
import org.systemsbiology.jrap.stax.MZXMLFileInfo;
import org.systemsbiology.jrap.stax.ParentFile;
import org.systemsbiology.jrap.stax.SoftwareInfo;

public class FileHeaderParser {
    String inputMZXMLfile;
    MZXMLFileInfo info;
    ArrayList<ParentFile> parentFiles = new ArrayList();
    ArrayList<SoftwareInfo> dataProcessingSoftware = new ArrayList();
    boolean isXML = false;
    boolean isML = false;

    FileHeaderParser(String inputMZXMLfile) {
        this.inputMZXMLfile = inputMZXMLfile;
        this.info = new MZXMLFileInfo();
        if (inputMZXMLfile.indexOf("mzXML") != -1) {
            this.isXML = true;
        } else {
            this.isML = true;
        }
    }

    public MZXMLFileInfo getInfo() {
        return this.info;
    }

    public void parseFileHeader() {
        if (this.isXML) {
            this.parseXMLFileHeader();
        } else {
            this.parseMLFileHeader();
        }
    }

    public void parseFileHeader(XMLStreamReader xmlSR) throws XMLStreamException {
        if (this.isXML) {
            this.parseXMLFileHeader(xmlSR);
        } else {
            this.parseMLFileHeader(xmlSR);
        }
    }

    private void parseXMLFileHeader() {
        block2: {
            try {
                XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                XMLStreamReader xmlSR = inputFactory.createXMLStreamReader(new FileInputStream(this.inputMZXMLfile));
                this.parseXMLFileHeader(xmlSR);
                xmlSR.close();
            }
            catch (Exception e) {
                if (e.getMessage().equals("HeaderEndFoundException")) break block2;
                e.printStackTrace(System.err);
            }
        }
    }

    private void parseXMLFileHeader(XMLStreamReader xmlSR) throws XMLStreamException {
        String elementName = null;
        int event = -1;
        boolean isInstrument = false;
        boolean isDataProcess = false;
        while (xmlSR.hasNext()) {
            event = xmlSR.next();
            if (event == 1) {
                elementName = xmlSR.getLocalName();
                if (elementName.equals("parentFile")) {
                    this.parentFiles.add(new ParentFile(xmlSR.getAttributeValue(0), xmlSR.getAttributeValue(1), xmlSR.getAttributeValue(2)));
                }
                if (elementName.equals("msInstrument")) {
                    isInstrument = true;
                }
                if (elementName.equals("msManufacturer")) {
                    this.info.instrumentInfo.manufacturer = xmlSR.getAttributeValue(1);
                }
                if (elementName.equals("msModel")) {
                    this.info.instrumentInfo.model = xmlSR.getAttributeValue(null, "value");
                }
                if (elementName.equals("msIonisation")) {
                    this.info.instrumentInfo.ionization = xmlSR.getAttributeValue(null, "value");
                }
                if (elementName.equals("msMassAnalyzer")) {
                    this.info.instrumentInfo.massAnalyzer = xmlSR.getAttributeValue(null, "value");
                }
                if (elementName.equals("msDetector")) {
                    this.info.instrumentInfo.detector = xmlSR.getAttributeValue(null, "value");
                }
                if (elementName.equals("operator")) {
                    MSOperator operator = new MSOperator();
                    operator.firstName = xmlSR.getAttributeValue(null, "first");
                    operator.lastName = xmlSR.getAttributeValue(null, "last");
                    operator.phoneNumber = xmlSR.getAttributeValue(null, "phone");
                    operator.email = xmlSR.getAttributeValue(null, "email");
                    operator.URI = xmlSR.getAttributeValue(null, "URI");
                    this.info.instrumentInfo.operator = operator;
                }
                if (elementName.equals("software")) {
                    if (isInstrument) {
                        this.info.instrumentInfo.softwareInfo = this.parseSoftware(xmlSR);
                    } else if (isDataProcess) {
                        this.dataProcessingSoftware.add(this.parseSoftware(xmlSR));
                    }
                }
                if (elementName.equals("dataProcessing")) {
                    isDataProcess = true;
                    String value = xmlSR.getAttributeValue(null, "intensityCutoff");
                    if (value != null) {
                        this.info.dataProcessing.intensityCutoff = Double.parseDouble(value);
                    }
                    if ((value = xmlSR.getAttributeValue(null, "centroided")) != null) {
                        this.info.dataProcessing.centroided = Integer.parseInt(value);
                    }
                    if ((value = xmlSR.getAttributeValue(null, "deisotoped")) != null) {
                        this.info.dataProcessing.deisotoped = Integer.parseInt(value);
                    }
                    if ((value = xmlSR.getAttributeValue(null, "chargeDeconvoluted")) != null) {
                        this.info.dataProcessing.chargeDeconvoluted = Integer.parseInt(value);
                    }
                    if ((value = xmlSR.getAttributeValue(null, "spotIntegration")) != null) {
                        this.info.dataProcessing.spotIntegration = Integer.parseInt(value);
                    }
                }
            }
            if (event != 2) continue;
            elementName = xmlSR.getLocalName();
            if (elementName.equals("msInstrument")) {
                isInstrument = false;
            }
            if (!elementName.equals("dataProcessing")) continue;
            isDataProcess = false;
            this.info.parentFiles = this.parentFiles;
            this.info.dataProcessing.softwareUsed = this.dataProcessingSoftware;
            throw new XMLStreamException("HeaderEndFoundException");
        }
    }

    private SoftwareInfo parseSoftware(XMLStreamReader xmlSR) {
        SoftwareInfo sInfo = new SoftwareInfo("", "", "");
        try {
            if (this.isXML) {
                sInfo.setType(xmlSR.getAttributeValue(null, "type"));
            } else {
                sInfo.setType(xmlSR.getAttributeValue(null, "accession"));
            }
            sInfo.setName(xmlSR.getAttributeValue(null, "name"));
            sInfo.setVersion(xmlSR.getAttributeValue(null, "version"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sInfo;
    }

    private void parseMLFileHeader() {
        block2: {
            try {
                XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                XMLStreamReader xmlSR = inputFactory.createXMLStreamReader(new FileInputStream(this.inputMZXMLfile));
                this.parseMLFileHeader(xmlSR);
                xmlSR.close();
            }
            catch (Exception e) {
                if (e.getMessage().equals("HeaderEndFoundException")) break block2;
                e.printStackTrace(System.err);
            }
        }
    }

    private void parseMLFileHeader(XMLStreamReader xmlSR) throws XMLStreamException {
        String elementName = null;
        int event = -1;
        boolean isInstrument = false;
        boolean isDataProcess = false;
        boolean inSourceFile = false;
        boolean inSource = false;
        boolean inAnalyzer = false;
        boolean inDetector = false;
        String fileName = null;
        String fileLocation = null;
        String accession = null;
        String fileType = null;
        String sha1 = null;
        while (xmlSR.hasNext()) {
            event = xmlSR.next();
            if (event == 1) {
                elementName = xmlSR.getLocalName();
                if (elementName.equals("sourceFile")) {
                    fileName = xmlSR.getAttributeValue(null, "name");
                    fileLocation = xmlSR.getAttributeValue(null, "location");
                    inSourceFile = true;
                }
                if (elementName.equals("cvParam")) {
                    accession = xmlSR.getAttributeValue(null, "accession");
                    if (inSourceFile) {
                        if (accession.equals("MS:1000563")) {
                            fileType = xmlSR.getAttributeValue(null, "name");
                        }
                        if (accession.equals("MS:1000569")) {
                            sha1 = xmlSR.getAttributeValue(null, "value");
                        }
                    }
                    if (isInstrument) {
                        if (accession.equals("MS:1000554")) {
                            this.info.instrumentInfo.model = xmlSR.getAttributeValue(null, "name");
                        }
                        if (accession.equals("MS:1000529")) {
                            this.info.instrumentInfo.manufacturer = xmlSR.getAttributeValue(null, "name") + " " + xmlSR.getAttributeValue(null, "value");
                        }
                    }
                    if (inSource) {
                        this.info.instrumentInfo.ionization = xmlSR.getAttributeValue(null, "name");
                    }
                    if (inAnalyzer) {
                        this.info.instrumentInfo.massAnalyzer = xmlSR.getAttributeValue(null, "name");
                    }
                    if (inDetector) {
                        this.info.instrumentInfo.detector = xmlSR.getAttributeValue(null, "name");
                    }
                    if (isDataProcess) {
                        String name = xmlSR.getAttributeValue(null, "name");
                        String value = xmlSR.getAttributeValue(null, "value");
                        if (name.indexOf("deisotoping") != -1) {
                            this.info.dataProcessing.deisotoped = value.equals("true") ? 1 : 0;
                        }
                        if (name.indexOf("charge") != -1) {
                            this.info.dataProcessing.chargeDeconvoluted = value.equals("true") ? 1 : 0;
                        }
                        if (name.indexOf("peak") != -1) {
                            this.info.dataProcessing.peakPicked = value.equals("true") ? 1 : 0;
                        }
                        if (name.indexOf("smoothing") != -1) {
                            this.info.dataProcessing.smoothed = value.equals("true") ? 1 : 0;
                        }
                        if (name.indexOf("baseline") != -1) {
                            this.info.dataProcessing.baseLineReduced = value.equals("true") ? 1 : 0;
                        }
                        if (name.indexOf("low intensity") != -1) {
                            this.info.dataProcessing.lowIntensityDataRemoved = value.equals("true") ? 1 : 0;
                        }
                    }
                }
                if (elementName.equals("referenceableParamGroup") && xmlSR.getAttributeValue(null, "id").indexOf("Instrument") != -1) {
                    isInstrument = true;
                }
                if (elementName.equals("source")) {
                    inSource = true;
                }
                if (elementName.equals("analyzer")) {
                    inAnalyzer = true;
                }
                if (elementName.equals("detector")) {
                    inDetector = true;
                }
                if (elementName.equals("softwareParam")) {
                    this.dataProcessingSoftware.add(this.parseSoftware(xmlSR));
                }
                if (elementName.equals("dataProcessing")) {
                    isDataProcess = true;
                }
            }
            if (event != 2) continue;
            elementName = xmlSR.getLocalName();
            if (elementName.equals("sourceFile")) {
                this.parentFiles.add(new ParentFile(fileLocation + "/" + fileName, fileType, sha1));
                inSourceFile = false;
            }
            if (elementName.equals("referenceableParamGroup")) {
                isInstrument = false;
            }
            if (elementName.equals("source")) {
                inSource = false;
            }
            if (elementName.equals("analyzer")) {
                inAnalyzer = false;
            }
            if (elementName.equals("detector")) {
                inDetector = false;
            }
            if (!elementName.equals("dataProcessing")) continue;
            isDataProcess = false;
            this.info.parentFiles = this.parentFiles;
            this.info.dataProcessing.softwareUsed = this.dataProcessingSoftware;
            throw new XMLStreamException("HeaderEndFoundException");
        }
    }
}

