/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.tools.xxindex;

import info.monitorenter.cpdetector.io.ASCIIDetector;
import info.monitorenter.cpdetector.io.CodepageDetectorProxy;
import info.monitorenter.cpdetector.io.JChardetFacade;
import info.monitorenter.cpdetector.io.ParsingDetector;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import psidev.psi.tools.xxindex.XmlElementExtractor;
import psidev.psi.tools.xxindex.index.IndexElement;

@Deprecated
public class StandardXmlElementExtractor
implements XmlElementExtractor {
    Logger log = LoggerFactory.getLogger(StandardXmlElementExtractor.class);
    private boolean compareWithDetect = false;
    private boolean preferDetect = false;
    private Charset encoding;

    public StandardXmlElementExtractor() {
        this.encoding = null;
    }

    public StandardXmlElementExtractor(Charset encoding) {
        this.encoding = encoding;
    }

    public boolean isCompareWithDetect() {
        return this.compareWithDetect;
    }

    public void setCompareWithDetect(boolean compareWithDetect) {
        this.compareWithDetect = compareWithDetect;
    }

    public boolean isPreferDetect() {
        return this.preferDetect;
    }

    public void setPreferDetect(boolean preferDetect) {
        this.preferDetect = preferDetect;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    @Override
    public int setEncoding(String encoding) {
        int result;
        try {
            this.encoding = Charset.forName(encoding);
            result = 0;
        }
        catch (IllegalCharsetNameException icne) {
            this.log.error("Illegal encoding: " + encoding, icne);
            result = -1;
        }
        catch (UnsupportedCharsetException ucne) {
            this.log.error("Unsupported encoding: " + encoding, ucne);
            result = -2;
        }
        return result;
    }

    public String readString(IndexElement br, File file) throws IOException {
        return this.readString(br.getStart(), br.getStop(), file);
    }

    @Override
    public String readString(long from, long to, File file) throws IOException {
        byte[] bytes = this.readBytes(from, to, file);
        byte[] newBytes = this.removeZeroBytes(bytes);
        return this.bytes2String(newBytes);
    }

    @Override
    public byte[] readBytes(long from, long to, File file) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        raf.seek(from);
        Long length = to - from;
        byte[] bytes = new byte[length.intValue()];
        raf.read(bytes, 0, length.intValue());
        raf.close();
        return bytes;
    }

    public byte[] removeZeroBytes(byte[] bytes) {
        byte[] result;
        byte[] temp = new byte[bytes.length];
        int count = 0;
        for (byte aByte : bytes) {
            if (aByte == 0) continue;
            temp[count] = aByte;
            ++count;
        }
        if (count != bytes.length) {
            result = new byte[count];
            System.arraycopy(temp, 0, result, 0, count);
        } else {
            result = temp;
        }
        return result;
    }

    public String bytes2String(byte[] bytes) {
        Set<String> aliases;
        Charset detectedEnc = null;
        if (this.compareWithDetect && (detectedEnc = this.detectEncoding(bytes)).compareTo(this.encoding) != 0 && !(aliases = detectedEnc.aliases()).contains(this.encoding.name()) && this.log.isWarnEnabled()) {
            this.log.warn("WARNING: specified encoding is not the same as the detected one. Specified: " + this.encoding.name() + " detected: " + detectedEnc.name());
        }
        if (this.preferDetect) {
            this.encoding = detectedEnc != null ? detectedEnc : this.detectEncoding(bytes);
            if (this.log.isDebugEnabled()) {
                this.log.info("Using detected encoding: " + this.encoding.name());
            }
        }
        String result = null;
        if (this.encoding == null) {
            if (this.log.isDebugEnabled()) {
                this.log.info("Using system default for encoding.");
            }
            result = new String(bytes);
        } else {
            try {
                result = new String(bytes, this.encoding.name());
            }
            catch (UnsupportedEncodingException e) {
                this.log.error("Specified encoding '" + this.encoding.name() + "' is not supported", e);
            }
        }
        return result;
    }

    public Charset detectEncoding(byte[] bytes) {
        Charset charset;
        CodepageDetectorProxy detector = CodepageDetectorProxy.getInstance();
        detector.add(new ParsingDetector(false));
        detector.add(JChardetFacade.getInstance());
        detector.add(ASCIIDetector.getInstance());
        try {
            charset = detector.detectCodepage(new ByteArrayInputStream(bytes), bytes.length);
        }
        catch (IOException e) {
            this.log.error("IOException trying to detect codepage from byte array, setting charset to default", e);
            charset = Charset.defaultCharset();
        }
        return charset;
    }

    protected String detectFileEncoding(String filename) throws IOException {
        URL url = StandardXmlElementExtractor.class.getResource(filename);
        return this.detectFileEncoding(url);
    }

    @Override
    public String detectFileEncoding(URL fileLocation) throws IOException {
        CodepageDetectorProxy detector = CodepageDetectorProxy.getInstance();
        detector.add(new ParsingDetector(false));
        detector.add(JChardetFacade.getInstance());
        detector.add(ASCIIDetector.getInstance());
        Charset charset = detector.detectCodepage(fileLocation);
        String charsetName = null;
        if (charset != null) {
            charsetName = charset.name();
        }
        return charsetName;
    }

    @Override
    public String detectFileEncoding(URL fileLocation, int length) throws IOException {
        InputStream in = fileLocation.openStream();
        CodepageDetectorProxy detector = CodepageDetectorProxy.getInstance();
        detector.add(new ParsingDetector(false));
        detector.add(JChardetFacade.getInstance());
        detector.add(ASCIIDetector.getInstance());
        Charset charset = detector.detectCodepage(in, length);
        String charsetName = null;
        if (charset != null) {
            charsetName = charset.name();
        }
        return charsetName;
    }
}

