/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzidml.model.utils;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class FacadeList<T>
extends AbstractCollection<T>
implements List<T> {
    private List originalList;
    private Class<T> clazz;

    public FacadeList(List originalList, Class<T> clazz) {
        if (originalList == null || clazz == null) {
            throw new IllegalArgumentException("Error: Neither original input list nor sublist class can be NULL");
        }
        this.originalList = originalList;
        this.clazz = clazz;
    }

    private FacadeList() {
    }

    @Override
    public boolean add(T t) {
        this.checkArgument(t);
        return this.originalList.add(t);
    }

    @Override
    public T remove(int index) {
        T elementAtIndex = this.getAtIndex(index);
        this.originalList.remove(elementAtIndex);
        return elementAtIndex;
    }

    @Override
    public T get(int index) {
        return this.getAtIndex(index);
    }

    @Override
    public T set(int index, T element) {
        this.checkArgument(element);
        this.checkIndex(index);
        return this.setAtIndex(index, element);
    }

    @Override
    public int size() {
        int cnt = 0;
        for (Object anOriginalList : this.originalList) {
            if (!this.clazz.isInstance(anOriginalList)) continue;
            ++cnt;
        }
        return cnt;
    }

    @Override
    public boolean isEmpty() {
        boolean em = false;
        for (Object anOriginalList : this.originalList) {
            Object o = anOriginalList;
            if (!this.clazz.isInstance(o)) continue;
            em = true;
            break;
        }
        return em;
    }

    @Override
    public boolean contains(Object o) {
        this.checkArgument(o);
        return this.originalList.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return new SublistIterator(this.originalList);
    }

    @Override
    public int indexOf(Object o) {
        this.checkArgument(o);
        int cnt = 0;
        for (Object anOriginalList : this.originalList) {
            if (!this.clazz.isInstance(anOriginalList)) continue;
            if (o.equals(anOriginalList)) {
                return cnt;
            }
            ++cnt;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        this.checkArgument(o);
        int pointer = -1;
        int size = this.size();
        if (size > 0) {
            for (int i = size - 1; i >= 0; --i) {
                if (!o.equals(this.get(i))) continue;
                pointer = i;
                break;
            }
        }
        return pointer;
    }

    @Override
    public ListIterator<T> listIterator() {
        return new SubListListIterator(this.originalList);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new SubListListIterator(this.originalList, index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        this.checkIndex(fromIndex);
        this.checkIndex(toIndex - 1);
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("The start index needs to be greater than the end index: start index: " + fromIndex + " end index: " + toIndex);
        }
        if (toIndex > this.size()) {
            throw new IndexOutOfBoundsException("The end index should not be greater than the size of the list: " + toIndex);
        }
        ArrayList<T> result = new ArrayList<T>();
        int diff = toIndex - fromIndex;
        ListIterator<T> listIter = this.listIterator(fromIndex);
        for (int cnt = 0; listIter.hasNext() && cnt < diff; ++cnt) {
            result.add(listIter.next());
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Object[] toArray() {
        Object[] arr = new Object[this.size()];
        int index = 0;
        for (T element : this) {
            arr[index] = element;
            ++index;
        }
        return arr;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (a.length < size) {
            return Arrays.copyOf(this.toArray(), size, a.getClass());
        }
        System.arraycopy(this.toArray(), 0, a, 0, size);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public void add(int index, T element) {
        this.checkArgument(element);
        this.checkIndex(index);
        this.addAtIndex(index, element);
    }

    @Override
    public boolean remove(Object o) {
        this.checkArgument(o);
        return this.originalList.remove(o);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        this.checkIndex(index);
        this.checkArgumentsInCollection(c);
        int originalIndex = this.getOriginalIndex(index);
        return this.originalList.addAll(originalIndex, c);
    }

    private void checkArgumentsInCollection(Collection<?> c) {
        if (c == null) {
            throw new NullPointerException("Input collection can not be NULL");
        }
        for (Object t : c) {
            if (t == null) {
                throw new NullPointerException("Input collection has one or more NULL elements");
            }
            if (this.clazz.isInstance(t)) continue;
            throw new ClassCastException("Input collection has mismatching element types, expected: " + this.clazz.getName() + " found: " + t.getClass().getName());
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.checkArgumentsInCollection(c);
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.checkArgumentsInCollection(c);
        return super.retainAll(c);
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        for (T element : this) {
            buffer.append("[");
            buffer.append(element.toString());
            buffer.append("], ");
        }
        if (this.size() > 0) {
            buffer.replace(buffer.length() - 2, buffer.length(), "");
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (T obj : this) {
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object comparedToListObject) {
        if (!(comparedToListObject instanceof FacadeList)) {
            return false;
        }
        FacadeList comparedToList = (FacadeList)comparedToListObject;
        if (comparedToList.size() != this.size()) {
            return false;
        }
        Iterator<T> thisIt = this.iterator();
        Iterator<T> comparedToListIt = comparedToList.iterator();
        while (thisIt.hasNext()) {
            T comparedToT;
            T thisT = thisIt.next();
            if (thisT.equals(comparedToT = comparedToListIt.next())) continue;
            return false;
        }
        return true;
    }

    private void checkArgument(Object o) {
        if (o == null) {
            throw new NullPointerException("Argument cannot be a null value");
        }
        if (!this.clazz.isInstance(o)) {
            throw new ClassCastException("Argument must be an instance of " + this.clazz.getName() + ". Received instance of " + o.getClass().getName());
        }
    }

    private T getAtIndex(int index) {
        this.checkIndex(index);
        int cnt = 0;
        for (Object o : this.originalList) {
            if (!this.clazz.isInstance(o)) continue;
            if (index == cnt) {
                return (T)o;
            }
            ++cnt;
        }
        throw new IndexOutOfBoundsException("Input index for sublist should be greater than or equal than zero, and less than the size of the list: " + index);
    }

    private T setAtIndex(int index, T newElement) {
        boolean cnt = false;
        int originalListIndex = this.getOriginalIndex(index);
        return this.originalList.set(originalListIndex, newElement);
    }

    private void addAtIndex(int index, T newElement) {
        int originalListIndex = this.getOriginalIndex(index);
        this.originalList.add(originalListIndex, newElement);
    }

    private int getOriginalIndex(int index) {
        int cnt = 0;
        int originalListIndex = 0;
        for (Object element : this.originalList) {
            if (this.clazz.isInstance(element)) {
                if (index == cnt) break;
                ++cnt;
            }
            ++originalListIndex;
        }
        return originalListIndex;
    }

    private void checkIndex(int index) {
        this.checkIndex(index, null);
    }

    private void checkIndex(int index, String errMsg) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException(errMsg == null ? "Input sublist index does not exist: " + index : errMsg);
        }
    }

    private class SubListListIterator
    implements ListIterator<T> {
        private List superList;
        private int currPosition = -1;
        private int startSuperPosition = -1;
        private int startIndex = -1;
        private boolean nextOrPreviousHasBeenCalled = false;
        private boolean addOrRemoveCalled;

        private SubListListIterator(List superList) {
            this(superList, 0);
        }

        public SubListListIterator(List superList, int startIndex) {
            if (superList == null) {
                throw new NullPointerException("Input super list cannot be null");
            }
            if (startIndex < 0 || superList.size() > 0 && startIndex >= superList.size() || superList.size() == 0 && startIndex > 0) {
                throw new IndexOutOfBoundsException("Start index of the iterator cannot be less than zero or greater-equal than the size of the list");
            }
            this.superList = superList;
            this.startIndex = startIndex;
            this.initNextPosition();
        }

        private void initNextPosition() {
            if (this.startIndex > 0) {
                int matchCnt = 0;
                int cnt = 0;
                for (Object o : this.superList) {
                    if (FacadeList.this.clazz.isInstance(o)) {
                        if (matchCnt == this.startIndex) {
                            this.startSuperPosition = cnt;
                            break;
                        }
                        ++matchCnt;
                    }
                    ++cnt;
                }
                if (this.startSuperPosition == -1) {
                    throw new IndexOutOfBoundsException("Index out of the bound of the sublist: " + this.startIndex);
                }
                this.currPosition = this.startSuperPosition - 1;
            } else {
                this.startSuperPosition = 0;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.currPosition + 1 <= this.superList.size() - 1) {
                for (int i = this.currPosition + 1; i < this.superList.size(); ++i) {
                    if (!FacadeList.this.clazz.isInstance(this.superList.get(i))) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public T next() {
            this.addOrRemoveCalled = false;
            if (this.currPosition + 1 <= this.superList.size() - 1) {
                this.nextOrPreviousHasBeenCalled = true;
                for (int i = ++this.currPosition; i < this.superList.size(); ++i) {
                    if (FacadeList.this.clazz.isInstance(this.superList.get(i))) {
                        return this.superList.get(i);
                    }
                    ++this.currPosition;
                }
            }
            throw new NoSuchElementException("Sublist does not contain any more elements.");
        }

        @Override
        public boolean hasPrevious() {
            if (this.currPosition >= 0) {
                this.nextOrPreviousHasBeenCalled = true;
                for (int i = this.currPosition; i >= this.startSuperPosition; --i) {
                    if (!FacadeList.this.clazz.isInstance(this.superList.get(i))) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public T previous() {
            if (this.currPosition >= 0) {
                for (int i = this.currPosition; i >= this.startSuperPosition; --i) {
                    --this.currPosition;
                    if (!FacadeList.this.clazz.isInstance(this.superList.get(i))) continue;
                    return this.superList.get(i);
                }
            }
            this.addOrRemoveCalled = false;
            throw new NoSuchElementException("Failed to find a previous element");
        }

        @Override
        public int nextIndex() {
            int cnt = 0;
            int nextIndex = -1;
            for (int i = this.startSuperPosition; i < this.superList.size(); ++i) {
                if (!FacadeList.this.clazz.isInstance(this.superList.get(i))) continue;
                if (nextIndex == -1 && i >= this.currPosition + 1) {
                    nextIndex = cnt;
                }
                ++cnt;
            }
            return nextIndex == -1 ? cnt : nextIndex;
        }

        @Override
        public int previousIndex() {
            int previousIndex = -1;
            for (int i = this.currPosition; i >= this.startSuperPosition; --i) {
                if (!FacadeList.this.clazz.isInstance(this.superList.get(i))) continue;
                ++previousIndex;
            }
            return previousIndex;
        }

        @Override
        public void remove() {
            if (!this.nextOrPreviousHasBeenCalled) {
                throw new IllegalStateException("Next method for sublist iterator must be called at least once before remove can be called.");
            }
            this.nextOrPreviousHasBeenCalled = false;
            this.addOrRemoveCalled = true;
            if (this.currPosition >= this.startSuperPosition) {
                this.superList.remove(this.currPosition);
                --this.currPosition;
            } else {
                this.superList.remove(this.startSuperPosition);
            }
        }

        @Override
        public void set(T t) {
            if (this.nextOrPreviousHasBeenCalled && !this.addOrRemoveCalled) {
                if (this.currPosition >= this.startSuperPosition) {
                    this.superList.set(this.currPosition, t);
                } else {
                    this.superList.set(this.startSuperPosition, t);
                }
            } else {
                throw new IllegalStateException();
            }
        }

        @Override
        public void add(T t) {
            this.addOrRemoveCalled = true;
            this.superList.add(this.currPosition + 1, t);
        }
    }

    private class SublistIterator
    implements Iterator<T> {
        private List superList;
        private int currPosition = -1;
        private boolean nextHasBeenCalled = false;

        public SublistIterator(List superList) {
            this.superList = superList;
        }

        @Override
        public boolean hasNext() {
            if (this.currPosition + 1 <= this.superList.size() - 1) {
                for (int i = this.currPosition + 1; i < this.superList.size(); ++i) {
                    if (!FacadeList.this.clazz.isInstance(this.superList.get(i))) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public T next() {
            if (this.currPosition + 1 <= this.superList.size() - 1) {
                this.nextHasBeenCalled = true;
                for (int i = ++this.currPosition; i < this.superList.size(); ++i) {
                    if (FacadeList.this.clazz.isInstance(this.superList.get(i))) {
                        return this.superList.get(i);
                    }
                    ++this.currPosition;
                }
            }
            throw new NoSuchElementException("Sublist does not contain any more elements.");
        }

        @Override
        public void remove() {
            if (!this.nextHasBeenCalled) {
                throw new IllegalStateException("Next method for sublist iterator must be called at least once before remove can be called.");
            }
            this.superList.remove(this.currPosition);
            --this.currPosition;
            this.nextHasBeenCalled = false;
        }
    }
}

