/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzidml.xml.io;

import com.sun.xml.txw2.output.IndentingXMLStreamWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.jmzidml.model.MzIdentMLObject;
import uk.ac.ebi.jmzidml.model.mzidml.MzIdentML;
import uk.ac.ebi.jmzidml.model.utils.MzIdentMLVersion;
import uk.ac.ebi.jmzidml.xml.jaxb.marshaller.MarshallerFactory;
import uk.ac.ebi.jmzidml.xml.util.EscapingXMLStreamWriter;

public class MzIdentMLMarshaller {
    private static final Logger logger = LoggerFactory.getLogger(MzIdentMLMarshaller.class);
    private MzIdentMLVersion version;

    public MzIdentMLMarshaller() {
        this.version = MzIdentMLVersion.Version_1_1;
    }

    public MzIdentMLMarshaller(MzIdentMLVersion version) {
        this.version = version;
    }

    @Deprecated
    public <T extends MzIdentMLObject> String marshall(T object) {
        return this.marshal(object);
    }

    public <T extends MzIdentMLObject> String marshal(T object) {
        StringWriter sw = new StringWriter();
        this.marshal(object, sw);
        return sw.toString();
    }

    @Deprecated
    public <T extends MzIdentMLObject> void marshall(T object, OutputStream os) {
        this.marshal(object, os, this.version);
    }

    public <T extends MzIdentMLObject> void marshal(T object, OutputStream os) {
        this.marshal(object, os, "UTF-8", this.version);
    }

    private <T extends MzIdentMLObject> void marshal(T object, OutputStream os, MzIdentMLVersion version) {
        this.marshal(object, os, "UTF-8", version);
    }

    public <T extends MzIdentMLObject> void marshal(T object, OutputStream os, String encoding) {
        try {
            this.marshal(object, new OutputStreamWriter(os, encoding), encoding, this.version);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Could not set character encoding!");
        }
    }

    private <T extends MzIdentMLObject> void marshal(T object, OutputStream os, String encoding, MzIdentMLVersion version) {
        try {
            this.marshal(object, new OutputStreamWriter(os, encoding), encoding, version);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Could not set character encoding!");
        }
    }

    @Deprecated
    public <T extends MzIdentMLObject> void marshall(T object, Writer out) {
        this.marshal(object, out, this.version);
    }

    public <T extends MzIdentMLObject> void marshal(T object, Writer out) {
        this.marshal(object, out, "UTF-8", this.version);
    }

    private <T extends MzIdentMLObject> void marshal(T object, Writer out, MzIdentMLVersion version) {
        this.marshal(object, out, "UTF-8", version);
    }

    private <T extends MzIdentMLObject> void marshal(T object, Writer out, String encoding, MzIdentMLVersion version) {
        if (object == null) {
            throw new IllegalArgumentException("Cannot marshall a NULL object");
        }
        try {
            Marshaller marshaller = MarshallerFactory.getInstance().initializeMarshaller();
            marshaller.setProperty("jaxb.encoding", encoding);
            marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
            if (!(object instanceof MzIdentML)) {
                marshaller.setProperty("jaxb.fragment", true);
                if (logger.isDebugEnabled()) {
                    logger.debug("Object '" + object.getClass().getName() + "' will be treated as root element.");
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("Object '" + object.getClass().getName() + "' will be treated as fragment.");
            }
            QName aQName = version.getQNameForClass(object.getClass());
            JAXBElement jaxbElement = new JAXBElement(aQName, object.getClass(), object);
            System.setProperty("javax.xml.stream.XMLOutputFactory", "com.sun.xml.internal.stream.XMLOutputFactoryImpl");
            XMLOutputFactory factory = XMLOutputFactory.newFactory();
            XMLStreamWriter xmlStreamWriter = factory.createXMLStreamWriter(out);
            EscapingXMLStreamWriter exw = new EscapingXMLStreamWriter(xmlStreamWriter, version, encoding);
            exw.setNamespaceContext(new NamespaceContext(){

                @Override
                public String getNamespaceURI(String prefix) {
                    return null;
                }

                @Override
                public String getPrefix(String namespaceURI) {
                    return "";
                }

                public Iterator getPrefixes(String namespaceURI) {
                    return null;
                }
            });
            IndentingXMLStreamWriter writer = new IndentingXMLStreamWriter(exw);
            marshaller.marshal(jaxbElement, writer);
        }
        catch (JAXBException e) {
            logger.error("MzMLMarshaller.marshall", e);
            throw new IllegalStateException("Error while marshalling object:" + object.toString());
        }
        catch (XMLStreamException e) {
            logger.error("MzMLMarshaller.marshall", e);
            throw new IllegalStateException("Error while marshalling object:" + object.toString());
        }
    }

    public String createXmlHeader() {
        String encoding = System.getProperty("file.encoding");
        return "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>";
    }

    public String createMzIdentMLStartTag(String id) {
        StringBuffer sb = new StringBuffer();
        sb.append("<MzIdentML id=\"").append(id).append("\"");
        sb.append(" version=\"").append(this.version.getVersionString()).append("\"");
        sb.append(" xmlns=\"").append(this.version.getNameSpace()).append("\"");
        sb.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        sb.append(" xsi:schemaLocation=\"").append(this.version.getNameSpace()).append(" ").append(this.version.getSchema()).append("\"");
        SimpleDateFormat dfm = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        sb.append(" creationDate=\"").append(dfm.format(new Date())).append("\"");
        sb.append(" >");
        return sb.toString();
    }

    public String createMzIdentMLClosingTag() {
        return "</MzIdentML>";
    }

    public String createDataCollectionStartTag() {
        return "<DataCollection>";
    }

    public String createDataCollectionClosingTag() {
        return "</DataCollection>";
    }

    public String createAnalysisDataStartTag() {
        return "<AnalysisData>";
    }

    public String createAnalysisDataClosingTag() {
        return "</AnalysisData>";
    }

    public String createProteinDetectionListStartTag(String id, String name) {
        if (id == null) {
            throw new IllegalArgumentException("The 'id' attribute must not be null!");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<ProteinDetectionList id=\"").append(id).append("\"");
        if (name != null) {
            sb.append(" name=\"").append(name).append("\"");
        }
        sb.append(" >");
        return sb.toString();
    }

    public String createProteinDetectionListClosingTag() {
        return "</ProteinDetectionList>";
    }

    public String createSpectrumIdentificationListStartTag(String id, String name, Long numSeqSearched) {
        if (id == null) {
            throw new IllegalArgumentException("The 'id' attribute must not be null!");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<SpectrumIdentificationList id=\"").append(id).append("\"");
        if (name != null) {
            sb.append(" name=\"").append(name).append("\"");
        }
        if (numSeqSearched != null) {
            sb.append(" numSequencesSearched=\"").append(numSeqSearched).append("\"");
        }
        sb.append(" >");
        return sb.toString();
    }

    public String createSpectrumIdentificationListClosingTag() {
        return "</SpectrumIdentificationList>";
    }
}

