/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzidml.xml.io;

import java.io.StringReader;
import java.util.Iterator;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.sax.SAXSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import uk.ac.ebi.jmzidml.MzIdentMLElement;
import uk.ac.ebi.jmzidml.model.MzIdentMLObject;
import uk.ac.ebi.jmzidml.model.utils.MzIdentMLVersion;
import uk.ac.ebi.jmzidml.xml.io.MzIdentMLObjectCache;
import uk.ac.ebi.jmzidml.xml.jaxb.unmarshaller.UnmarshallerFactory;
import uk.ac.ebi.jmzidml.xml.jaxb.unmarshaller.filters.MzIdentMLNamespaceFilter;
import uk.ac.ebi.jmzidml.xml.util.EscapingXMLUtilities;
import uk.ac.ebi.jmzidml.xml.xxindex.MzIdentMLIndexer;

public class MzIdentMLObjectIterator<T extends MzIdentMLObject>
implements Iterator<T> {
    private static Logger logger = LoggerFactory.getLogger(MzIdentMLObjectIterator.class);
    private Iterator<String> innerXpathIterator;
    private String xpath;
    private Class<T> cls;
    private MzIdentMLIndexer index;
    private MzIdentMLObjectCache cache;
    private MzIdentMLVersion version;

    MzIdentMLObjectIterator(MzIdentMLElement element, MzIdentMLIndexer index, MzIdentMLObjectCache cache, MzIdentMLVersion version) {
        this.innerXpathIterator = index.getXmlStringIterator(element.getXpath());
        this.xpath = element.getXpath();
        this.cls = element.getClazz();
        this.index = index;
        this.cache = cache;
        this.version = version;
    }

    @Override
    public boolean hasNext() {
        return this.innerXpathIterator != null && this.innerXpathIterator.hasNext();
    }

    @Override
    public T next() {
        MzIdentMLObject retval;
        try {
            String xmlSt = this.innerXpathIterator.next();
            String cleanXML = EscapingXMLUtilities.escapeCharacters(xmlSt);
            if (logger.isDebugEnabled()) {
                logger.trace("XML to unmarshal: " + cleanXML);
            }
            MzIdentMLNamespaceFilter xmlFilter = new MzIdentMLNamespaceFilter(this.version);
            Unmarshaller unmarshaller = UnmarshallerFactory.getInstance().initializeUnmarshaller(this.index, this.cache, xmlFilter);
            JAXBElement<T> holder = unmarshaller.unmarshal(new SAXSource(xmlFilter, new InputSource(new StringReader(cleanXML))), this.cls);
            retval = (MzIdentMLObject)holder.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug("unmarshalled object = " + retval);
            }
        }
        catch (JAXBException e) {
            logger.error("MzMLObjectIterator.next", e);
            throw new IllegalStateException("Could not unmarshal object at xpath:" + this.xpath);
        }
        return (T)retval;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(MzIdentMLObjectIterator.class.getName() + " can't be used to remove objects while iterating");
    }
}

