/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzidml.xml.io;

import java.io.File;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.ConfigurationException;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.sax.SAXSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import uk.ac.ebi.jmzidml.MzIdentMLElement;
import uk.ac.ebi.jmzidml.model.MzIdentMLObject;
import uk.ac.ebi.jmzidml.model.utils.MzIdentMLVersion;
import uk.ac.ebi.jmzidml.xml.io.MzIdentMLObjectCache;
import uk.ac.ebi.jmzidml.xml.io.MzIdentMLObjectIterator;
import uk.ac.ebi.jmzidml.xml.jaxb.unmarshaller.UnmarshallerFactory;
import uk.ac.ebi.jmzidml.xml.jaxb.unmarshaller.filters.MzIdentMLNamespaceFilter;
import uk.ac.ebi.jmzidml.xml.util.EscapingXMLUtilities;
import uk.ac.ebi.jmzidml.xml.xxindex.FileUtils;
import uk.ac.ebi.jmzidml.xml.xxindex.MzIdentMLIndexer;
import uk.ac.ebi.jmzidml.xml.xxindex.MzIdentMLIndexerFactory;

public class MzIdentMLUnmarshaller {
    private static final Logger logger = LoggerFactory.getLogger(MzIdentMLUnmarshaller.class);
    protected final MzIdentMLIndexer index;
    private final MzIdentMLObjectCache cache;
    private String mzidName = null;
    private String mzidID = null;
    private String mzidVersion = null;
    private static final Pattern ID_PATTERN = Pattern.compile("id\\s*=\\s*[\"']([^\"'>]*)?[\"']", 2);
    private static final Pattern VERSION_PATTERN = Pattern.compile("version\\s*=\\s*[\"']([^\"'>]*)?[\"']", 2);
    private static final Pattern NAME_PATTERN = Pattern.compile("name\\s*=\\s*[\"']([^\"'>]*)?[\"']", 2);
    private static final Pattern XML_ATT_PATTERN = Pattern.compile("\\s+([A-Za-z_:]+)\\s*=\\s*[\"']([^\"'>]+?)[\"']", 32);
    private MzIdentMLVersion mzIdentVersion = null;

    public MzIdentMLUnmarshaller(URL mzIdentMLFileURL) {
        this(FileUtils.getFileFromURL(mzIdentMLFileURL));
    }

    public MzIdentMLUnmarshaller(File mzIdentMLFile) {
        this(MzIdentMLIndexerFactory.getInstance().buildIndex(mzIdentMLFile));
    }

    public MzIdentMLUnmarshaller(URL mzIdentMLFileURL, boolean inMemory) {
        this(FileUtils.getFileFromURL(mzIdentMLFileURL), inMemory);
    }

    public MzIdentMLUnmarshaller(File mzIdentMLFile, boolean inMemory) {
        this(MzIdentMLIndexerFactory.getInstance().buildIndex(mzIdentMLFile, inMemory));
    }

    public MzIdentMLUnmarshaller(MzIdentMLIndexer indexer) {
        this.index = indexer;
        this.cache = null;
        if (this.getMzIdentMLVersion().startsWith("1.1")) {
            this.mzIdentVersion = MzIdentMLVersion.Version_1_1;
        } else if (this.mzidVersion.startsWith("1.2")) {
            this.mzIdentVersion = MzIdentMLVersion.Version_1_2;
        } else {
            throw new IllegalStateException("The mzIdentML file version is not recognized!");
        }
    }

    @Deprecated
    public MzIdentMLUnmarshaller(URL mzIdentMLFileURL, MzIdentMLObjectCache cache) {
        this(FileUtils.getFileFromURL(mzIdentMLFileURL), cache);
    }

    @Deprecated
    public MzIdentMLUnmarshaller(File mzIdentMLFile, MzIdentMLObjectCache cache) {
        this.index = MzIdentMLIndexerFactory.getInstance().buildIndex(mzIdentMLFile);
        this.cache = cache;
    }

    public String getMzIdentMLVersion() {
        Matcher match;
        if (this.mzidVersion == null && (match = VERSION_PATTERN.matcher(this.index.getMzIdentMLAttributeXMLString())).find()) {
            this.mzidVersion = match.group(1);
        }
        return this.mzidVersion;
    }

    public String getMzIdentMLId() {
        Matcher match;
        if (this.mzidID == null && (match = ID_PATTERN.matcher(this.index.getMzIdentMLAttributeXMLString())).find()) {
            this.mzidID = match.group(1);
        }
        return this.mzidID;
    }

    public String getMzIdentMLName() {
        Matcher match;
        if (this.mzidName == null && (match = NAME_PATTERN.matcher(this.index.getMzIdentMLAttributeXMLString())).find()) {
            return match.group(1);
        }
        return this.mzidName;
    }

    public Map<String, String> getElementAttributes(String id, Class clazz) {
        String tag = this.index.getStartTag(id, clazz);
        if (tag == null) {
            return null;
        }
        return this.getElementAttributes(tag);
    }

    public Map<String, String> getElementAttributes(String xmlTag) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        Matcher match = XML_ATT_PATTERN.matcher(xmlTag);
        while (match.find()) {
            if (match.groupCount() == 2) {
                String name = match.group(1);
                String value = match.group(2);
                attributes.put(name, value);
                continue;
            }
            System.out.println("Unexpected number of groups for XML attribute: " + match.groupCount() + " in tag: " + xmlTag);
        }
        return attributes;
    }

    public int getObjectCountForXpath(String xpath) {
        if (xpath != null) {
            return this.index.getCount(xpath);
        }
        return -1;
    }

    public <T extends MzIdentMLObject> T unmarshal(Class<T> clazz) {
        String xpath = MzIdentMLElement.getType(clazz).getXpath();
        return this.doUnmarshal(clazz, xpath);
    }

    public <T extends MzIdentMLObject> T unmarshal(String xpath) {
        Class clazz = MzIdentMLElement.getType(xpath).getClazz();
        return this.doUnmarshal(clazz, xpath);
    }

    public <T extends MzIdentMLObject> T unmarshal(MzIdentMLElement element) {
        Class clazz = element.getClazz();
        String xpath = element.getXpath();
        return this.doUnmarshal(clazz, xpath);
    }

    public <T extends MzIdentMLObject> Iterator<T> unmarshalCollectionFromXpath(MzIdentMLElement element) {
        return new MzIdentMLObjectIterator(element, this.index, this.cache, this.mzIdentVersion);
    }

    public Set<String> getIDsForElement(MzIdentMLElement element) throws ConfigurationException {
        return this.index.getIDsForElement(element);
    }

    @Deprecated
    public <T extends MzIdentMLObject> T unmarshall(Class<T> clazz, String id) throws JAXBException {
        return this.unmarshal(clazz, id);
    }

    public <T extends MzIdentMLObject> T unmarshal(Class<T> clazz, String id) throws JAXBException {
        if (!this.index.isIDmapped(id, clazz)) {
            throw new IllegalArgumentException("No entry found for ID: " + id + " and Class: " + clazz + ". Make sure the element you are looking for has an ID attribute and is id-mapped!");
        }
        String xmlSt = this.index.getXmlString(id, clazz);
        return this.generateObject(clazz, xmlSt);
    }

    private <T extends MzIdentMLObject> T doUnmarshal(Class<T> clazz, String xpath) {
        T retval = null;
        if (xpath != null) {
            retval = this.retrieveFromXML(clazz, xpath);
        } else {
            logger.info("No xpath or index entry for class " + clazz + "! Can not unmarshal!");
        }
        return retval;
    }

    private <T extends MzIdentMLObject> T retrieveFromXML(Class<T> cls, String xpath) {
        T retval = null;
        try {
            Iterator<String> xpathIter = this.index.getXmlStringIterator(xpath);
            if (xpathIter == null) {
                return null;
            }
            if (xpathIter.hasNext()) {
                String xmlSt = xpathIter.next();
                retval = this.generateObject(cls, xmlSt);
            }
        }
        catch (JAXBException e) {
            logger.error("MzMLUnmarshaller unmarshal error: ", e);
            throw new IllegalStateException("Could not unmarshal object at xpath:" + xpath);
        }
        return retval;
    }

    private <T extends MzIdentMLObject> T generateObject(Class<T> cls, String xmlSt) throws JAXBException {
        String cleanXML = EscapingXMLUtilities.escapeCharacters(xmlSt);
        if (logger.isDebugEnabled()) {
            logger.trace("XML to unmarshal: " + cleanXML);
        }
        MzIdentMLNamespaceFilter xmlFilter = new MzIdentMLNamespaceFilter(this.mzIdentVersion);
        Unmarshaller unmarshaller = UnmarshallerFactory.getInstance().initializeUnmarshaller(this.index, this.cache, xmlFilter);
        JAXBElement<T> holder = unmarshaller.unmarshal(new SAXSource(xmlFilter, new InputSource(new StringReader(cleanXML))), cls);
        MzIdentMLObject retval = (MzIdentMLObject)holder.getValue();
        if (logger.isDebugEnabled()) {
            logger.debug("unmarshalled object = " + retval);
        }
        return (T)retval;
    }
}

