/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzidml.xml.jaxb.marshaller.listeners;

import java.util.List;
import javax.xml.bind.Marshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.jmzidml.model.mzidml.AbstractContact;
import uk.ac.ebi.jmzidml.model.mzidml.AbstractParam;
import uk.ac.ebi.jmzidml.model.mzidml.AnalysisSampleCollection;
import uk.ac.ebi.jmzidml.model.mzidml.AuditCollection;
import uk.ac.ebi.jmzidml.model.mzidml.Cv;
import uk.ac.ebi.jmzidml.model.mzidml.CvList;
import uk.ac.ebi.jmzidml.model.mzidml.Enzyme;
import uk.ac.ebi.jmzidml.model.mzidml.Enzymes;
import uk.ac.ebi.jmzidml.model.mzidml.Fragmentation;
import uk.ac.ebi.jmzidml.model.mzidml.IonType;
import uk.ac.ebi.jmzidml.model.mzidml.ParamList;
import uk.ac.ebi.jmzidml.model.mzidml.Sample;

public class ObjectClassListener
extends Marshaller.Listener {
    private static final Logger log = LoggerFactory.getLogger(ObjectClassListener.class);

    @Override
    public void beforeMarshal(Object source) {
        List<Sample> sampleList;
        log.debug("Handling " + source.getClass() + " in beforeMarshal.");
        if (source instanceof ParamList) {
            List<AbstractParam> paramList = ((ParamList)source).getParamGroup();
            if (paramList.size() == 0) {
                throw new IllegalArgumentException("ParamList contains an empty list of AbstractParam.");
            }
        } else if (source instanceof Fragmentation) {
            List<IonType> ionTypeList = ((Fragmentation)source).getIonType();
            if (ionTypeList.size() == 0) {
                throw new IllegalArgumentException("Fragmentation contains an empty list of IonType.");
            }
        } else if (source instanceof Enzymes) {
            List<Enzyme> enzymeList = ((Enzymes)source).getEnzyme();
            if (enzymeList.size() == 0) {
                throw new IllegalArgumentException("Enzymes contains an empty list of Enzyme.");
            }
        } else if (source instanceof CvList) {
            List<Cv> cvList = ((CvList)source).getCv();
            if (cvList.size() == 0) {
                throw new IllegalArgumentException("CvList contains an empty list of Cv.");
            }
        } else if (source instanceof AuditCollection) {
            List<AbstractContact> contactList = ((AuditCollection)source).getPersonOrOrganization();
            if (contactList.size() == 0) {
                throw new IllegalArgumentException("AuditCollection contains an empty list of AbstractContact.");
            }
        } else if (source instanceof AnalysisSampleCollection && (sampleList = ((AnalysisSampleCollection)source).getSample()).size() == 0) {
            throw new IllegalArgumentException("AnalysisSampleCollection contains an empty list of Sample.");
        }
    }
}

