/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzidml.xml.jaxb.unmarshaller.listeners;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.jmzidml.MzIdentMLElement;
import uk.ac.ebi.jmzidml.ParamListMappings;
import uk.ac.ebi.jmzidml.ParamMappings;
import uk.ac.ebi.jmzidml.model.CvParamCapable;
import uk.ac.ebi.jmzidml.model.CvParamListCapable;
import uk.ac.ebi.jmzidml.model.ParamCapable;
import uk.ac.ebi.jmzidml.model.ParamGroupCapable;
import uk.ac.ebi.jmzidml.model.ParamListCapable;
import uk.ac.ebi.jmzidml.model.mzidml.AbstractParam;
import uk.ac.ebi.jmzidml.model.mzidml.CvParam;
import uk.ac.ebi.jmzidml.model.mzidml.Param;
import uk.ac.ebi.jmzidml.model.mzidml.ParamList;
import uk.ac.ebi.jmzidml.model.utils.MzIdentMLVersion;
import uk.ac.ebi.jmzidml.model.utils.ParamUpdater;
import uk.ac.ebi.jmzidml.xml.io.MzIdentMLObjectCache;
import uk.ac.ebi.jmzidml.xml.jaxb.resolver.AbstractReferenceResolver;
import uk.ac.ebi.jmzidml.xml.xxindex.MzIdentMLIndexer;

public class RawXMLListener
extends Unmarshaller.Listener {
    private static final Logger log = LoggerFactory.getLogger(RawXMLListener.class);
    private final MzIdentMLIndexer index;
    private final MzIdentMLObjectCache cache;
    private MzIdentMLVersion version;

    public RawXMLListener(MzIdentMLIndexer index, MzIdentMLObjectCache cache, MzIdentMLVersion version) {
        this.index = index;
        this.cache = cache;
        this.version = version;
    }

    @Override
    public void afterUnmarshal(Object target, Object parent) {
        log.debug("Handling " + target.getClass() + " in afterUnmarshal.");
        MzIdentMLElement ele = MzIdentMLElement.getType(target.getClass());
        this.paramHandling(target, ele);
        this.referenceResolving(target, parent, ele);
    }

    private void paramHandling(Object target, MzIdentMLElement ele) {
        try {
            Object cpc;
            if (target instanceof ParamCapable) {
                ParamMappings mapping = ParamMappings.getType(target.getClass());
                String className = mapping.getClassName();
                Method method = target.getClass().getMethod("get" + className, new Class[0]);
                Param param = (Param)method.invoke(target, new Object[0]);
                if (param != null) {
                    Class<?> clazz;
                    if (param.getCvParam() != null) {
                        clazz = Class.forName("uk.ac.ebi.jmzidml.model.mzidml.params." + className + "CvParam");
                        Object cvParam = ParamUpdater.updateCvParamSubclass(param.getCvParam(), clazz);
                        param.setParam((AbstractParam)cvParam);
                    } else if (param.getUserParam() != null) {
                        clazz = Class.forName("uk.ac.ebi.jmzidml.model.mzidml.params." + className + "UserParam");
                        Object userParam = ParamUpdater.updateUserParamSubclass(param.getUserParam(), clazz);
                        param.setParam((AbstractParam)userParam);
                    }
                }
            }
            if (target instanceof ParamListCapable) {
                String[] classNames;
                ParamListMappings mappings = ParamListMappings.getType(target.getClass());
                for (String className : classNames = mappings.getClassNames()) {
                    Method method = target.getClass().getMethod("get" + className, new Class[0]);
                    ParamList paramList = (ParamList)method.invoke(target, new Object[0]);
                    if (paramList == null) continue;
                    Class<?> clazz = Class.forName("uk.ac.ebi.jmzidml.model.mzidml.params." + className + "CvParam");
                    ParamUpdater.updateCvParamSubclassesList(paramList.getCvParam(), clazz);
                    clazz = Class.forName("uk.ac.ebi.jmzidml.model.mzidml.params." + className + "UserParam");
                    ParamUpdater.updateUserParamSubclassesList(paramList.getUserParam(), clazz);
                }
            } else if (target instanceof ParamGroupCapable) {
                ParamGroupCapable apg = (ParamGroupCapable)target;
                if (ele.getCvParamClass() == null) {
                    throw new IllegalStateException("Subclass of AbstractParamGroup does not have CvParam subclass! " + target.getClass());
                }
                ParamUpdater.updateCvParamSubclassesList(apg.getCvParam(), ele.getCvParamClass());
                if (ele.getUserParamClass() == null) {
                    throw new IllegalStateException("Subclass of AbstractParamGroup does not have UserParam subclass! " + target.getClass());
                }
                ParamUpdater.updateUserParamSubclassesList(apg.getUserParam(), ele.getUserParamClass());
            } else if (target instanceof CvParamCapable) {
                cpc = (CvParamCapable)target;
                if (ele.getCvParamClass() == null) {
                    throw new IllegalStateException("Subclass of AbstractParamGroup does not have CvParam subclass! " + target.getClass());
                }
                CvParam param = cpc.getCvParam();
                cpc.setCvParam((CvParam)ParamUpdater.updateCvParamSubclass(param, ele.getCvParamClass()));
            } else if (target instanceof CvParamListCapable) {
                cpc = (CvParamListCapable)target;
                if (ele.getCvParamClass() == null) {
                    throw new IllegalStateException("Subclass of AbstractParamGroup does not have CvParam subclass! " + target.getClass());
                }
                ParamUpdater.updateCvParamSubclassesList(cpc.getCvParam(), ele.getCvParamClass());
            } else if (ele.getCvParamClass() != null || ele.getUserParamClass() != null) {
                throw new IllegalStateException("Element with param subclasses has not been handled! " + target.getClass());
            }
        }
        catch (Exception e) {
            log.error("Exception during post unmarshall processing! ", e);
            throw new IllegalStateException("Error during post unmarshall processing!", e);
        }
    }

    private void referenceResolving(Object target, Object parent, MzIdentMLElement ele) {
        if (ele.isAutoRefResolving()) {
            Class cls = ele.getRefResolverClass();
            if (cls == null) {
                throw new IllegalStateException("Can not auto-resolve references if no reference resolver was defined for class: " + ele.getClazz());
            }
            try {
                Constructor con = cls.getDeclaredConstructor(MzIdentMLIndexer.class, MzIdentMLObjectCache.class, MzIdentMLVersion.class);
                AbstractReferenceResolver resolver = (AbstractReferenceResolver)con.newInstance(new Object[]{this.index, this.cache, this.version});
                resolver.afterUnmarshal(target, parent);
            }
            catch (Exception e) {
                log.error("Error trying to instantiate reference resolver: " + cls.getName(), e);
                throw new IllegalStateException("Could not instantiate reference resolver: " + cls.getName());
            }
        }
    }
}

