/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzidml.xml.xxindex;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import psidev.psi.tools.xxindex.FastXmlElementExtractor;
import psidev.psi.tools.xxindex.StandardXpathAccess;
import psidev.psi.tools.xxindex.XpathAccess;
import psidev.psi.tools.xxindex.index.IndexElement;
import psidev.psi.tools.xxindex.index.XpathIndex;
import uk.ac.ebi.jmzidml.MzIdentMLElement;
import uk.ac.ebi.jmzidml.model.MzIdentMLObject;
import uk.ac.ebi.jmzidml.model.mzidml.Identifiable;
import uk.ac.ebi.jmzidml.xml.Constants;
import uk.ac.ebi.jmzidml.xml.xxindex.MemoryMappedStandardXpathAccess;
import uk.ac.ebi.jmzidml.xml.xxindex.MemoryMappedXmlElementExtractor;
import uk.ac.ebi.jmzidml.xml.xxindex.MzIdentMLIndexer;

public class MzIdentMLIndexerFactory {
    private static final Logger logger = LoggerFactory.getLogger(MzIdentMLIndexerFactory.class);
    private static final MzIdentMLIndexerFactory instance = new MzIdentMLIndexerFactory();
    private static final Pattern ID_PATTERN = Pattern.compile("\\sid\\s*=\\s*['\"]([^'\"]*)['\"]", 2);

    private MzIdentMLIndexerFactory() {
    }

    public static MzIdentMLIndexerFactory getInstance() {
        return instance;
    }

    public MzIdentMLIndexer buildIndex(File xmlFile) {
        return this.buildIndex(xmlFile, Constants.XML_INDEXED_XPATHS, false);
    }

    public MzIdentMLIndexer buildIndex(File xmlFile, Set<String> xpaths) {
        return new MzIdentMLIndexerImpl(xmlFile, xpaths, false);
    }

    public MzIdentMLIndexer buildIndex(File xmlFile, boolean inMeomory) {
        return this.buildIndex(xmlFile, Constants.XML_INDEXED_XPATHS, inMeomory);
    }

    public MzIdentMLIndexer buildIndex(File xmlFile, Set<String> xpaths, boolean inMemory) {
        return new MzIdentMLIndexerImpl(xmlFile, xpaths, inMemory);
    }

    private class MzIdentMLIndexerImpl
    implements MzIdentMLIndexer {
        private File xmlFile = null;
        private boolean inMemory = false;
        private byte[] xmlFileBuffer;
        private XpathAccess xpathAccess = null;
        private FastXmlElementExtractor xmlExtractor = null;
        private MemoryMappedXmlElementExtractor memoryMappedXmlElementExtractor;
        private XpathIndex index = null;
        private String mzIdentMLAttributeXMLString = null;
        private Map<Class, Map<String, IndexElement>> idMapCache = new HashMap<Class, Map<String, IndexElement>>();

        private MzIdentMLIndexerImpl(File xmlFile, Set<String> xpaths, boolean inMemory) {
            if (xmlFile == null) {
                throw new IllegalStateException("XML File to index must not be null");
            }
            if (!xmlFile.exists()) {
                throw new IllegalStateException("XML File to index does not exist: " + xmlFile.getAbsolutePath());
            }
            this.xmlFile = xmlFile;
            this.inMemory = inMemory;
            try {
                this.initXpathAccess(xmlFile, xpaths, inMemory);
                this.index = this.xpathAccess.getIndex();
                if (!this.index.containsXpath(MzIdentMLElement.MzIdentML.getXpath())) {
                    logger.info("Index does not contain mzIdentML root! We are not dealing with an mzIndentML file!");
                    throw new IllegalStateException("Index does not contain mzIdentML root!");
                }
                this.initIdMaps();
                this.mzIdentMLAttributeXMLString = this.extractMzIdentMLStartTag(xmlFile);
            }
            catch (IOException e) {
                logger.error("MzMLIndexerFactory$MzMlIndexerImpl.MzMlIndexerImpl", e);
                throw new IllegalStateException("Could not generate MzIdentML index for file: " + xmlFile);
            }
        }

        private void initXpathAccess(File xmlFile, Set<String> xpaths, boolean inMemory) throws IOException {
            if (inMemory) {
                this.loadFileIntoMemory(xmlFile);
                MemoryMappedStandardXpathAccess memoryMappedStandardXpathAccess = new MemoryMappedStandardXpathAccess(this.xmlFileBuffer, xpaths);
                this.memoryMappedXmlElementExtractor = memoryMappedStandardXpathAccess.getExtractor();
                this.xpathAccess = memoryMappedStandardXpathAccess;
            } else {
                this.xpathAccess = new StandardXpathAccess(xmlFile, xpaths);
                this.xmlExtractor = new FastXmlElementExtractor(xmlFile);
                this.xmlExtractor.setEncoding(this.xmlExtractor.detectFileEncoding(xmlFile.toURI().toURL()));
            }
        }

        private void loadFileIntoMemory(File xmlFile) throws IOException {
            FileInputStream fis = new FileInputStream(xmlFile);
            FileChannel fc = fis.getChannel();
            MappedByteBuffer mmb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            this.xmlFileBuffer = new byte[(int)fc.size()];
            mmb.get(this.xmlFileBuffer);
            fis.close();
        }

        @Override
        public String getMzIdentMLAttributeXMLString() {
            return this.mzIdentMLAttributeXMLString;
        }

        @Override
        public Iterator<String> getXmlStringIterator(String xpathExpression) {
            if (this.index.containsXpath(xpathExpression)) {
                return this.xpathAccess.getXmlSnippetIterator(xpathExpression);
            }
            return null;
        }

        @Override
        public int getCount(String xpathExpression) {
            List<IndexElement> tmpList;
            int retValue = -1;
            if (this.index.containsXpath(xpathExpression) && (tmpList = this.index.getElements(xpathExpression)) != null) {
                retValue = tmpList.size();
            }
            return retValue;
        }

        @Override
        public List<IndexElement> getIndexElements(String xpath) {
            return new ArrayList<IndexElement>(this.index.getElements(xpath));
        }

        @Override
        public Map<String, IndexElement> getIndexElements(Class clazz) {
            return new HashMap<String, IndexElement>(this.idMapCache.get(clazz));
        }

        @Override
        public Set<String> getXpath() {
            return new HashSet<String>(this.index.getKeys());
        }

        @Override
        public String getXmlString(String ID2, Class clazz) {
            logger.debug("Getting cached ID: " + ID2 + " from cache: " + clazz);
            Map<String, IndexElement> idMap = this.idMapCache.get(clazz);
            IndexElement element = idMap.get(ID2);
            String xmlSnippet = null;
            if (element != null) {
                xmlSnippet = this.getXmlString(element);
                if (logger.isTraceEnabled()) {
                    logger.trace("Retrieved xml for class " + clazz + " with ID " + ID2 + ": " + xmlSnippet);
                }
            }
            return xmlSnippet;
        }

        @Override
        public String getStartTag(String id, Class clazz) {
            IndexElement element;
            logger.debug("Getting start tag of element with id: " + id + " for class: " + clazz);
            String tag = null;
            Map<String, IndexElement> idMap = this.idMapCache.get(clazz);
            if (idMap != null && (element = idMap.get(id)) != null) {
                try {
                    if (this.xpathAccess instanceof StandardXpathAccess) {
                        tag = ((StandardXpathAccess)this.xpathAccess).getStartTag(element);
                    } else if (this.xpathAccess instanceof MemoryMappedStandardXpathAccess) {
                        tag = ((MemoryMappedStandardXpathAccess)this.xpathAccess).getStartTag(element);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return tag;
        }

        @Override
        public boolean isIDmapped(String id, Class clazz) {
            if (clazz == null) {
                return false;
            }
            Map<String, IndexElement> idMap = this.idMapCache.get(clazz);
            return idMap != null && idMap.containsKey(id);
        }

        @Override
        public Set<String> getIDsForElement(MzIdentMLElement element) throws ConfigurationException {
            if (element.isIdMapped()) {
                return this.idMapCache.get(element.getClazz()).keySet();
            }
            throw new ConfigurationException("API not configured to support ID mapping for element: " + element.getTagName());
        }

        public <T extends MzIdentMLObject> Set<String> getElementIDs(Class<T> clazz) {
            if (this.idMapCache == null) {
                return null;
            }
            Map<String, IndexElement> classCache = this.idMapCache.get(clazz);
            if (classCache == null) {
                return null;
            }
            return classCache.keySet();
        }

        @Override
        public String getXmlString(IndexElement byteRange) {
            return this.getXmlString(byteRange, 0);
        }

        private String getXmlString(IndexElement byteRange, int maxChars) {
            try {
                if (byteRange != null) {
                    long limitedStop = byteRange.getStart() + (long)maxChars;
                    long stop = maxChars > 0 && byteRange.getStop() > limitedStop ? limitedStop : byteRange.getStop();
                    return this.inMemory ? this.memoryMappedXmlElementExtractor.readString(byteRange.getStart(), stop, new ByteArrayInputStream(this.xmlFileBuffer)) : this.xmlExtractor.readString(byteRange.getStart(), stop, this.xmlFile);
                }
                throw new IllegalStateException("Attempting to read NULL ByteRange");
            }
            catch (IOException e) {
                logger.error("MzMLIndexerFactory$MzMlIndexerImpl.readXML", e);
                throw new IllegalStateException("Could not extract XML from file: " + this.xmlFile);
            }
        }

        private String extractMzIdentMLStartTag(File xmlFile) throws IOException {
            String startTag;
            List<IndexElement> ie = this.index.getElements(MzIdentMLElement.MzIdentML.getXpath());
            long startPos = ie.get(0).getStart();
            ie = this.index.getElements(MzIdentMLElement.CvList.getXpath());
            long stopPos = ie.get(0).getStart() - 1L;
            String string = startTag = this.inMemory ? this.memoryMappedXmlElementExtractor.readString(startPos, stopPos, new ByteArrayInputStream(this.xmlFileBuffer)) : this.xmlExtractor.readString(startPos, stopPos, xmlFile);
            if (startTag != null) {
                startTag = startTag.replace("\n", "");
            }
            return startTag;
        }

        private void initIdMaps() throws IOException {
            for (MzIdentMLElement element : MzIdentMLElement.values()) {
                if (!element.isIdMapped() || !element.isIndexed()) continue;
                if (((Object)((Object)element)).getClass().isAssignableFrom(Identifiable.class)) {
                    logger.warn("Element for class " + ((Object)((Object)element)).getClass() + " may not contain an 'id' attribute, but was selected for id mapping!");
                }
                logger.debug("Initialising ID map for " + element.getClazz().getName());
                Map<String, IndexElement> map = this.idMapCache.get(element.getClazz());
                if (map == null) {
                    map = new HashMap<String, IndexElement>(this.index.getElements(element.getXpath()).size());
                    this.idMapCache.put(element.getClazz(), map);
                } else {
                    logger.debug("This IdElement Map already exists");
                }
                this.initIdMapCache(map, element.getXpath());
            }
        }

        private void initIdMapCache(Map<String, IndexElement> idMap, String xpath) throws IOException {
            List<IndexElement> ranges = this.index.getElements(xpath);
            for (IndexElement byteRange : ranges) {
                String xml = null;
                if (this.xpathAccess instanceof StandardXpathAccess) {
                    xml = ((StandardXpathAccess)this.xpathAccess).getStartTag(byteRange);
                } else if (this.xpathAccess instanceof MemoryMappedStandardXpathAccess) {
                    xml = ((MemoryMappedStandardXpathAccess)this.xpathAccess).getStartTag(byteRange);
                }
                String id = this.getIdFromRawXML(xml);
                if (id != null) {
                    idMap.put(id, byteRange);
                    continue;
                }
                throw new IllegalStateException("Error initializing ID cache: No id attribute found for element " + xml);
            }
        }

        private String getIdFromRawXML(String xml) {
            String id = null;
            if (xml != null && xml != "") {
                Matcher match = ID_PATTERN.matcher(xml);
                if (match.find()) {
                    id = match.group(1).intern();
                } else {
                    throw new IllegalStateException("Invalid ID in xml: " + xml);
                }
            }
            return id;
        }
    }
}

