/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzml.xml.xxindex;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import psidev.psi.tools.xxindex.FastXmlElementExtractor;
import psidev.psi.tools.xxindex.StandardXpathAccess;
import psidev.psi.tools.xxindex.XmlElementExtractor;
import psidev.psi.tools.xxindex.index.IndexElement;
import psidev.psi.tools.xxindex.index.XpathIndex;
import uk.ac.ebi.jmzml.MzMLElement;
import uk.ac.ebi.jmzml.model.mzml.Chromatogram;
import uk.ac.ebi.jmzml.model.mzml.Spectrum;
import uk.ac.ebi.jmzml.xml.Constants;
import uk.ac.ebi.jmzml.xml.xxindex.MzMLIndexer;

public class MzMLIndexerFactory {
    private static final Logger logger = LoggerFactory.getLogger(MzMLIndexerFactory.class);
    private static final MzMLIndexerFactory instance = new MzMLIndexerFactory();
    private static final Pattern ID_PATTERN = Pattern.compile("\\sid\\s*=\\s*['\"]([^'\"]*)['\"]", 2);
    private static final Pattern INDEX_PATTERN = Pattern.compile("\\sindex\\s*=\\s*['\"]([^'\"]*)['\"]", 2);

    private MzMLIndexerFactory() {
    }

    public static MzMLIndexerFactory getInstance() {
        return instance;
    }

    public MzMLIndexer buildIndex(File xmlFile) {
        return new MzMlIndexerImpl(xmlFile);
    }

    private class MzMlIndexerImpl
    implements MzMLIndexer {
        private File xmlFile = null;
        private StandardXpathAccess xpathAccess = null;
        private XmlElementExtractor xmlExtractor = null;
        private XpathIndex index = null;
        private String root = null;
        private String mzMLAttributeXMLString = null;
        private HashMap<Class, LinkedHashMap<String, IndexElement>> idMapCache = new HashMap();
        private HashMap<Integer, String> spectrumIndexToIDMap = new HashMap();

        private MzMlIndexerImpl(File xmlFile) {
            if (xmlFile == null) {
                throw new IllegalStateException("XML File to index must not be null");
            }
            if (!xmlFile.exists()) {
                throw new IllegalStateException("XML File to index does not exist: " + xmlFile.getAbsolutePath());
            }
            this.xmlFile = xmlFile;
            try {
                logger.debug("Creating index: ");
                this.xpathAccess = new StandardXpathAccess(xmlFile, Constants.XML_INDEXED_XPATHS);
                logger.debug("done!");
                this.xmlExtractor = new FastXmlElementExtractor(xmlFile);
                String encoding = this.xmlExtractor.detectFileEncoding(xmlFile.toURI().toURL());
                if (encoding != null) {
                    this.xmlExtractor.setEncoding(encoding);
                }
                this.index = this.xpathAccess.getIndex();
                this.root = "/mzML";
                if (!this.index.containsXpath(MzMLElement.MzML.getXpath())) {
                    if (!this.index.containsXpath(MzMLElement.IndexedmzML.getXpath())) {
                        logger.error("Index does not contain mzML root! We are not dealing with an mzML file!");
                        throw new IllegalStateException("Index does not contain mzML root!");
                    }
                    this.root = "/indexedmzML/mzML";
                }
                this.initIdMaps();
                this.mzMLAttributeXMLString = this.extractMzMLStartTag(xmlFile);
            }
            catch (IOException e) {
                logger.error("MzMLIndexerFactory$MzMlIndexerImpl.MzMlIndexerImpl", e);
                throw new IllegalStateException("Could not generate MzML index for file: " + xmlFile);
            }
        }

        private void initIdMaps() throws IOException {
            for (MzMLElement element : MzMLElement.values()) {
                if (!element.isIdMapped() || !element.isIndexed()) continue;
                logger.debug("Initialising ID map for " + element.getClazz().getName());
                LinkedHashMap<String, IndexElement> map = this.idMapCache.get(element.getClazz());
                if (map == null) {
                    map = new LinkedHashMap();
                    this.idMapCache.put(element.getClazz(), map);
                }
                this.initIdMapCache(map, this.root + this.checkRoot(element.getXpath()));
            }
        }

        @Override
        public String getMzMLAttributeXMLString() {
            return this.mzMLAttributeXMLString;
        }

        private String extractMzMLStartTag(File xmlFile) throws IOException {
            long stopPos;
            List<IndexElement> ie = this.index.getElements(this.root + this.checkRoot(MzMLElement.MzML.getXpath()));
            long startPos = ie.get(0).getStart();
            String startTag = this.xmlExtractor.readString(startPos, stopPos = (ie = this.index.getElements(this.root + this.checkRoot(MzMLElement.CVList.getXpath()))).get(0).getStart() - 1L, xmlFile);
            if (startTag != null) {
                startTag = startTag.replace("\n", "");
            }
            return startTag;
        }

        @Override
        public String getStartTag(String xpath) {
            List<IndexElement> elements = this.index.getElements(this.root + this.checkRoot(xpath));
            String tag = "";
            try {
                tag = this.xpathAccess.getStartTag(elements.get(0));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return tag;
        }

        @Override
        public String getStartTag(String id, Class clazz) {
            IndexElement element;
            logger.debug("Getting start tag of element with id: " + id + " for class: " + clazz);
            String tag = null;
            Map idMap = this.idMapCache.get(clazz);
            if (idMap != null && (element = (IndexElement)idMap.get(id)) != null) {
                try {
                    tag = this.xpathAccess.getStartTag(element);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return tag;
        }

        private void initIdMapCache(HashMap<String, IndexElement> idMap, String xpath) throws IOException {
            List<IndexElement> ranges = this.index.getElements(xpath);
            for (IndexElement byteRange : ranges) {
                Integer index;
                String xml = this.xpathAccess.getStartTag(byteRange);
                String id = this.getIdFromRawXML(xml);
                if (id == null) {
                    throw new IllegalStateException("Error initializing ID cache: No id attribute found for element " + xml);
                }
                idMap.put(id, byteRange);
                if (!xpath.equalsIgnoreCase(this.root + this.checkRoot(MzMLElement.Spectrum.getXpath())) || (index = this.getIndexFromRawXML(xml)) == null) continue;
                this.spectrumIndexToIDMap.put(index, id);
            }
        }

        private String getIdFromRawXML(String xml) {
            Matcher match = ID_PATTERN.matcher(xml);
            if (match.find()) {
                return match.group(1).intern();
            }
            throw new IllegalStateException("Invalid ID in xml: " + xml);
        }

        private Integer getIndexFromRawXML(String xml) {
            Matcher match = INDEX_PATTERN.matcher(xml);
            if (match.find()) {
                String result = match.group(1).intern();
                try {
                    return new Integer(result);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalStateException("Index attribute could not be parsed into an integer in xml: " + xml);
                }
            }
            throw new IllegalStateException("Invalid index in xml: " + xml);
        }

        @Override
        public Set<String> getSpectrumIDs() {
            return this.idMapCache.get(Spectrum.class).keySet();
        }

        @Override
        public Set<Integer> getSpectrumIndexes() {
            return this.spectrumIndexToIDMap.keySet();
        }

        @Override
        public String getSpectrumIDFromSpectrumIndex(Integer aIndex) {
            return this.spectrumIndexToIDMap.get(aIndex);
        }

        @Override
        public Set<String> getChromatogramIDs() {
            return this.idMapCache.get(Chromatogram.class).keySet();
        }

        @Override
        public Iterator<String> getXmlStringIterator(String xpathExpression) {
            if (xpathExpression.contains("indexList") || xpathExpression.contains("fileChecksum")) {
                return this.xpathAccess.getXmlSnippetIterator(this.checkRoot(this.root + xpathExpression));
            }
            return this.xpathAccess.getXmlSnippetIterator(this.root + this.checkRoot(xpathExpression));
        }

        private String checkRoot(String xpathExpression) {
            String unrootedXpath = xpathExpression;
            if (unrootedXpath.startsWith("/indexedmzML")) {
                unrootedXpath = unrootedXpath.substring("/indexedmzML".length());
                logger.debug("removed /indexedmzML root expression");
            }
            if (unrootedXpath.startsWith("/mzML")) {
                unrootedXpath = unrootedXpath.substring("/mzML".length());
                logger.debug("removed /mzML root expression");
            }
            return unrootedXpath;
        }

        @Override
        public String getXmlString(String ID2, Class clazz) {
            logger.debug("Getting cached ID: " + ID2 + " from cache: " + clazz);
            HashMap idMap = this.idMapCache.get(clazz);
            IndexElement element = (IndexElement)idMap.get(ID2);
            String xmlSnippet = null;
            if (element != null) {
                xmlSnippet = this.readXML(element);
                if (logger.isTraceEnabled()) {
                    logger.trace("Retrieved xml for class " + clazz + " with ID " + ID2 + ": " + xmlSnippet);
                }
            }
            return xmlSnippet;
        }

        @Override
        public String getXmlString(IndexElement indexElement) {
            String xmlSnippet = null;
            if (indexElement != null) {
                xmlSnippet = this.readXML(indexElement);
            }
            return xmlSnippet;
        }

        private String readXML(IndexElement byteRange) {
            return this.readXML(byteRange, 0);
        }

        private String readXML(IndexElement byteRange, int maxChars) {
            try {
                if (byteRange != null) {
                    long limitedStop = byteRange.getStart() + (long)maxChars;
                    long stop = maxChars > 0 && byteRange.getStop() > limitedStop ? limitedStop : byteRange.getStop();
                    return this.xmlExtractor.readString(byteRange.getStart(), stop, this.xmlFile);
                }
                throw new IllegalStateException("Attempting to read NULL ByteRange");
            }
            catch (IOException e) {
                logger.error("MzMLIndexerFactory$MzMlIndexerImpl.readXML", e);
                throw new IllegalStateException("Could not extract XML from file: " + this.xmlFile);
            }
        }

        @Override
        public int getCount(String xpathExpression) {
            int retval = -1;
            List<IndexElement> tmpList = this.index.getElements(this.root + this.checkRoot(xpathExpression));
            if (tmpList != null) {
                retval = tmpList.size();
            }
            return retval;
        }

        @Override
        public String getXmlString(String xpath, long offset) {
            String retVal = null;
            List<IndexElement> indexElements = this.index.getElements(xpath);
            for (IndexElement indexElement : indexElements) {
                if (indexElement.getStart() != offset) continue;
                try {
                    retVal = this.xmlExtractor.readString(indexElement.getStart(), indexElement.getStop(), this.xmlFile);
                    break;
                }
                catch (IOException ioe) {
                    logger.error("MzMLIndexerFactory$MzMlIndexerImpl.getXmlString(xpath, offset)", ioe);
                    throw new IllegalStateException("Could not extract XML from file: " + this.xmlFile);
                }
            }
            return retVal;
        }

        @Override
        public List<IndexElement> getIndexElements(String xpathExpression) {
            return this.index.getElements(xpathExpression);
        }

        @Override
        public Set<String> getXpath() {
            return this.index.getKeys();
        }
    }
}

