/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jaxb.model;

import java.io.Serializable;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;
import uk.ac.ebi.pride.jaxb.model.Data;
import uk.ac.ebi.pride.jaxb.model.IntenArrayBinary;
import uk.ac.ebi.pride.jaxb.model.MzArrayBinary;
import uk.ac.ebi.pride.jaxb.model.PrideXmlObject;
import uk.ac.ebi.pride.jaxb.model.SpectrumDesc;
import uk.ac.ebi.pride.jaxb.model.SupDataArray;
import uk.ac.ebi.pride.jaxb.model.SupDataBinary;
import uk.ac.ebi.pride.jaxb.model.SupDesc;
import uk.ac.ebi.pride.jaxb.utils.BinaryDataUtils;
import uk.ac.ebi.pride.jaxb.utils.CvTermReference;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="spectrumType", propOrder={"spectrumDesc", "supDesc", "mzArrayBinary", "intenArrayBinary", "supDataArrayBinaryOrSupDataArray"})
public class Spectrum
implements Serializable,
PrideXmlObject {
    private static final long serialVersionUID = 100L;
    @XmlElement(required=true)
    private SpectrumDesc spectrumDesc;
    private List<SupDesc> supDesc;
    @XmlElement(required=true)
    private MzArrayBinary mzArrayBinary;
    @XmlElement(required=true)
    private IntenArrayBinary intenArrayBinary;
    @XmlElements(value={@XmlElement(name="supDataArray", type=SupDataArray.class), @XmlElement(name="supDataArrayBinary", type=SupDataBinary.class)})
    private List<PrideXmlObject> supDataArrayBinaryOrSupDataArray;
    @XmlAttribute(required=true)
    private int id;

    public SpectrumDesc getSpectrumDesc() {
        return this.spectrumDesc;
    }

    public void setSpectrumDesc(SpectrumDesc value) {
        this.spectrumDesc = value;
    }

    public List<SupDesc> getSupDesc() {
        if (this.supDesc == null) {
            this.supDesc = new ArrayList<SupDesc>();
        }
        return this.supDesc;
    }

    public MzArrayBinary getMzArrayBinary() {
        return this.mzArrayBinary;
    }

    public Number[] getMzNumberArray() {
        return this.getNumberArray(this.mzArrayBinary.getData());
    }

    public void setMzArrayBinary(MzArrayBinary value) {
        this.mzArrayBinary = value;
    }

    public IntenArrayBinary getIntenArrayBinary() {
        return this.intenArrayBinary;
    }

    public Number[] getIntentArray() {
        return this.getNumberArray(this.intenArrayBinary.getData());
    }

    private Number[] getNumberArray(Data rawData) {
        byte[] binary = rawData.getValue();
        CvTermReference dataType = "32".equals(rawData.getPrecision()) ? CvTermReference.FLOAT_32_BIT : CvTermReference.FLOAT_64_BIT;
        ByteOrder order = "big".equals(rawData.getEndian()) ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        return BinaryDataUtils.toNumberArray(binary, dataType, order);
    }

    public void setIntenArrayBinary(IntenArrayBinary value) {
        this.intenArrayBinary = value;
    }

    public List<PrideXmlObject> getSupDataArrayBinaryOrSupDataArray() {
        if (this.supDataArrayBinaryOrSupDataArray == null) {
            this.supDataArrayBinaryOrSupDataArray = new ArrayList<PrideXmlObject>();
        }
        return this.supDataArrayBinaryOrSupDataArray;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int value) {
        this.id = value;
    }
}

