/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.tools.dta_parser.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.tools.jmzreader.JMzReaderException;
import uk.ac.ebi.pride.tools.jmzreader.model.Spectrum;
import uk.ac.ebi.pride.tools.jmzreader.model.impl.ParamGroup;

public class DtaSpectrum
implements Spectrum {
    private File sourceFile;
    private Integer charge;
    private Integer index;
    private Double mhMass;
    private HashMap<Double, Double> peakList;
    public static final Logger logger = LoggerFactory.getLogger(DtaSpectrum.class);

    public DtaSpectrum(File sourceFile) throws JMzReaderException {
        ArrayList<String> lines = new ArrayList<String>();
        this.sourceFile = sourceFile;
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(sourceFile)));
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            this.parseDtaSection(lines);
        }
        catch (IOException e) {
            throw new JMzReaderException("Failed to read from file.", e);
        }
    }

    public DtaSpectrum(String dtaFileSection, int index) throws JMzReaderException {
        String[] lines = dtaFileSection.trim().split("\n");
        ArrayList<String> lineArray = new ArrayList<String>(lines.length);
        for (String line : lines) {
            if (line.startsWith("=") || line.startsWith("#")) continue;
            lineArray.add(line);
        }
        this.index = index;
        this.parseDtaSection(lineArray);
    }

    private void parseDtaSection(List<String> lines) throws JMzReaderException {
        this.peakList = new HashMap();
        if (lines.size() < 2) {
            throw new JMzReaderException("Invalid DTA section passed to generate DTA spectrum object. DTA section contains to few lines.");
        }
        String[] headerFields = lines.get(0).split("\\s+");
        if (headerFields.length < 2) {
            throw new JMzReaderException("Invalid header section encountered in DTA spectrum.");
        }
        this.mhMass = Double.parseDouble(headerFields[0]);
        try {
            this.charge = Integer.parseInt(headerFields[1]);
        }
        catch (NumberFormatException e) {
            throw new JMzReaderException("Invalid spectrum header line encountered. Charge state is not an integer: " + lines.get(0), e);
        }
        for (int nLineNumber = 1; nLineNumber < lines.size(); ++nLineNumber) {
            String[] fields = lines.get(nLineNumber).split("\\s+");
            if (fields.length != 2) {
                throw new JMzReaderException("Invalid line encountered in DTA spectrum");
            }
            this.peakList.put(Double.parseDouble(fields[0]), Double.parseDouble(fields[1]));
        }
    }

    @Override
    public Double getPrecursorMZ() {
        return (this.mhMass + 1.008 * (double)(this.charge - 1)) / (double)this.charge.intValue();
    }

    @Override
    public String getId() {
        return this.sourceFile != null ? this.sourceFile.getName() : this.index.toString();
    }

    @Override
    public Integer getPrecursorCharge() {
        return this.charge;
    }

    @Override
    public Double getPrecursorIntensity() {
        return null;
    }

    public Double getMhMass() {
        return this.mhMass;
    }

    @Override
    public Map<Double, Double> getPeakList() {
        return this.peakList;
    }

    @Override
    public Integer getMsLevel() {
        return 2;
    }

    @Override
    public ParamGroup getAdditional() {
        return new ParamGroup();
    }
}

