/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.tools.ms2_parser.model;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.ebi.pride.tools.jmzreader.JMzReaderException;
import uk.ac.ebi.pride.tools.jmzreader.model.Spectrum;
import uk.ac.ebi.pride.tools.jmzreader.model.impl.ParamGroup;
import uk.ac.ebi.pride.tools.jmzreader.model.impl.UserParam;

public class Ms2Spectrum
implements Spectrum {
    private int lowScan;
    private int highScan;
    private Double precursorMZ;
    private HashMap<String, String> additionalInformation;
    private HashMap<Integer, Double> charges;
    private HashMap<String, String> chargeDependentData;
    private Map<Double, Double> peakList;
    private static Pattern headerLinePattern = Pattern.compile("([SIZD])\t(.+)");
    private Integer index;

    public Ms2Spectrum(String ms2SpectrumInformation, int index) throws JMzReaderException {
        String[] lines = ms2SpectrumInformation.split("\\n");
        int dataOffset = this.parseHeader(lines);
        this.parsePeakList(lines, dataOffset);
        this.index = index;
    }

    private int parseHeader(String[] lines) throws JMzReaderException {
        Matcher matcher;
        int i;
        this.additionalInformation = new HashMap();
        this.chargeDependentData = new HashMap();
        this.charges = new HashMap();
        for (i = 0; i < lines.length && (matcher = headerLinePattern.matcher(lines[i])).find(); ++i) {
            String[] fields;
            if (matcher.groupCount() != 2) {
                throw new JMzReaderException("Invalid spectrum header line encountered: '" + lines[i] + '\'');
            }
            if (i == 0 && !matcher.group(1).equals("S")) {
                throw new JMzReaderException("Spectra must start with a S line.");
            }
            if ("S".equals(matcher.group(1))) {
                fields = matcher.group(2).split("\t");
                if (fields.length != 3) {
                    throw new JMzReaderException("Invalid S line encountered in spectrum: '" + lines[i] + '\'');
                }
                this.lowScan = Integer.parseInt(fields[0]);
                this.highScan = Integer.parseInt(fields[1]);
                this.precursorMZ = Double.parseDouble(fields[2]);
                continue;
            }
            if ("I".equals(matcher.group(1))) {
                fields = matcher.group(2).split("\t");
                if (fields.length != 2) {
                    if (fields.length == 1) {
                        this.setField(this.additionalInformation, fields[0], "");
                        continue;
                    }
                    throw new JMzReaderException("Invalid I line encountered: " + lines[i] + '\'');
                }
                this.setField(this.additionalInformation, fields[0], fields[1]);
                continue;
            }
            if ("Z".equals(matcher.group(1))) {
                fields = matcher.group(2).split("\t");
                if (fields.length != 2) {
                    throw new JMzReaderException("Invalid Z line encountered: " + lines[i] + '\'');
                }
                this.charges.put(Integer.parseInt(fields[0]), Double.parseDouble(fields[1]));
                continue;
            }
            if (!"D".equals(matcher.group(1))) continue;
            fields = matcher.group(2).split("\t");
            if (fields.length != 2) {
                throw new JMzReaderException("Invalid D line encountered: " + lines[i] + '\'');
            }
            this.setField(this.chargeDependentData, fields[0], fields[1]);
        }
        return i;
    }

    private void parsePeakList(String[] lines, int nOffset) throws JMzReaderException {
        this.peakList = new HashMap<Double, Double>();
        for (int i = nOffset; i < lines.length; ++i) {
            String[] fields = lines[i].split("\\s+");
            if (fields.length < 2) {
                if (fields.length == 1 && fields[0].equalsIgnoreCase("")) continue;
                throw new JMzReaderException("Invalid peak line found: '" + lines[i] + '\'');
            }
            this.peakList.put(Double.parseDouble(fields[0]), Double.parseDouble(fields[1]));
        }
    }

    private void setField(HashMap<String, String> hashMap, String fieldName, String fieldValue) {
        if (hashMap.containsKey(fieldName)) {
            int fieldNumber = 1;
            while (hashMap.containsKey(fieldName + '_' + fieldNumber)) {
                ++fieldNumber;
            }
            fieldName = fieldName + '_' + fieldNumber;
        }
        hashMap.put(fieldName, fieldValue);
    }

    public int getLowScan() {
        return this.lowScan;
    }

    public int getHighScan() {
        return this.highScan;
    }

    @Override
    public Double getPrecursorMZ() {
        return this.precursorMZ;
    }

    @Override
    public String getId() {
        return this.index.toString();
    }

    @Override
    public Integer getPrecursorCharge() {
        if (this.charges.size() == 1) {
            return this.charges.keySet().iterator().next();
        }
        return null;
    }

    @Override
    public Double getPrecursorIntensity() {
        if (this.charges.size() == 1) {
            return this.charges.values().iterator().next();
        }
        return null;
    }

    public HashMap<String, String> getAdditionalInformation() {
        return this.additionalInformation;
    }

    public HashMap<Integer, Double> getCharges() {
        return this.charges;
    }

    public HashMap<String, String> getChargeDependentData() {
        return this.chargeDependentData;
    }

    @Override
    public Map<Double, Double> getPeakList() {
        return this.peakList;
    }

    @Override
    public Integer getMsLevel() {
        return 2;
    }

    @Override
    public ParamGroup getAdditional() {
        ParamGroup paramGroup = new ParamGroup();
        paramGroup.addParam(new UserParam("high scan", String.format("%d", this.highScan)));
        paramGroup.addParam(new UserParam("low scan", String.format("%d", this.lowScan)));
        for (Map.Entry<String, String> stringStringEntry : this.chargeDependentData.entrySet()) {
            paramGroup.addParam(new UserParam(stringStringEntry.getKey(), stringStringEntry.getValue()));
        }
        for (Map.Entry<String, String> stringStringEntry : this.additionalInformation.entrySet()) {
            paramGroup.addParam(new UserParam(stringStringEntry.getKey(), stringStringEntry.getValue()));
        }
        return paramGroup;
    }
}

