/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.tools.mzdata_wrapper;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import uk.ac.ebi.jmzml.MzMLElement;
import uk.ac.ebi.jmzml.model.mzml.BinaryDataArray;
import uk.ac.ebi.jmzml.model.mzml.BinaryDataArrayList;
import uk.ac.ebi.jmzml.model.mzml.CVParam;
import uk.ac.ebi.jmzml.model.mzml.PrecursorList;
import uk.ac.ebi.jmzml.model.mzml.UserParam;
import uk.ac.ebi.jmzml.xml.io.MzMLUnmarshaller;
import uk.ac.ebi.jmzml.xml.io.MzMLUnmarshallerException;
import uk.ac.ebi.pride.tools.jmzreader.JMzReader;
import uk.ac.ebi.pride.tools.jmzreader.JMzReaderException;
import uk.ac.ebi.pride.tools.jmzreader.model.IndexElement;
import uk.ac.ebi.pride.tools.jmzreader.model.Spectrum;
import uk.ac.ebi.pride.tools.jmzreader.model.impl.CvParam;
import uk.ac.ebi.pride.tools.jmzreader.model.impl.IndexElementImpl;
import uk.ac.ebi.pride.tools.jmzreader.model.impl.ParamGroup;

public class MzMlWrapper
implements JMzReader {
    private HashMap<String, psidev.psi.tools.xxindex.index.IndexElement> idToIndexElementMap;
    private HashMap<Integer, List<psidev.psi.tools.xxindex.index.IndexElement>> msNScans;
    private final MzMLUnmarshaller unmarshaller;
    private final List<String> spectraIds;

    public MzMlWrapper(File sourcefile) throws JMzReaderException {
        try {
            this.unmarshaller = new MzMLUnmarshaller(sourcefile);
            this.spectraIds = new ArrayList<String>(this.unmarshaller.getSpectrumIDs());
            this.initializeSpectrumMaps();
        }
        catch (RuntimeException e) {
            throw new JMzReaderException("Failed to parse mzML file.", e);
        }
    }

    private void initializeSpectrumMaps() {
        List<psidev.psi.tools.xxindex.index.IndexElement> spectra = this.unmarshaller.getMzMLIndexer().getIndexElements(MzMLElement.Spectrum.getXpath());
        this.idToIndexElementMap = new HashMap(spectra.size());
        this.msNScans = new HashMap(spectra.size());
        for (psidev.psi.tools.xxindex.index.IndexElement element : spectra) {
            uk.ac.ebi.jmzml.model.mzml.Spectrum spectrum = (uk.ac.ebi.jmzml.model.mzml.Spectrum)this.unmarshaller.unmarshalFromIndexElement(element, uk.ac.ebi.jmzml.model.mzml.Spectrum.class);
            this.idToIndexElementMap.put(spectrum.getId(), element);
            int msLevel = -1;
            for (CVParam param : spectrum.getCvParam()) {
                if (!param.getAccession().equals("MS:1000511")) continue;
                msLevel = Integer.parseInt(param.getValue());
            }
            if (!this.msNScans.containsKey(msLevel)) {
                this.msNScans.put(msLevel, new ArrayList());
            }
            this.msNScans.get(msLevel).add(element);
        }
    }

    @Override
    public int getSpectraCount() {
        return this.spectraIds.size();
    }

    @Override
    public boolean acceptsFile() {
        return true;
    }

    @Override
    public boolean acceptsDirectory() {
        return false;
    }

    @Override
    public List<String> getSpectraIds() {
        return this.spectraIds;
    }

    @Override
    public Spectrum getSpectrumById(String id) throws JMzReaderException {
        try {
            uk.ac.ebi.jmzml.model.mzml.Spectrum mzMlSpectrum = this.unmarshaller.getSpectrumById(id);
            return new MzMlWrapperSpectrum(mzMlSpectrum);
        }
        catch (MzMLUnmarshallerException e) {
            throw new JMzReaderException("Failed to load spectrum " + id + " from mzML file.", e);
        }
    }

    @Override
    public Spectrum getSpectrumByIndex(int index) throws JMzReaderException {
        if (index < 1 || index > this.spectraIds.size()) {
            throw new JMzReaderException("Index out of range.");
        }
        String id = this.spectraIds.get(index - 1);
        return this.getSpectrumById(id);
    }

    @Override
    public Iterator<Spectrum> getSpectrumIterator() {
        return new MzMLSpectrumIterator();
    }

    @Override
    public List<IndexElement> getMsNIndexes(int msLevel) {
        if (!this.msNScans.containsKey(msLevel)) {
            return Collections.emptyList();
        }
        return this.convertIndexElements(this.msNScans.get(msLevel));
    }

    @Override
    public List<Integer> getMsLevels() {
        return new ArrayList<Integer>(this.msNScans.keySet());
    }

    @Override
    public Map<String, IndexElement> getIndexElementForIds() {
        HashMap<String, IndexElement> idToIndex = new HashMap<String, IndexElement>(this.idToIndexElementMap.size());
        for (Map.Entry<String, psidev.psi.tools.xxindex.index.IndexElement> stringIndexElementEntry : this.idToIndexElementMap.entrySet()) {
            psidev.psi.tools.xxindex.index.IndexElement e = stringIndexElementEntry.getValue();
            int size = (int)(e.getStop() - e.getStart());
            idToIndex.put(stringIndexElementEntry.getKey(), new IndexElementImpl(e.getStart(), size));
        }
        return idToIndex;
    }

    private List<IndexElement> convertIndexElements(List<psidev.psi.tools.xxindex.index.IndexElement> index) {
        ArrayList<IndexElement> convertedIndex = new ArrayList<IndexElement>(index.size());
        for (psidev.psi.tools.xxindex.index.IndexElement e : index) {
            int size = (int)(e.getStop() - e.getStart());
            convertedIndex.add(new IndexElementImpl(e.getStart(), size));
        }
        return convertedIndex;
    }

    private class MzMlWrapperSpectrum
    implements Spectrum {
        private final String id;
        private final Integer charge;
        private final Double mz;
        private final Double intensity;
        private final Integer msLevel;
        private final Map<Double, Double> peakList;
        private final ParamGroup paramGroup;

        public MzMlWrapperSpectrum(uk.ac.ebi.jmzml.model.mzml.Spectrum mzMlSpectrum) throws JMzReaderException {
            this.id = mzMlSpectrum.getId();
            PrecursorList precursorList = mzMlSpectrum.getPrecursorList();
            if (precursorList == null || precursorList.getCount() < 1 || precursorList.getPrecursor().get(0).getSelectedIonList() == null) {
                this.mz = null;
                this.intensity = null;
                this.charge = null;
            } else {
                List<CVParam> selectionParams = precursorList.getPrecursor().get(0).getSelectedIonList().getSelectedIon().get(0).getCvParam();
                CVParam mzParam = this.getParamFromGroup(selectionParams, MZML_PARAMS.SELECTED_MZ.getAccess());
                this.mz = mzParam != null ? Double.valueOf(Double.parseDouble(mzParam.getValue())) : null;
                CVParam intensParam = this.getParamFromGroup(selectionParams, MZML_PARAMS.PEAK_INTENSITY.getAccess());
                this.intensity = intensParam != null ? Double.valueOf(Double.parseDouble(intensParam.getValue())) : null;
                CVParam chargeParam = this.getParamFromGroup(selectionParams, MZML_PARAMS.CHARGE_STATE.getAccess());
                this.charge = chargeParam != null ? Integer.valueOf(Integer.parseInt(chargeParam.getValue())) : null;
            }
            CVParam msLevelParam = this.getParamFromGroup(mzMlSpectrum.getCvParam(), MZML_PARAMS.MS_LEVEL.getAccess());
            this.msLevel = msLevelParam != null ? Integer.valueOf(Integer.parseInt(msLevelParam.getValue())) : null;
            this.peakList = this.convertPeakList(mzMlSpectrum.getBinaryDataArrayList());
            this.paramGroup = this.createParamGroup(mzMlSpectrum.getCvParam(), mzMlSpectrum.getUserParam());
        }

        private ParamGroup createParamGroup(List<CVParam> cvParam, List<UserParam> userParam) {
            ParamGroup paramGroup = new ParamGroup();
            if (cvParam != null) {
                for (CVParam cv : cvParam) {
                    paramGroup.addParam(new CvParam(cv.getName(), cv.getValue(), cv.getCvRef(), cv.getAccession()));
                }
            }
            if (userParam != null) {
                for (UserParam up : userParam) {
                    paramGroup.addParam(new uk.ac.ebi.pride.tools.jmzreader.model.impl.UserParam(up.getName(), up.getValue()));
                }
            }
            return paramGroup;
        }

        private Map<Double, Double> convertPeakList(BinaryDataArrayList binaryDataArrayList) throws JMzReaderException {
            BinaryDataArray mzArray = null;
            BinaryDataArray intenArray = null;
            for (BinaryDataArray array : binaryDataArrayList.getBinaryDataArray()) {
                for (CVParam param : array.getCvParam()) {
                    if (param.getAccession().equals("MS:1000514")) {
                        mzArray = array;
                        break;
                    }
                    if (!param.getAccession().equals("MS:1000515")) continue;
                    intenArray = array;
                    break;
                }
                if (mzArray == null || intenArray == null) continue;
                break;
            }
            if (mzArray == null || intenArray == null) {
                return Collections.emptyMap();
            }
            Number[] mzNumbers = mzArray.getBinaryDataAsNumberArray();
            ArrayList<Double> mzValues = new ArrayList<Double>(mzNumbers.length);
            for (Number n : mzNumbers) {
                mzValues.add(n.doubleValue());
            }
            Number[] intenNumbers = intenArray.getBinaryDataAsNumberArray();
            ArrayList<Double> intenValues = new ArrayList<Double>(intenNumbers.length);
            for (Number n : intenNumbers) {
                intenValues.add(n.doubleValue());
            }
            if (intenValues.size() != mzValues.size()) {
                throw new JMzReaderException("Different sizes for m/z and intensity value arrays for spectrum " + this.id);
            }
            HashMap<Double, Double> peakList = new HashMap<Double, Double>(mzNumbers.length);
            for (int i = 0; i < mzNumbers.length; ++i) {
                peakList.put((Double)mzValues.get(i), (Double)intenValues.get(i));
            }
            return peakList;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public Integer getPrecursorCharge() {
            return this.charge;
        }

        @Override
        public Double getPrecursorMZ() {
            return this.mz;
        }

        @Override
        public Double getPrecursorIntensity() {
            return this.intensity;
        }

        @Override
        public Map<Double, Double> getPeakList() {
            return this.peakList;
        }

        @Override
        public Integer getMsLevel() {
            return this.msLevel;
        }

        private CVParam getParamFromGroup(List<CVParam> params, String accession) {
            for (CVParam p : params) {
                if (!p.getAccession().equals(accession)) continue;
                return p;
            }
            return null;
        }

        @Override
        public ParamGroup getAdditional() {
            return this.paramGroup;
        }
    }

    private class MzMLSpectrumIterator
    implements Iterator<Spectrum> {
        private final Iterator<String> idIterator;

        private MzMLSpectrumIterator() {
            this.idIterator = MzMlWrapper.this.spectraIds.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.idIterator.hasNext();
        }

        @Override
        public Spectrum next() {
            try {
                return MzMlWrapper.this.getSpectrumById(this.idIterator.next());
            }
            catch (JMzReaderException e) {
                throw new RuntimeException("Failed to parse mzML spectrum.", e);
            }
        }

        @Override
        public void remove() {
        }
    }

    private static enum MZML_PARAMS {
        SELECTED_MZ("MS:1000744"),
        PEAK_INTENSITY("MS:1000042"),
        CHARGE_STATE("MS:1000041"),
        MS_LEVEL("MS:1000511");

        private final String accession;

        private MZML_PARAMS(String accession) {
            this.accession = accession;
        }

        public String getAccess() {
            return this.accession;
        }
    }
}

