/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.tools.pkl_parser.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.ac.ebi.pride.tools.jmzreader.JMzReaderException;
import uk.ac.ebi.pride.tools.jmzreader.model.Spectrum;
import uk.ac.ebi.pride.tools.jmzreader.model.impl.ParamGroup;

public class PklSpectrum
implements Spectrum {
    private File sourceFile;
    private int charge;
    private Double observedMZ;
    private Double observedIntensity;
    private Map<Double, Double> peakList;
    private Integer index;

    public PklSpectrum(File sourceFile) throws JMzReaderException {
        ArrayList<String> lines = new ArrayList<String>();
        this.sourceFile = sourceFile;
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(sourceFile)));
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            this.parsePklSection(lines);
        }
        catch (IOException e) {
            throw new JMzReaderException("Failed to read from file.", e);
        }
    }

    public PklSpectrum(String pklFileSection, int index) throws JMzReaderException {
        String[] lines = pklFileSection.trim().split("\n");
        ArrayList<String> lineArray = new ArrayList<String>(lines.length);
        Collections.addAll(lineArray, lines);
        this.index = index;
        this.parsePklSection(lineArray);
    }

    private void parsePklSection(List<String> lines) throws JMzReaderException {
        this.peakList = new HashMap<Double, Double>();
        if (lines.size() < 1) {
            throw new JMzReaderException("Invalid PKL section passed to generate PKL spectrum object. PKL section contains to few lines.");
        }
        String[] headerFields = lines.get(0).split("\\s+");
        if (headerFields.length != 3) {
            throw new JMzReaderException("Invalid header section encountered in PKL spectrum.");
        }
        this.observedMZ = Double.parseDouble(headerFields[0]);
        this.observedIntensity = Double.parseDouble(headerFields[1]);
        this.charge = Integer.parseInt(headerFields[2].replace(".0", ""));
        for (int nLineNumber = 1; nLineNumber < lines.size(); ++nLineNumber) {
            String[] fields = lines.get(nLineNumber).split("\\s+");
            if (fields.length != 2) {
                throw new JMzReaderException("Invalid line encountered in PKL spectrum");
            }
            this.peakList.put(Double.parseDouble(fields[0]), Double.parseDouble(fields[1]));
        }
    }

    public Double getObservedMZ() {
        return this.observedMZ;
    }

    public Double getObservedIntensity() {
        return this.observedIntensity;
    }

    @Override
    public Map<Double, Double> getPeakList() {
        return this.peakList;
    }

    @Override
    public String getId() {
        return this.sourceFile != null ? this.sourceFile.getName() : this.index.toString();
    }

    @Override
    public Integer getPrecursorCharge() {
        return this.charge;
    }

    @Override
    public Double getPrecursorMZ() {
        return this.getObservedMZ();
    }

    @Override
    public Double getPrecursorIntensity() {
        return this.getObservedIntensity();
    }

    @Override
    public Integer getMsLevel() {
        return 2;
    }

    public String toString() {
        StringBuilder string = new StringBuilder(String.format("%3.2f\t%3.2f\t%d\n", this.observedMZ, this.observedIntensity, this.charge));
        ArrayList<Double> masses = new ArrayList<Double>(this.peakList.keySet());
        Collections.sort(masses);
        for (Double mz : masses) {
            string.append(String.format("%3.2f\t%3.2f\n", mz, this.peakList.get(mz)));
        }
        return string.toString();
    }

    @Override
    public ParamGroup getAdditional() {
        return new ParamGroup();
    }
}

