/*
 * Decompiled with CFR 0.152.
 */
package no.uib.olsdialog.util;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import no.uib.olsdialog.OLSDialog;
import no.uib.olsdialog.util.Util;

public class TermHierarchyGraphViewer
extends JDialog {
    final int MAXIMUM_DIALOG_WIDTH = 600;
    final int MINIMUM_DIALOG_WIDTH = 250;
    final int MAXIMUM_DIALOG_HEIGHT = 600;
    final int VERTICAL_PADDING = 40;
    final int HORIZONTAL_PADDING = 40;
    private JScrollPane graphViewerScrollPane;

    public TermHierarchyGraphViewer(OLSDialog olsDialog, boolean modal, String termId, String termName, String ontology) {
        super((Dialog)olsDialog, modal);
        this.initComponents();
        this.setTitle("Term Hierarchy: " + termId);
        try {
            String inputLine;
            termId = termId.replace(":", "%3A");
            termName = termName.replace(" ", "_");
            termName = termName.toLowerCase();
            String url = "http://www.ebi.ac.uk/ontology-lookup/generateSSFiles.do?termId=" + termId + "&termName=" + termName + "&ontologyName=" + ontology + "&graphType=root";
            URL mapPage = new URL(url);
            BufferedReader in = new BufferedReader(new InputStreamReader(mapPage.openStream()));
            String contents = "";
            while ((inputLine = in.readLine()) != null) {
                contents = contents + inputLine;
            }
            String imageFile = contents.substring(contents.lastIndexOf("<imgFile>") + "<imgFile>".length(), contents.lastIndexOf("</imgFile>"));
            URL imageUrlAsUrl = new URL("http://www.ebi.ac.uk/ontology-lookup/serveImgFile.do?imgFileName=" + imageFile);
            Toolkit.getDefaultToolkit();
            Image image = Toolkit.getDefaultToolkit().createImage(imageUrlAsUrl);
            ImageIcon ii = new ImageIcon(image);
            JLabel label = new JLabel(ii);
            label.setBackground(Color.WHITE);
            label.setOpaque(true);
            int width = ii.getIconWidth() + 40;
            int height = ii.getIconHeight() + 40;
            label.setPreferredSize(new Dimension(width, height));
            this.graphViewerScrollPane = new JScrollPane(label);
            this.graphViewerScrollPane.setBackground(Color.WHITE);
            this.graphViewerScrollPane.setOpaque(true);
            this.getContentPane().add(this.graphViewerScrollPane);
            if (width > 600) {
                width = 600;
            } else if (width < 250) {
                width = 250;
            }
            if (height > 600) {
                height = 600;
            }
            this.setSize(width + 50, height + 50);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TermHierarchyGraphViewer.this.graphViewerScrollPane.getVerticalScrollBar().setValue(TermHierarchyGraphViewer.this.graphViewerScrollPane.getVerticalScrollBar().getMaximum());
                }
            });
        }
        catch (MalformedURLException e) {
            JOptionPane.showMessageDialog(olsDialog, "An error occured when opening the term hierarcy.", "Error Opening Term Hierarcy", 0);
            Util.writeToErrorLog("Error Opening Term Hierarcy: ");
            e.printStackTrace();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(olsDialog, "An error occured when opening the term hierarcy.", "Error Opening Term Hierarcy", 0);
            Util.writeToErrorLog("Error Opening Term Hierarcy: ");
            e.printStackTrace();
        }
        this.setLocationRelativeTo(olsDialog);
        this.setVisible(true);
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setTitle("Term Hierarchy");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 2));
        this.pack();
    }
}

