/*
 * Decompiled with CFR 0.152.
 */
package no.uib.olsdialog.util;

import java.awt.Cursor;
import java.awt.GridLayout;
import java.util.Enumeration;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import no.uib.olsdialog.OLSDialog;

public class TreeBrowser
extends JPanel
implements TreeSelectionListener,
TreeModelListener,
TreeExpansionListener {
    protected DefaultMutableTreeNode rootNode;
    protected DefaultTreeModel treeModel;
    protected JTree tree;
    private OLSDialog olsDialog;
    private static JScrollPane scrollPane;

    public TreeBrowser(OLSDialog parent) {
        super(new GridLayout(1, 0));
        this.olsDialog = parent;
        this.tree = new JTree(new DefaultTreeModel(new DefaultMutableTreeNode(new TermNode("Load Ontology to Browse", null))));
        this.tree.setEditable(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(true);
        this.tree.addTreeSelectionListener(this);
        scrollPane = new JScrollPane(this.tree);
        this.add(scrollPane);
    }

    public void scrollToTop() {
        scrollPane.getVerticalScrollBar().setValue(0);
        scrollPane.getHorizontalScrollBar().setValue(0);
    }

    public void initialize(String ontologyName) {
        this.rootNode = new DefaultMutableTreeNode(new TermNode(ontologyName, null));
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.treeModel.addTreeModelListener(this);
        this.tree.addTreeExpansionListener(this);
        this.tree.setModel(this.treeModel);
    }

    public void clear() {
        this.rootNode.removeAllChildren();
        this.treeModel.reload();
    }

    public void updateTree() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        TreePath path = new TreePath(root.getPath());
        this.tree.collapsePath(path);
        this.tree.expandPath(path);
    }

    public DefaultMutableTreeNode addNode(Object termId, Object termName) {
        TreePath parentPath = this.tree.getSelectionPath();
        DefaultMutableTreeNode parentNode = parentPath == null ? this.rootNode : (DefaultMutableTreeNode)parentPath.getLastPathComponent();
        return this.addNode(parentNode, termId, termName, true);
    }

    public DefaultMutableTreeNode addNode(DefaultMutableTreeNode parent, Object termId, Object termName, boolean shouldBeVisible) {
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(new TermNode(termName.toString(), termId.toString()));
        if (parent == null) {
            parent = this.rootNode;
        }
        this.treeModel.insertNodeInto(childNode, parent, parent.getChildCount());
        if (shouldBeVisible) {
            this.tree.scrollPathToVisible(new TreePath(childNode.getPath()));
        }
        return childNode;
    }

    public void treeNodesChanged(TreeModelEvent e) {
    }

    public void treeNodesInserted(TreeModelEvent e) {
    }

    public void treeNodesRemoved(TreeModelEvent e) {
    }

    public void treeStructureChanged(TreeModelEvent e) {
    }

    public void valueChanged(TreeSelectionEvent e) {
        this.olsDialog.setCursor(new Cursor(3));
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
        if (node == null) {
            return;
        }
        int verticalScrollBarValue = scrollPane.getVerticalScrollBar().getValue();
        int horizontalScrollBarValue = scrollPane.getHorizontalScrollBar().getValue();
        TermNode nodeInfo = (TermNode)node.getUserObject();
        if (nodeInfo.getTermId() != null && !nodeInfo.getTermId().equalsIgnoreCase("No Root Terms Defined!")) {
            if (node.isLeaf() && node.getAllowsChildren() && !this.olsDialog.loadChildren(node, nodeInfo.getTermId())) {
                node.setAllowsChildren(false);
            }
            scrollPane.getVerticalScrollBar().setValue(verticalScrollBarValue);
            scrollPane.getHorizontalScrollBar().setValue(horizontalScrollBarValue);
            this.olsDialog.loadMetaData(nodeInfo.getTermId(), OLSDialog.OLS_DIALOG_BROWSE_ONTOLOGY);
        } else {
            this.olsDialog.clearData(OLSDialog.OLS_DIALOG_BROWSE_ONTOLOGY, true, true);
        }
        this.olsDialog.setCursor(new Cursor(0));
    }

    public void treeExpanded(TreeExpansionEvent event) {
        this.olsDialog.setCursor(new Cursor(3));
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
        if (node == null) {
            return;
        }
        Enumeration<TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (currentNode.getChildCount() != 0) continue;
            TermNode nodeInfo = (TermNode)currentNode.getUserObject();
            this.olsDialog.addSecondLevelOfNodes(nodeInfo.getTermId(), this.olsDialog.getCurrentOntologyLabel(), currentNode);
        }
        this.olsDialog.setCursor(new Cursor(0));
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    private class TermNode {
        private String termName;
        private String termId;

        public TermNode(String termName, String termId) {
            this.termName = termName;
            this.termId = termId;
        }

        public String getTermName() {
            return this.termName;
        }

        public void setTermName(String termName) {
            this.termName = termName;
        }

        public String getTermId() {
            return this.termId;
        }

        public void setTermId(String termId) {
            this.termId = termId;
        }

        public String toString() {
            return (this.termId == null ? "" : "[" + this.termId + "] ") + this.termName;
        }
    }
}

