/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.cpdetector;

import info.monitorenter.cpdetector.ACmdLineArgsInheritor;
import info.monitorenter.cpdetector.io.CodepageDetectorProxy;
import info.monitorenter.cpdetector.io.FileFilterExtensions;
import info.monitorenter.cpdetector.io.ICodepageDetector;
import info.monitorenter.cpdetector.io.JChardetFacade;
import info.monitorenter.cpdetector.io.ParsingDetector;
import info.monitorenter.cpdetector.io.UnsupportedCharset;
import info.monitorenter.cpdetector.reflect.SingletonLoader;
import info.monitorenter.cpdetector.util.FileUtil;
import jargs.gnu.CmdLineParser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;

public class CodepageProcessor
extends ACmdLineArgsInheritor {
    protected File collectionRoot = null;
    protected CodepageDetectorProxy detector = CodepageDetectorProxy.getInstance();
    private Charset[] parseCodepages;
    private static String fileseparator = System.getProperty("file.separator");
    private FileFilter extensionFilter;
    private File outputDir;
    private boolean moveUnknown = false;
    private boolean printCharsets = false;
    private boolean verbose = false;
    private long wait = 0L;
    private Charset targetCodepage = null;
    private static char[] transcodeBuffer = new char[1024];
    private static byte[] rawtransportBuffer = new byte[1024];

    public CodepageProcessor() {
        this.addCmdLineOption("documents", (CmdLineParser.Option)new CmdLineParser.Option.StringOption('r', "documents"));
        this.addCmdLineOption("extensions", (CmdLineParser.Option)new CmdLineParser.Option.StringOption('e', "extensions"));
        this.addCmdLineOption("outputDir", (CmdLineParser.Option)new CmdLineParser.Option.StringOption('o', "outputDir"));
        this.addCmdLineOption("moveUnknown", (CmdLineParser.Option)new CmdLineParser.Option.BooleanOption('m', "moveUnknown"));
        this.addCmdLineOption("verbose", (CmdLineParser.Option)new CmdLineParser.Option.BooleanOption('v', "verbose"));
        this.addCmdLineOption("wait", (CmdLineParser.Option)new CmdLineParser.Option.IntegerOption('w', "wait"));
        this.addCmdLineOption("transform", (CmdLineParser.Option)new CmdLineParser.Option.StringOption('t', "transform"));
        this.addCmdLineOption("detectors", (CmdLineParser.Option)new CmdLineParser.Option.StringOption('d', "detectors"));
        this.addCmdLineOption("charsets", (CmdLineParser.Option)new CmdLineParser.Option.BooleanOption('c', "charsets"));
    }

    public void parseArgs(String[] cmdLineArgs) throws Exception {
        super.parseArgs(cmdLineArgs);
        Object collectionOption = this.getParsedCmdLineOption("documents");
        Object extensionsOption = this.getParsedCmdLineOption("extensions");
        Object outputDirOption = this.getParsedCmdLineOption("outputDir");
        Object moveUnknownOption = this.getParsedCmdLineOption("moveUnknown");
        Object verboseOption = this.getParsedCmdLineOption("verbose");
        Object waitOption = this.getParsedCmdLineOption("wait");
        Object transformOption = this.getParsedCmdLineOption("transform");
        Object detectorOption = this.getParsedCmdLineOption("detectors");
        Object charsetsOption = this.getParsedCmdLineOption("charsets");
        if (charsetsOption != null) {
            this.printCharsets = (Boolean)charsetsOption;
        } else {
            if (collectionOption == null) {
                this.usage();
                throw new MissingResourceException("Parameter for collection root directory is missing.", "String", "-r");
            }
            this.collectionRoot = new File(collectionOption.toString());
            if (outputDirOption == null) {
                this.usage();
                throw new MissingResourceException("Parameter for output directory is missing.", "String", "-o");
            }
            this.outputDir = new File(outputDirOption.toString());
            this.extensionFilter = extensionsOption != null ? new FileFilterExtensions(this.parseCSVList(extensionsOption.toString())) : new FileFilter(){

                public boolean accept(File f) {
                    return true;
                }
            };
            if (moveUnknownOption != null) {
                this.moveUnknown = true;
            }
            if (verboseOption != null && ((Boolean)verboseOption).booleanValue()) {
                this.verbose = true;
            }
            if (waitOption != null) {
                this.wait = (Integer)waitOption * 1000;
            }
            if (transformOption != null) {
                String charset = (String)transformOption;
                try {
                    this.targetCodepage = Charset.forName(charset);
                }
                catch (Exception e) {
                    StringBuffer msg = new StringBuffer();
                    msg.append("Given charset name: \"");
                    msg.append(charset);
                    msg.append("\" for option -t is illegal: \n");
                    msg.append("  ");
                    msg.append(e.getMessage());
                    msg.append("\n");
                    msg.append("   Legal values are: \n");
                    for (int i = 0; i < this.parseCodepages.length; ++i) {
                        msg.append("    ");
                        msg.append(this.parseCodepages[i].name());
                        msg.append("\n");
                    }
                    throw new IllegalArgumentException(msg.toString());
                }
            }
            if (detectorOption != null) {
                String[] detectors = this.parseCSVList((String)detectorOption);
                if (detectors.length == 0) {
                    StringBuffer msg = new StringBuffer();
                    msg.append("You specified the codepage detector argument \"-d\" but ommited any comma-separated fully qualified class-name.");
                    throw new IllegalArgumentException(msg.toString());
                }
                ICodepageDetector cpDetector = null;
                for (int i = 0; i < detectors.length; ++i) {
                    try {
                        cpDetector = (ICodepageDetector)SingletonLoader.getInstance().newInstance(detectors[i]);
                        if (cpDetector == null) continue;
                        this.detector.add(cpDetector);
                        continue;
                    }
                    catch (InstantiationException ie) {
                        System.err.println("Could not instantiate custom ICodepageDetector: " + detectors[i] + " (argument \"-c\"): " + ie.getMessage());
                    }
                }
            } else {
                this.detector.add(new ParsingDetector(this.verbose));
                this.detector.add(JChardetFacade.getInstance());
            }
            this.loadCodepages();
        }
    }

    private void printCharsets() {
        if (this.parseCodepages == null || this.parseCodepages.length == 0) {
            this.loadCodepages();
        }
        for (int i = 0; i < this.parseCodepages.length; ++i) {
            Charset cs = this.parseCodepages[i];
            System.out.println("  " + cs.name() + ":");
            Set<String> aliases = cs.aliases();
            Iterator<String> itAliases = aliases.iterator();
            while (itAliases.hasNext()) {
                System.out.println("    " + itAliases.next().toString());
            }
        }
    }

    private final String[] parseCSVList(String listLiteral) {
        if (listLiteral == null) {
            return null;
        }
        LinkedList<String> tmpList = new LinkedList<String>();
        StringTokenizer tok = new StringTokenizer(listLiteral, ";,");
        while (tok.hasMoreElements()) {
            tmpList.add(tok.nextToken());
        }
        return tmpList.toArray(new String[tmpList.size()]);
    }

    private void processRecursive(File f) throws Exception {
        if (f == null) {
            throw new IllegalArgumentException("File argument is null!");
        }
        if (!f.exists()) {
            throw new IllegalArgumentException(f.getAbsolutePath() + " does not exist.");
        }
        if (f.isDirectory()) {
            File[] childs = f.listFiles();
            for (int i = childs.length - 1; i >= 0; --i) {
                this.processRecursive(childs[i]);
            }
        } else if (this.extensionFilter.accept(f)) {
            this.process(f);
        }
    }

    public final void process() throws Exception {
        if (this.printCharsets) {
            this.printCharsets();
        } else {
            this.verifyFiles();
            this.describe();
            this.processRecursive(this.collectionRoot);
        }
        System.out.println("No exceptional program flow occured!");
    }

    protected void verifyFiles() throws IllegalArgumentException {
        StringBuffer msg = new StringBuffer();
        if (this.collectionRoot == null) {
            msg.append("-> Collection root directory is null!\n");
        } else if (!this.collectionRoot.exists()) {
            msg.append("-> Collection root directory:\"");
            msg.append(this.collectionRoot.getAbsolutePath());
            msg.append("\" does not exist!\n");
        }
        if (this.outputDir == null) {
            msg.append("-> Output directory is null!\n");
        } else {
            this.outputDir.mkdirs();
            if (!this.outputDir.isDirectory()) {
                msg.append("-> Output directory has to be a directory, no File!\n");
            }
        }
        if (msg.length() > 0) {
            throw new IllegalArgumentException(msg.toString());
        }
        System.out.println("All parameters are valid.");
    }

    private void process(File document) throws Exception {
        Charset charset = null;
        try {
            Thread.sleep(this.wait);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Map.Entry filenameFinder = FileUtil.cutDirectoryInformation(document.getAbsolutePath());
        String prefix = document.getAbsolutePath();
        int stop = prefix.lastIndexOf(fileseparator);
        int start = this.collectionRoot.getAbsolutePath().length();
        prefix = start > stop ? "" : prefix.substring(this.collectionRoot.getAbsolutePath().length(), stop + 1);
        if (this.verbose) {
            System.out.println("Processing document: " + prefix + "/" + filenameFinder.getValue());
        }
        if ((charset = this.detector.detectCodepage(document.toURL())) == null) {
            if (this.verbose) {
                System.out.println("  Charset not detected.");
            }
            if (!this.moveUnknown) {
                if (this.verbose) {
                    System.out.println("  Dropping document.");
                }
                return;
            }
            charset = UnsupportedCharset.forName("unknown");
        }
        if (this.targetCodepage != null) {
            File target = prefix.length() > 0 ? new File(this.outputDir.getAbsolutePath() + "/" + this.targetCodepage.name() + "/" + prefix + "/") : new File(this.outputDir.getAbsolutePath() + "/" + this.targetCodepage.name() + "/");
            if (target.mkdirs() && this.verbose) {
                System.out.println("  Created directory : " + target.getAbsolutePath());
            }
            target = new File(target.getAbsolutePath() + "/" + filenameFinder.getValue());
            if (this.verbose) {
                System.out.println("  Moving to \"" + target.getAbsolutePath() + "\".");
            }
            if (target.exists() && target.length() == document.length()) {
                if (this.verbose) {
                    System.out.println("  File already exists and has same size. Skipping move.");
                }
            } else {
                int len;
                target.createNewFile();
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(document), charset));
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(target), this.targetCodepage));
                int toRead = transcodeBuffer.length;
                while ((len = ((Reader)in).read(transcodeBuffer, 0, toRead)) != -1) {
                    ((Writer)out).write(transcodeBuffer, 0, len);
                }
                ((Reader)in).close();
                ((Writer)out).close();
            }
        } else {
            File target = prefix.length() > 0 ? new File(this.outputDir.getAbsolutePath() + "/" + charset.name().toLowerCase() + "/" + prefix + "/") : new File(this.outputDir.getAbsolutePath() + "/" + charset.name().toLowerCase() + "/");
            if (target.mkdirs() && this.verbose) {
                System.out.println("Created directory : " + target.getAbsolutePath());
            }
            target = new File(target.getAbsolutePath() + "/" + filenameFinder.getValue());
            if (this.verbose) {
                System.out.println("  Moving to \"" + target.getAbsolutePath() + "\".");
            }
            this.rawCopy(document, target);
        }
    }

    private void rawCopy(File from, File to) throws IOException {
        int len;
        if (to.exists()) {
            if (from.length() == to.length()) {
                return;
            }
        } else {
            to.createNewFile();
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(from));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(to));
        int toRead = rawtransportBuffer.length;
        while ((len = ((InputStream)in).read(rawtransportBuffer, 0, toRead)) != -1) {
            ((OutputStream)out).write(rawtransportBuffer, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    protected void describe() {
        StringBuffer msg = new StringBuffer();
        msg.append("Setup:\n");
        msg.append("  Collection-Root        : ");
        msg.append(this.collectionRoot.getAbsolutePath());
        msg.append("\n");
        msg.append("  Output-Dir             : ");
        msg.append(this.outputDir.getAbsolutePath());
        msg.append("\n");
        msg.append("  Move unknown           : ");
        msg.append(this.moveUnknown);
        msg.append("\n");
        msg.append("  verbose                : ");
        msg.append(this.verbose);
        msg.append("\n");
        msg.append("  wait                   : ");
        msg.append(this.wait);
        msg.append("\n");
        if (this.targetCodepage != null) {
            msg.append("  transform to codepage  : ");
            msg.append(this.targetCodepage.name());
            msg.append("\n");
        }
        msg.append("  detection algorithm    : ");
        msg.append("\n");
        msg.append(this.detector.toString());
        System.out.println(msg.toString());
    }

    protected void usage() {
        StringBuffer tmp = new StringBuffer();
        tmp.append("usage: java -cp jargs.jar;cpdetector_1.0.7.jar;antlr.jar;chardet.jar info.monitorenter.cpdetector.CodepageProcessor -r <testdocumentdir> -o <testoutputdir> [options]");
        tmp.append("\n");
        tmp.append("options: \n");
        tmp.append("\n  Optional:\n");
        tmp.append("  -c              : Only print available charsets on this system.\n");
        tmp.append("  -e <extensions> : A comma- or semicolon- separated string for document extensions like \"-e txt,dat\" (without dot or space!).\n");
        tmp.append("  -m              : Move files with unknown charset to directory \"unknown\".\n");
        tmp.append("  -v              : Verbose output.\n");
        tmp.append("  -w <int>        : Wait <int> seconds before trying next document (good, if you want to work on the very same machine).\n");
        tmp.append("  -t <charset>    : Try to transform the document to given charset (codepage) name. \n");
        tmp.append("                    This is only possible for documents that are detected to have a  \n");
        tmp.append("                    codepage that is supported by the current java VM. If not possible \n");
        tmp.append("                    sorting will be done as normal. \n");
        tmp.append("  -d              : Semicolon-separated list of fully qualified classnames. \n");
        tmp.append("                    These classes will be casted to ICodepageDetector instances \n");
        tmp.append("                    and used in the order specified.\n");
        tmp.append("                    If this argument is ommited, a HTMLCodepageDetector followed by .\n");
        tmp.append("                    a JChardetFacade is used by default.\n");
        tmp.append("  Mandatory (if no -c option given) :\n");
        tmp.append("  -r            : Root directory containing the collection (recursive).\n");
        tmp.append("  -o            : Output directory containing the sorted collection.\n");
        System.out.print(tmp.toString());
    }

    void loadCodepages() {
        SortedMap<String, Charset> charSets = Charset.availableCharsets();
        Iterator<Map.Entry<String, Charset>> csIt = charSets.entrySet().iterator();
        if (this.verbose) {
            System.out.println("Loading system codepages...");
        }
        this.parseCodepages = new Charset[charSets.size()];
        int index = 0;
        while (csIt.hasNext()) {
            Map.Entry<String, Charset> entry = csIt.next();
            Charset cs = entry.getValue();
            if (this.verbose) {
                System.out.println("Charset: " + cs.name());
                Set<String> aliases = cs.aliases();
                System.out.println("  Aliases: ");
                Iterator<String> aliasIt = aliases.iterator();
                while (aliasIt.hasNext()) {
                    System.out.println("    " + aliasIt.next().toString());
                }
            }
            this.parseCodepages[index] = cs;
            ++index;
        }
    }

    public static void main(String[] args) {
        CodepageProcessor sorter = new CodepageProcessor();
        try {
            sorter.parseArgs(args);
            try {
                sorter.process();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        catch (Exception e) {
            System.err.println("\nError: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }
}

