/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.cpdetector.util.collections.ui;

import info.monitorenter.cpdetector.util.collections.ui.ITableRenderer;
import java.io.IOException;
import java.io.Writer;
import javax.swing.table.TableModel;

public abstract class StreamTableRenderer
implements ITableRenderer {
    static final int FIRST_CELL_IN_ROW = 0;
    static final int LAST_CELL_IN_ROW = 1;
    protected Writer m_out;

    public StreamTableRenderer(Writer out) {
        this.m_out = out;
    }

    protected final void renderHeader(TableModel model) throws IOException {
        int cols = model.getColumnCount();
        for (int i = 0; i < cols; ++i) {
            this.renderHeaderCell(model.getColumnName(i), i == 0 ? 0 : (i == cols - 1 ? 1 : 2));
        }
    }

    private final void renderHeaderCell(String columnName, int firstOrLast) throws IOException {
        this.m_out.write(this.HeadCellStartTag(firstOrLast == 0));
        this.m_out.write(columnName);
        this.m_out.write(this.HeadCellStopTag(firstOrLast == 1));
    }

    protected abstract String HeadRowStartTag();

    protected abstract String HeadRowStopTag();

    protected abstract String HeadCellStopTag(boolean var1);

    protected abstract String HeadCellStartTag(boolean var1);

    protected final void renderRow(TableModel model, int row) throws IOException {
        this.m_out.write(this.RowStartTag());
        int cols = model.getColumnCount();
        for (int i = 0; i < cols; ++i) {
            this.renderCell(model.getValueAt(row, i), i == 0 ? 0 : (i == cols - 1 ? 1 : 2));
        }
        this.m_out.write(this.RowStopTag());
    }

    protected abstract String RowStartTag();

    protected abstract String RowStopTag();

    protected final void renderCell(Object content, int firstOrLast) throws IOException {
        this.m_out.write(this.CellStartTag(firstOrLast == 0));
        if (content instanceof TableModel) {
            this.render((TableModel)content);
        } else {
            this.m_out.write(content.toString());
        }
        this.m_out.write(this.CellStopTag(firstOrLast == 1));
    }

    protected abstract String CellStartTag(boolean var1);

    protected abstract String CellStopTag(boolean var1);

    public final void render(TableModel model) throws IOException {
        this.m_out.write(this.TableStartTag());
        int rows = model.getRowCount();
        this.m_out.write(this.HeadRowStartTag());
        this.renderHeader(model);
        this.m_out.write(this.HeadRowStopTag());
        for (int i = 0; i < rows; ++i) {
            this.renderRow(model, i);
        }
        this.m_out.write(this.TableStopTag());
    }

    protected abstract String TableStartTag();

    protected abstract String TableStopTag();
}

