/*
 * Decompiled with CFR 0.152.
 */
package org.jsuffixarrays;

import org.jsuffixarrays.ISuffixArrayBuilder;

public final class ExtraTrailingCellsDecorator
implements ISuffixArrayBuilder {
    private final ISuffixArrayBuilder delegate;
    private final int extraCells;

    public ExtraTrailingCellsDecorator(ISuffixArrayBuilder delegate, int extraCells) {
        this.delegate = delegate;
        this.extraCells = extraCells;
    }

    @Override
    public int[] buildSuffixArray(int[] input, int start, int length) {
        if (start == 0 && start + length + this.extraCells < input.length) {
            return this.delegate.buildSuffixArray(input, start, length);
        }
        int[] shifted = new int[input.length + this.extraCells];
        System.arraycopy(input, start, shifted, 0, length);
        int[] SA = this.delegate.buildSuffixArray(shifted, 0, length);
        return SA;
    }
}

