/*
 * Decompiled with CFR 0.152.
 */
package org.jsuffixarrays;

import org.jsuffixarrays.ISuffixArrayBuilder;
import org.jsuffixarrays.MinMax;
import org.jsuffixarrays.Tools;

public final class SAIS
implements ISuffixArrayBuilder {
    private static void getCounts(BaseArray T, BaseArray C, int n, int k) {
        int i;
        for (i = 0; i < k; ++i) {
            C.set(i, 0);
        }
        for (i = 0; i < n; ++i) {
            C.update(T.get(i), 1);
        }
    }

    private static void getBuckets(BaseArray C, BaseArray B, int k, boolean end) {
        int sum = 0;
        if (end) {
            for (int i = 0; i < k; ++i) {
                B.set(i, sum += C.get(i));
            }
        } else {
            for (int i = 0; i < k; ++i) {
                B.set(i, (sum += C.get(i)) - C.get(i));
            }
        }
    }

    private static void induceSA(BaseArray T, int[] SA, BaseArray C, BaseArray B, int n, int k) {
        int c0;
        int i;
        if (C == B) {
            SAIS.getCounts(T, C, n, k);
        }
        SAIS.getBuckets(C, B, k, false);
        int j = n - 1;
        int c1 = T.get(j);
        int b = B.get(c1);
        SA[b++] = 0 < j && T.get(j - 1) < c1 ? ~j : j;
        for (i = 0; i < n; ++i) {
            j = SA[i];
            SA[i] = ~j;
            if (0 >= j) continue;
            if ((c0 = T.get(--j)) != c1) {
                B.set(c1, b);
                c1 = c0;
                b = B.get(c1);
            }
            SA[b++] = 0 < j && T.get(j - 1) < c1 ? ~j : j;
        }
        if (C == B) {
            SAIS.getCounts(T, C, n, k);
        }
        SAIS.getBuckets(C, B, k, true);
        c1 = 0;
        b = B.get(0);
        for (i = n - 1; 0 <= i; --i) {
            j = SA[i];
            if (0 < j) {
                if ((c0 = T.get(--j)) != c1) {
                    B.set(c1, b);
                    c1 = c0;
                    b = B.get(c1);
                }
                SA[--b] = j == 0 || T.get(j - 1) > c1 ? ~j : j;
                continue;
            }
            SA[i] = ~j;
        }
    }

    private static int computeBWT(BaseArray T, int[] SA, BaseArray C, BaseArray B, int n, int k) {
        int c0;
        int i;
        int pidx = -1;
        if (C == B) {
            SAIS.getCounts(T, C, n, k);
        }
        SAIS.getBuckets(C, B, k, false);
        int j = n - 1;
        int c1 = T.get(j);
        int b = B.get(c1);
        SA[b++] = 0 < j && T.get(j - 1) < c1 ? ~j : j;
        for (i = 0; i < n; ++i) {
            j = SA[i];
            if (0 < j) {
                c0 = T.get(--j);
                SA[i] = ~c0;
                if (c0 != c1) {
                    B.set(c1, b);
                    c1 = c0;
                    b = B.get(c1);
                }
                SA[b++] = 0 < j && T.get(j - 1) < c1 ? ~j : j;
                continue;
            }
            if (j == 0) continue;
            SA[i] = ~j;
        }
        if (C == B) {
            SAIS.getCounts(T, C, n, k);
        }
        SAIS.getBuckets(C, B, k, true);
        c1 = 0;
        b = B.get(0);
        for (i = n - 1; 0 <= i; --i) {
            j = SA[i];
            if (0 < j) {
                SA[i] = c0 = T.get(--j);
                if (c0 != c1) {
                    B.set(c1, b);
                    c1 = c0;
                    b = B.get(c1);
                }
                SA[--b] = 0 < j && T.get(j - 1) > c1 ? ~T.get(j - 1) : j;
                continue;
            }
            if (j != 0) {
                SA[i] = ~j;
                continue;
            }
            pidx = i;
        }
        return pidx;
    }

    private static int SA_IS(BaseArray T, int[] SA, int fs, int n, int k, boolean isbwt) {
        int j;
        int p;
        int c0;
        int i;
        IntArray B;
        IntArray C;
        int pidx = 0;
        if (k <= fs) {
            C = new IntArray(SA, n);
            B = k <= fs - k ? new IntArray(SA, n + k) : C;
        } else {
            B = C = new IntArray(new int[k], 0);
        }
        SAIS.getCounts(T, C, n, k);
        SAIS.getBuckets(C, B, k, true);
        for (i = 0; i < n; ++i) {
            SA[i] = 0;
        }
        int c = 0;
        int c1 = T.get(n - 1);
        for (i = n - 2; 0 <= i; --i) {
            c0 = T.get(i);
            if (c0 < c1 + c) {
                c = 1;
            } else if (c != 0) {
                SA[B.update((int)c1, (int)-1)] = i + 1;
                c = 0;
            }
            c1 = c0;
        }
        SAIS.induceSA(T, SA, C, B, n, k);
        C = null;
        B = null;
        int m = 0;
        for (i = 0; i < n; ++i) {
            p = SA[i];
            if (0 >= p) continue;
            c0 = T.get(p);
            if (T.get(p - 1) <= c0) continue;
            for (j = p + 1; j < n && c0 == (c1 = T.get(j)); ++j) {
            }
            if (j >= n || c0 >= c1) continue;
            SA[m++] = p;
        }
        j = m + (n >> 1);
        for (i = m; i < j; ++i) {
            SA[i] = 0;
        }
        j = n;
        c = 0;
        c1 = T.get(n - 1);
        for (i = n - 2; 0 <= i; --i) {
            c0 = T.get(i);
            if (c0 < c1 + c) {
                c = 1;
            } else if (c != 0) {
                SA[m + (i + 1 >> 1)] = j - i - 1;
                j = i + 1;
                c = 0;
            }
            c1 = c0;
        }
        int name = 0;
        int q = n;
        int qlen = 0;
        for (i = 0; i < m; ++i) {
            p = SA[i];
            int plen = SA[m + (p >> 1)];
            boolean diff = true;
            if (plen == qlen) {
                for (j = 0; j < plen && T.get(p + j) == T.get(q + j); ++j) {
                }
                if (j == plen) {
                    diff = false;
                }
            }
            if (diff) {
                q = p;
                qlen = plen;
            }
            SA[m + (p >> 1)] = ++name;
        }
        if (name < m) {
            IntArray RA = new IntArray(SA, n + fs - m);
            j = n + fs - 1;
            for (i = m + (n >> 1) - 1; m <= i; --i) {
                if (SA[i] == 0) continue;
                SA[j--] = SA[i] - 1;
            }
            SAIS.SA_IS(RA, SA, fs + n - m * 2, m, name, false);
            RA = null;
            j = m * 2 - 1;
            c = 0;
            c1 = T.get(n - 1);
            for (i = n - 2; 0 <= i; --i) {
                c0 = T.get(i);
                if (c0 < c1 + c) {
                    c = 1;
                } else if (c != 0) {
                    SA[j--] = i + 1;
                    c = 0;
                }
                c1 = c0;
            }
            for (i = 0; i < m; ++i) {
                SA[i] = SA[SA[i] + m];
            }
        }
        if (k <= fs) {
            C = new IntArray(SA, n);
            B = k <= fs - k ? new IntArray(SA, n + k) : C;
        } else {
            B = C = new IntArray(new int[k], 0);
        }
        SAIS.getCounts(T, C, n, k);
        SAIS.getBuckets(C, B, k, true);
        for (i = m; i < n; ++i) {
            SA[i] = 0;
        }
        for (i = m - 1; 0 <= i; --i) {
            j = SA[i];
            SA[i] = 0;
            SA[B.update((int)T.get((int)j), (int)-1)] = j;
        }
        if (!isbwt) {
            SAIS.induceSA(T, SA, C, B, n, k);
        } else {
            pidx = SAIS.computeBWT(T, SA, C, B, n, k);
        }
        C = null;
        B = null;
        return pidx;
    }

    public static int suffixsort(byte[] T, int[] SA, int n) {
        if (T == null || SA == null || T.length < n || SA.length < n) {
            return -1;
        }
        if (n <= 1) {
            if (n == 1) {
                SA[0] = 0;
            }
            return 0;
        }
        return SAIS.SA_IS(new ByteArray(T, 0), SA, 0, n, 256, false);
    }

    public static int suffixsort(char[] T, int[] SA, int n) {
        if (T == null || SA == null || T.length < n || SA.length < n) {
            return -1;
        }
        if (n <= 1) {
            if (n == 1) {
                SA[0] = 0;
            }
            return 0;
        }
        return SAIS.SA_IS(new CharArray(T, 0), SA, 0, n, 65536, false);
    }

    public static int suffixsort(short[] T, int[] SA, int n, int k) {
        if (T == null || SA == null || T.length < n || SA.length < n || k <= 0 || 65536 < k) {
            return -1;
        }
        if (n <= 1) {
            if (n == 1) {
                SA[0] = 0;
            }
            return 0;
        }
        return SAIS.SA_IS(new ShortArray(T, 0), SA, 0, n, k, false);
    }

    public static int suffixsort(int[] T, int[] SA, int n, int k) {
        if (T == null || SA == null || T.length < n || SA.length < n || k <= 0) {
            return -1;
        }
        if (n <= 1) {
            if (n == 1) {
                SA[0] = 0;
            }
            return 0;
        }
        return SAIS.SA_IS(new IntArray(T, 0), SA, 0, n, k, false);
    }

    public static int suffixsort(String T, int[] SA, int n) {
        if (T == null || SA == null || T.length() < n || SA.length < n) {
            return -1;
        }
        if (n <= 1) {
            if (n == 1) {
                SA[0] = 0;
            }
            return 0;
        }
        return SAIS.SA_IS(new StringArray(T, 0), SA, 0, n, 65536, false);
    }

    public static int bwtransform(byte[] T, byte[] U, int[] A, int n) {
        int i;
        if (T == null || U == null || A == null || T.length < n || U.length < n || A.length < n) {
            return -1;
        }
        if (n <= 1) {
            if (n == 1) {
                U[0] = T[0];
            }
            return n;
        }
        int pidx = SAIS.SA_IS(new ByteArray(T, 0), A, 0, n, 256, true);
        U[0] = T[n - 1];
        for (i = 0; i < pidx; ++i) {
            U[i + 1] = (byte)(A[i] & 0xFF);
        }
        ++i;
        while (i < n) {
            U[i] = (byte)(A[i] & 0xFF);
            ++i;
        }
        return pidx + 1;
    }

    public static int bwtransform(char[] T, char[] U, int[] A, int n) {
        int i;
        if (T == null || U == null || A == null || T.length < n || U.length < n || A.length < n) {
            return -1;
        }
        if (n <= 1) {
            if (n == 1) {
                U[0] = T[0];
            }
            return n;
        }
        int pidx = SAIS.SA_IS(new CharArray(T, 0), A, 0, n, 65536, true);
        U[0] = T[n - 1];
        for (i = 0; i < pidx; ++i) {
            U[i + 1] = (char)(A[i] & 0xFFFF);
        }
        ++i;
        while (i < n) {
            U[i] = (char)(A[i] & 0xFFFF);
            ++i;
        }
        return pidx + 1;
    }

    public static int bwtransform(short[] T, short[] U, int[] A, int n, int k) {
        int i;
        if (T == null || U == null || A == null || T.length < n || U.length < n || A.length < n || 0 <= k || 65536 < k) {
            return -1;
        }
        if (n <= 1) {
            if (n == 1) {
                U[0] = T[0];
            }
            return n;
        }
        int pidx = SAIS.SA_IS(new ShortArray(T, 0), A, 0, n, k, true);
        U[0] = T[n - 1];
        for (i = 0; i < pidx; ++i) {
            U[i + 1] = (short)(A[i] & 0xFFFF);
        }
        ++i;
        while (i < n) {
            U[i] = (short)(A[i] & 0xFFFF);
            ++i;
        }
        return pidx + 1;
    }

    public static int bwtransform(int[] T, int[] U, int[] A, int n, int k) {
        int i;
        if (T == null || U == null || A == null || T.length < n || U.length < n || A.length < n || 0 <= k) {
            return -1;
        }
        if (n <= 1) {
            if (n == 1) {
                U[0] = T[0];
            }
            return n;
        }
        int pidx = SAIS.SA_IS(new IntArray(T, 0), A, 0, n, k, true);
        U[0] = T[n - 1];
        for (i = 0; i < pidx; ++i) {
            U[i + 1] = A[i];
        }
        ++i;
        while (i < n) {
            U[i] = A[i];
            ++i;
        }
        return pidx + 1;
    }

    @Override
    public int[] buildSuffixArray(int[] input, int start, int length) {
        int[] SA = new int[length];
        MinMax mm = Tools.minmax(input, start, length);
        SAIS.suffixsort(input, SA, length, mm.max + 1);
        return SA;
    }

    private static final class StringArray
    implements BaseArray {
        private String m_A;
        private int m_pos;

        StringArray(String A, int pos) {
            this.m_A = A;
            this.m_pos = pos;
        }

        @Override
        public int get(int i) {
            return this.m_A.charAt(this.m_pos + i) & 0xFFFF;
        }

        @Override
        public void set(int i, int val) {
        }

        @Override
        public int update(int i, int val) {
            return 0;
        }
    }

    private static final class IntArray
    implements BaseArray {
        private int[] m_A;
        private int m_pos;

        IntArray(int[] A, int pos) {
            this.m_A = A;
            this.m_pos = pos;
        }

        @Override
        public int get(int i) {
            return this.m_A[this.m_pos + i];
        }

        @Override
        public void set(int i, int val) {
            this.m_A[this.m_pos + i] = val;
        }

        @Override
        public int update(int i, int val) {
            int n = this.m_pos + i;
            int n2 = this.m_A[n] + val;
            this.m_A[n] = n2;
            return n2;
        }
    }

    private static final class ShortArray
    implements BaseArray {
        private short[] m_A;
        private int m_pos;

        ShortArray(short[] A, int pos) {
            this.m_A = A;
            this.m_pos = pos;
        }

        @Override
        public int get(int i) {
            return this.m_A[this.m_pos + i] & 0xFFFF;
        }

        @Override
        public void set(int i, int val) {
            this.m_A[this.m_pos + i] = (short)(val & 0xFFFF);
        }

        @Override
        public int update(int i, int val) {
            int n = this.m_pos + i;
            short s = (short)(this.m_A[n] + (val & 0xFFFF));
            this.m_A[n] = s;
            return s;
        }
    }

    private static final class CharArray
    implements BaseArray {
        private char[] m_A;
        private int m_pos;

        CharArray(char[] A, int pos) {
            this.m_A = A;
            this.m_pos = pos;
        }

        @Override
        public int get(int i) {
            return this.m_A[this.m_pos + i] & 0xFFFF;
        }

        @Override
        public void set(int i, int val) {
            this.m_A[this.m_pos + i] = (char)(val & 0xFFFF);
        }

        @Override
        public int update(int i, int val) {
            int n = this.m_pos + i;
            char c = (char)(this.m_A[n] + (val & 0xFFFF));
            this.m_A[n] = c;
            return c;
        }
    }

    private static final class ByteArray
    implements BaseArray {
        private byte[] m_A;
        private int m_pos;

        ByteArray(byte[] A, int pos) {
            this.m_A = A;
            this.m_pos = pos;
        }

        @Override
        public int get(int i) {
            return this.m_A[this.m_pos + i] & 0xFF;
        }

        @Override
        public void set(int i, int val) {
            this.m_A[this.m_pos + i] = (byte)(val & 0xFF);
        }

        @Override
        public int update(int i, int val) {
            int n = this.m_pos + i;
            byte by = (byte)(this.m_A[n] + (val & 0xFF));
            this.m_A[n] = by;
            return by;
        }
    }

    private static interface BaseArray {
        public int get(int var1);

        public void set(int var1, int var2);

        public int update(int var1, int var2);
    }
}

